// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.AsyncSearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.AsyncSearch.Json.AsyncSearchStatusResponseConverter))]
public sealed partial class AsyncSearchStatusResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AsyncSearchStatusResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AsyncSearchStatusResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Metadata about clusters involved in the cross-cluster search.
	/// It is not shown for local-only searches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ClusterStatistics? Clusters { get; set; }

	/// <summary>
	/// <para>
	/// If the async search completed, this field shows the status code of the search.
	/// For example, <c>200</c> indicates that the async search was successfully completed.
	/// <c>503</c> indicates that the async search was completed with an error.
	/// </para>
	/// </summary>
	public int? CompletionStatus { get; set; }

	/// <summary>
	/// <para>
	/// Indicates when the async search completed.
	/// It is present only when the search has completed.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? CompletionTime { get; set; }
	public System.DateTimeOffset? CompletionTimeInMillis { get; set; }

	/// <summary>
	/// <para>
	/// Indicates when the async search will expire.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? ExpirationTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset ExpirationTimeInMillis { get; set; }
	public string? Id { get; set; }

	/// <summary>
	/// <para>
	/// When the query is no longer running, this property indicates whether the search failed or was successfully completed on all shards.
	/// While the query is running, <c>is_partial</c> is always set to <c>true</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IsPartial { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the search is still running or has completed.
	/// </para>
	/// <para>
	/// info
	/// If the search failed after some shards returned their results or the node that is coordinating the async search dies, results may be partial even though <c>is_running</c> is <c>false</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool IsRunning { get; set; }

	/// <summary>
	/// <para>
	/// The number of shards that have run the query so far.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ShardStatistics Shards { get; set; }
	public System.DateTimeOffset? StartTime { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset StartTimeInMillis { get; set; }
}