// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.AsyncSearch;

public sealed partial class AsyncSearchStatusRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The length of time that the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }
}

/// <summary>
/// <para>
/// Get the async search status.
/// </para>
/// <para>
/// Get the status of a previously submitted async search request given its identifier, without retrieving search results.
/// If the Elasticsearch security features are enabled, the access to the status of a specific async search is restricted to:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The user or API key that submitted the original async search request.
/// </para>
/// </item>
/// <item>
/// <para>
/// Users that have the <c>monitor</c> cluster privilege or greater privileges.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.AsyncSearch.Json.AsyncSearchStatusRequestConverter))]
public sealed partial class AsyncSearchStatusRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AsyncSearchStatusRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public AsyncSearchStatusRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AsyncSearchStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.AsyncSearchStatus;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "async_search.status";

	/// <summary>
	/// <para>
	/// A unique identifier for the async search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The length of time that the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }
}

/// <summary>
/// <para>
/// Get the async search status.
/// </para>
/// <para>
/// Get the status of a previously submitted async search request given its identifier, without retrieving search results.
/// If the Elasticsearch security features are enabled, the access to the status of a specific async search is restricted to:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The user or API key that submitted the original async search request.
/// </para>
/// </item>
/// <item>
/// <para>
/// Users that have the <c>monitor</c> cluster privilege or greater privileges.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct AsyncSearchStatusRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AsyncSearchStatusRequestDescriptor(Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest instance)
	{
		Instance = instance;
	}

	public AsyncSearchStatusRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public AsyncSearchStatusRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor(Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest instance) => new Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest(Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A unique identifier for the async search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The length of time that the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest Build(System.Action<Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor(new Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.AsyncSearchStatusRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}