/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.sina.params;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.BaseMediaObject;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MusicObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.VideoObject;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.sina.helper.Base64;
import com.umeng.socialize.sina.helper.MD5;
import com.umeng.socialize.sina.message.BaseRequest;
import com.umeng.socialize.sina.params.BrowserRequestParamBase;
import com.umeng.socialize.sina.params.WeiboParameters;
import com.umeng.socialize.sina.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareRequestParam
extends BrowserRequestParamBase {
    private static final String SHARE_URL = "http://service.weibo.com/share/mobilesdk.php";
    public static final String UPLOAD_PIC_URL = "http://service.weibo.com/share/mobilesdk_uppic.php";
    public static final String REQ_PARAM_TITLE = "title";
    public static final String REQ_PARAM_VERSION = "version";
    public static final String REQ_PARAM_SOURCE = "source";
    public static final String REQ_PARAM_AID = "aid";
    public static final String REQ_PARAM_PACKAGENAME = "packagename";
    public static final String REQ_PARAM_KEY_HASH = "key_hash";
    public static final String REQ_PARAM_TOKEN = "access_token";
    public static final String REQ_PARAM_PICINFO = "picinfo";
    public static final String REQ_UPLOAD_PIC_PARAM_IMG = "img";
    public static final String RESP_UPLOAD_PIC_PARAM_CODE = "code";
    public static final String RESP_UPLOAD_PIC_PARAM_DATA = "data";
    public static final int RESP_UPLOAD_PIC_SUCC_CODE = 1;
    private UMShareListener shareListener;
    private String mAuthListenerKey;
    private String mAppPackage;
    private String mToken;
    private String mAppKey;
    private String mHashKey;
    private BaseRequest mBaseRequest;
    private String mShareContent;
    private byte[] mBase64ImgData;

    public ShareRequestParam(Context context) {
        super(context);
    }

    @Override
    protected void onSetupRequestParam(Bundle bundle) {
        this.mAppKey = bundle.getString(REQ_PARAM_SOURCE);
        this.mAppPackage = bundle.getString(REQ_PARAM_PACKAGENAME);
        this.mHashKey = bundle.getString(REQ_PARAM_KEY_HASH);
        this.mToken = bundle.getString(REQ_PARAM_TOKEN);
        this.mAuthListenerKey = bundle.getString("key_listener");
        this.handleSharedMessage(bundle);
        this.mUrl = this.buildUrl("");
    }

    private void handleSharedMessage(Bundle bundle) {
        BaseMediaObject baseMediaObject;
        ImageObject imageObject;
        TextObject textObject;
        WeiboMultiMessage weiboMultiMessage = new WeiboMultiMessage();
        weiboMultiMessage.toObject(bundle);
        StringBuilder stringBuilder = new StringBuilder();
        if (weiboMultiMessage.textObject instanceof TextObject) {
            textObject = weiboMultiMessage.textObject;
            stringBuilder.append(textObject.text);
        }
        if (weiboMultiMessage.imageObject instanceof ImageObject) {
            imageObject = weiboMultiMessage.imageObject;
            this.handleMblogPic(imageObject.imagePath, imageObject.imageData);
        }
        if (weiboMultiMessage.mediaObject instanceof TextObject) {
            textObject = (TextObject)weiboMultiMessage.mediaObject;
            stringBuilder.append(textObject.text);
        }
        if (weiboMultiMessage.mediaObject instanceof ImageObject) {
            imageObject = (ImageObject)weiboMultiMessage.mediaObject;
            this.handleMblogPic(imageObject.imagePath, imageObject.imageData);
        }
        if (weiboMultiMessage.mediaObject instanceof WebpageObject) {
            baseMediaObject = (WebpageObject)weiboMultiMessage.mediaObject;
            stringBuilder.append(" ").append(baseMediaObject.actionUrl);
        }
        if (weiboMultiMessage.mediaObject instanceof MusicObject) {
            baseMediaObject = (MusicObject)weiboMultiMessage.mediaObject;
            stringBuilder.append(" ").append(((MusicObject)baseMediaObject).actionUrl);
        }
        if (weiboMultiMessage.mediaObject instanceof VideoObject) {
            baseMediaObject = (VideoObject)weiboMultiMessage.mediaObject;
            stringBuilder.append(" ").append(((VideoObject)baseMediaObject).actionUrl);
        }
        if (weiboMultiMessage.mediaObject instanceof VoiceObject) {
            baseMediaObject = (VoiceObject)weiboMultiMessage.mediaObject;
            stringBuilder.append(" ").append(((VoiceObject)baseMediaObject).actionUrl);
        }
        this.mShareContent = stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMblogPic(String string, byte[] byArray) {
        block15: {
            try {
                File file;
                if (TextUtils.isEmpty((CharSequence)string) || !(file = new File(string)).exists() || !file.canRead() || file.length() <= 0L) break block15;
                byte[] byArray2 = new byte[(int)file.length()];
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileInputStream.read(byArray2);
                    this.mBase64ImgData = Base64.encodebyte(byArray2);
                }
                catch (IOException iOException) {
                    Object var7_9 = null;
                    break block15;
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (byArray != null && byArray.length > 0) {
            this.mBase64ImgData = Base64.encodebyte(byArray);
        }
    }

    @Override
    public void onCreateRequestParamBundle(Bundle bundle) {
        if (this.mBaseRequest != null) {
            this.mBaseRequest.toBundle(bundle);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            this.mHashKey = MD5.hexdigest(Utility.getSign(this.mContext, this.mAppPackage));
        }
        bundle.putString(REQ_PARAM_TOKEN, this.mToken);
        bundle.putString(REQ_PARAM_SOURCE, this.mAppKey);
        bundle.putString(REQ_PARAM_PACKAGENAME, this.mAppPackage);
        bundle.putString(REQ_PARAM_KEY_HASH, this.mHashKey);
        bundle.putString("_weibo_appPackage", this.mAppPackage);
        bundle.putString("_weibo_appKey", this.mAppKey);
        bundle.putInt("_weibo_flag", 538116905);
        bundle.putString("_weibo_sign", this.mHashKey);
    }

    @Override
    public void execRequest(Activity activity, int n) {
        if (n == 3) {
            this.sendSdkCancleResponse(activity);
        }
    }

    public boolean hasImage() {
        return this.mBase64ImgData != null && this.mBase64ImgData.length > 0;
    }

    public WeiboParameters buildUploadPicParam(WeiboParameters weiboParameters) {
        if (!this.hasImage()) {
            return weiboParameters;
        }
        String string = new String(this.mBase64ImgData);
        weiboParameters.put(REQ_UPLOAD_PIC_PARAM_IMG, string);
        return weiboParameters;
    }

    public String buildUrl(String string) {
        String string2;
        Uri uri = Uri.parse((String)SHARE_URL);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter(REQ_PARAM_TITLE, this.mShareContent);
        builder.appendQueryParameter(REQ_PARAM_VERSION, "0031205000");
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            builder.appendQueryParameter(REQ_PARAM_SOURCE, this.mAppKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mToken)) {
            builder.appendQueryParameter(REQ_PARAM_TOKEN, this.mToken);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = Utility.getAid(this.mContext, this.mAppKey)))) {
            builder.appendQueryParameter(REQ_PARAM_AID, string2);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            builder.appendQueryParameter(REQ_PARAM_PACKAGENAME, this.mAppPackage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mHashKey)) {
            builder.appendQueryParameter(REQ_PARAM_KEY_HASH, this.mHashKey);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.appendQueryParameter(REQ_PARAM_PICINFO, string);
        }
        return builder.build().toString();
    }

    private void sendSdkResponse(Activity activity, int n, String string) {
        Bundle bundle = activity.getIntent().getExtras();
        if (bundle != null) {
            Intent intent = new Intent("com.sina.weibo.sdk.action.ACTION_SDK_REQ_ACTIVITY");
            intent.setFlags(131072);
            intent.setPackage(bundle.getString("_weibo_appPackage"));
            intent.putExtras(bundle);
            intent.putExtra("_weibo_appPackage", activity.getPackageName());
            intent.putExtra("_weibo_resp_errcode", n);
            intent.putExtra("_weibo_resp_errstr", string);
            try {
                activity.startActivityForResult(intent, 765);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
    }

    public void sendSdkCancleResponse(Activity activity) {
        this.sendSdkResponse(activity, 1, "send cancel!!!");
    }

    public void sendSdkOkResponse(Activity activity) {
        this.sendSdkResponse(activity, 0, "send ok!!!");
    }

    public void sendSdkErrorResponse(Activity activity, String string) {
        this.sendSdkResponse(activity, 2, string);
    }

    public void setBaseRequest(BaseRequest baseRequest) {
        this.mBaseRequest = baseRequest;
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public void setAppPackage(String string) {
        this.mAppPackage = string;
    }

    public String getToken() {
        return this.mToken;
    }

    public void setToken(String string) {
        this.mToken = string;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public void setAppKey(String string) {
        this.mAppKey = string;
    }

    public String getHashKey() {
        return this.mHashKey;
    }

    public String getShareContent() {
        return this.mShareContent;
    }

    public byte[] getBase64ImgData() {
        return this.mBase64ImgData;
    }

    public String getAuthListenerKey() {
        return this.mAuthListenerKey;
    }

    public static class UploadPicResult {
        private int code = -2;
        private String picId;

        private UploadPicResult() {
        }

        public int getCode() {
            return this.code;
        }

        public String getPicId() {
            return this.picId;
        }

        public static UploadPicResult parse(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            UploadPicResult uploadPicResult = new UploadPicResult();
            try {
                JSONObject jSONObject = new JSONObject(string);
                uploadPicResult.code = jSONObject.optInt(ShareRequestParam.RESP_UPLOAD_PIC_PARAM_CODE, -2);
                uploadPicResult.picId = jSONObject.optString(ShareRequestParam.RESP_UPLOAD_PIC_PARAM_DATA, "");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return uploadPicResult;
        }
    }
}

