# 算法专题

以下是一些我总结的类型题目，提前搞懂这些东西对之后的做题很有帮助，强烈建议先掌握。另外我的 91 天学算法也对专题进行了更细粒度的整理，具体参见[91 天学算法](../91/README.md)

首先基础的数据结构大家是必须掌握的，其次就是暴力法。暴力法也是算法，只不过我们追求的肯定是性能更好的算法。因此了解暴力法的算法瓶颈以及各种数据结构的特点就很重要， 这样你就可以根据这些知识去一步步逼近最优解。

再之后就是必须掌握的算法。比如搜索算法是必须掌握的，搜索算法的范围很广，但是核心就是搜索的，不同的算法在于搜索的方式不同，典型的就是 BFS 和 DFS，当然二分法本质上也是一种搜索算法。

还有就是暴力优化法也是必须掌握的，和搜索一样，范围很广。 有剪枝， 空间换时间等。 其中空间换时间又有很多，比如哈希表， 前缀树等等。

围绕这个思想去学习， 就不会差太多，其他我就不多说，大家慢慢体会。

- [数据结构总览](basic-data-structure.md)
- [链表专题](linked-list.md)
- [树专题](tree.md)
- [堆专题（上）](heap.md)
- [堆专题（下）](heap-2.md)
- [二分专题（上）](binary-search-1.md)
- [二分专题（下）](binary-search-2.md)
- [二叉树的遍历](binary-tree-traversal.md)
- [动态规划](dynamic-programming.md)
- [回溯](backtrack.md)
- [哈夫曼编码和游程编码](run-length-encode-and-huffman-encode.md)
- [布隆过滤器](bloom-filter.md)🖊
- [前缀树](trie.md)🖊
- [《日程安排》专题](https://lucifer.ren/blog/2020/02/03/leetcode-%E6%88%91%E7%9A%84%E6%97%A5%E7%A8%8B%E5%AE%89%E6%8E%92%E8%A1%A8%E7%B3%BB%E5%88%97/)
- [《构造二叉树》专题](https://lucifer.ren/blog/2020/02/08/%E6%9E%84%E9%80%A0%E4%BA%8C%E5%8F%89%E6%A0%91%E4%B8%93%E9%A2%98/)
- [滑动窗口（思路 + 模板）](slide-window.md)
- [位运算](bit.md)
- [小岛问题](island.md)🖊
- [最大公约数](GCD.md)
- [并查集](union-find.md)
- [平衡二叉树专题](balanced-tree.md)
- [蓄水池抽样](reservoid-sampling.md)
- [单调栈](monotone-stack.md)
