## 题目地址(909. 蛇梯棋)

https://leetcode-cn.com/problems/snakes-and-ladders/

## 题目描述

```
N x N 的棋盘 board 上，按从 1 到 N*N 的数字给方格编号，编号 从左下角开始，每一行交替方向。

例如，一块 6 x 6 大小的棋盘，编号如下：




r 行 c 列的棋盘，按前述方法编号，棋盘格中可能存在 “蛇” 或 “梯子”；如果 board[r][c] != -1，那个蛇或梯子的目的地将会是 board[r][c]。

玩家从棋盘上的方格 1 （总是在最后一行、第一列）开始出发。

每一回合，玩家需要从当前方格 x 开始出发，按下述要求前进：

选定目标方格：选择从编号 x+1，x+2，x+3，x+4，x+5，或者 x+6 的方格中选出一个目标方格 s ，目标方格的编号 <= N*N。
该选择模拟了掷骰子的情景，无论棋盘大小如何，你的目的地范围也只能处于区间 [x+1, x+6] 之间。
传送玩家：如果目标方格 S 处存在蛇或梯子，那么玩家会传送到蛇或梯子的目的地。否则，玩家传送到目标方格 S。 

注意，玩家在每回合的前进过程中最多只能爬过蛇或梯子一次：就算目的地是另一条蛇或梯子的起点，你也不会继续移动。

返回达到方格 N*N 所需的最少移动次数，如果不可能，则返回 -1。

 

示例：

输入：[
[-1,-1,-1,-1,-1,-1],
[-1,-1,-1,-1,-1,-1],
[-1,-1,-1,-1,-1,-1],
[-1,35,-1,-1,13,-1],
[-1,-1,-1,-1,-1,-1],
[-1,15,-1,-1,-1,-1]]
输出：4
解释：
首先，从方格 1 [第 5 行，第 0 列] 开始。
你决定移动到方格 2，并必须爬过梯子移动到到方格 15。
然后你决定移动到方格 17 [第 3 行，第 5 列]，必须爬过蛇到方格 13。
然后你决定移动到方格 14，且必须通过梯子移动到方格 35。
然后你决定移动到方格 36, 游戏结束。
可以证明你需要至少 4 次移动才能到达第 N*N 个方格，所以答案是 4。


 

提示：

2 <= board.length = board[0].length <= 20
board[i][j] 介于 1 和 N*N 之间或者等于 -1。
编号为 1 的方格上没有蛇或梯子。
编号为 N*N 的方格上没有蛇或梯子。
```

## 前置知识

- 广度优先遍历

## 公司

- 暂无

## 思路

起点和终点已知，并且目标是求最短，容易想到使用广度优先遍历进行求解。

初始化队列 [1] ， 不断模拟直到到达 n \* n ，返回当前的步数即可。

也就是说我们直接套用 BFS 模板，对题目进行模拟就行了。

不过本题有两点需要大家注意。

需要注意的是，由于队列的项目都是单元格的编号。而题目给了一个二维矩阵，我们需要在模拟过程中根据当前的位置从二维矩阵取值。那么如何根据编号求出所在的行号和列号呢?

我们尝试先将问题简化。 题目给的其实是从左下角开始编号，并且相邻行起点是交替的，比如上一行从左开始，下一行就从右开始，从 1 到 n \* n。

那么如果题目变为从左上角开始，并且永远只从左到右编号呢？

其实这样问题会稍微简单一点。这样的话其实编号 number 就等于 (row - 1) \* n + col。

接下来，我们考虑行交替编号问题。 其实我们只需要考虑当前行（从 1 开始）是奇数还是偶数就行了，如果是奇数那么就是 (row - 1) _ n + col，否则就是 n - (row - 1) _ n + col。

同理，如果从右下角开始。 问题就不再看是奇数行还是偶数行了，而是奇偶性是否和最后一行一致（最后一行也就是我们刚开始的那一行）。如果一直就是 (row - 1) _ n + col，否则就是 n - (row - 1) _ n + col。

> 实际上，上面核心看的也是奇偶性是否一致。只不过从奇数行和偶数行角度也可以解释地通。

## 关键点

- 根据矩阵编号如何算出其都在的行号和列号。这里其实用到了 number = (row - 1) \* n + col 这样的一个公式，后面的所有公式都是基于它产生的。

## 代码

- 语言支持：Python3

Python3 Code:

```python

class Solution:
    def snakesAndLadders(self, board: List[List[int]]) -> int:
        q = collections.deque([(1, 0)])
        n = len(board)
        visited = set()

        def get_pos(pos):
            row = (n - 1) - (pos - 1) // n
            col = (n - 1) - ((pos - 1) % n) if row & 1 == n & 1 else (pos - 1) % n
            return row, col

        while q:
            for _ in range(len(q)):
                cur, steps = q.popleft()
                if cur in visited:
                    continue
                visited.add(cur)
                if cur == n ** 2:
                    return steps
                for nxt in range(cur + 1, min(cur + 6, n * n) + 1):
                    row, col = get_pos(nxt)
                    if board[row][col] == -1:
                        q.append((nxt, steps + 1))
                    else:
                        q.append((board[row][col], steps + 1))
        return -1

```

**复杂度分析**

- 时间复杂度：$O(n^2)$
- 空间复杂度：$O(n^2)$

> 此题解由 [力扣刷题插件](https://leetcode-pp.github.io/leetcode-cheat/?tab=solution-template) 自动生成。

力扣的小伙伴可以[关注我](https://leetcode-cn.com/u/fe-lucifer/)，这样就会第一时间收到我的动态啦~

以上就是本文的全部内容了。大家对此有何看法，欢迎给我留言，我有时间都会一一查看回答。更多算法套路可以访问我的 LeetCode 题解仓库：https://github.com/azl397985856/leetcode 。 目前已经 40K star 啦。大家也可以关注我的公众号《力扣加加》带你啃下算法这块硬骨头。

关注公众号力扣加加，努力用清晰直白的语言还原解题思路，并且有大量图解，手把手教你识别套路，高效刷题。

![](https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg)
