## 题目地址（80.删除排序数组中的重复项 II）

https://leetcode-cn.com/problems/remove-duplicates-from-sorted-array-ii/

## 题目描述

```
给定一个排序数组，你需要在原地删除重复出现的元素，使得每个元素最多出现两次，返回移除后数组的新长度。

不要使用额外的数组空间，你必须在原地修改输入数组并在使用 O(1) 额外空间的条件下完成。

示例 1:

给定 nums = [1,1,1,2,2,3],

函数应返回新长度 length = 5, 并且原数组的前五个元素被修改为 1, 1, 2, 2, 3 。

你不需要考虑数组中超出新长度后面的元素。
示例 2:

给定 nums = [0,0,1,1,1,1,2,3,3],

函数应返回新长度 length = 7, 并且原数组的前五个元素被修改为 0, 0, 1, 1, 2, 3, 3 。

你不需要考虑数组中超出新长度后面的元素。
说明:

为什么返回数值是整数，但输出的答案是数组呢?

请注意，输入数组是以“引用”方式传递的，这意味着在函数里修改输入数组对于调用者是可见的。

你可以想象内部操作如下:

// nums 是以“引用”方式传递的。也就是说，不对实参做任何拷贝
int len = removeDuplicates(nums);

// 在函数里修改输入数组对于调用者是可见的。
// 根据你的函数返回的长度, 它会打印出数组中该长度范围内的所有元素。
for (int i = 0; i < len; i++) {
    print(nums[i]);
}

```

## 前置知识

- 双指针

## 公司

- 阿里
- 百度
- 字节

## 思路

”删除排序“类题目截止到现在（2020-1-15）一共有四道题：

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlu0jxjeej30x60cedh0.jpg)

这道题是[26.remove-duplicates-from-sorted-array](./26.remove-duplicates-from-sorted-array.md) 的进阶版本，唯一的不同是不再是全部元素唯一，而是全部元素不超过 2 次。实际上这种问题可以更抽象一步，即“删除排序数组中的重复项，使得相同数字最多出现 k 次”
。 那么这道题 k 就是 2， 26.remove-duplicates-from-sorted-array 的 k 就是 1。

上一题我们使用了快慢指针来实现，这道题也是一样，只不过逻辑稍有不同。 其实快慢指针本质是读写指针，在这里我们的快指针实际上就是读指针，而慢指针恰好相当于写指针。”快慢指针的说法“便于描述和记忆，“读写指针”的说法更便于理解本质。本文中，以下内容均描述为快慢指针。

- 初始化快慢指针 slow ， fast ，全部指向索引为 0 的元素。
- fast 每次移动一格
- 慢指针选择性移动，即只有写入数据之后才移动。是否写入数据取决于 slow - 2 对应的数字和 fast 对应的数字是否一致。
- 如果一致，我们不应该写。 否则我们就得到了三个相同的数字，不符合题意
- 如果不一致，我们需要将 fast 指针的数据写入到 slow 指针。
- 重复这个过程，直到 fast 走到头，说明我们已无数字可写。

图解（红色的两个数字，表示我们需要比较的两个数字）：

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlu0p8ea3j30n10hpmy4.jpg)

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlu0r18z0j30ga088mxh.jpg)

## 关键点分析

- 快慢指针
- 读写指针
- 删除排序问题

## 代码

代码支持： Python, CPP

Python Code：

```python
class Solution:
    def removeDuplicates(self, nums: List[int]) -> int:
        # 写指针
        i = 0
        K = 2
        for num in nums:
            if i < K or num != nums[i-K]:
                nums[i] = num
                i += 1
        return i
```

CPP Code:

```cpp
class Solution {
public:
    int removeDuplicates(vector<int>& nums) {
        int i = 0;
        int k = 2;
        for (int num : nums) {
            if (i < k || num != nums[i - k]) {
                nums[i] = num;
                i++;
            }
        }
        return i;
    }
};
```

**复杂度分析**

令 n 为数组长度。

- 时间复杂度：$O(n)$
- 空间复杂度：$O(1)$

基于这套代码，你可以轻易地实现 k 为任意正整数的算法。

## 相关题目

正如上面所说，相关题目一共有三道（排除自己）。其中一道我们仓库已经讲到了。剩下两道原理类似，但是实际代码和细节有很大不同，原因就在于数组可以随机访问，而链表不行。 感兴趣的可以做一下剩下的两道链表题。

- 82. 删除排序链表中的重复元素 II

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlu0s4jb3j31lq0tgq7m.jpg)

- 83. 删除排序链表中的重复元素

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlu0vrcvlj318c0se0wm.jpg)

大家对此有何看法，欢迎给我留言，我有时间都会一一查看回答。更多算法套路可以访问我的 LeetCode 题解仓库：https://github.com/azl397985856/leetcode 。 目前已经 37K star 啦。
大家也可以关注我的公众号《力扣加加》带你啃下算法这块硬骨头。
![](https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg)
