## 题目地址

https://leetcode-cn.com/problems/unique-paths-ii/

## 题目描述

```

一个机器人位于一个 m x n 网格的左上角 （起始点在下图中标记为“Start” ）。

机器人每次只能向下或者向右移动一步。机器人试图达到网格的右下角（在下图中标记为“Finish”）。

现在考虑网格中有障碍物。那么从左上角到右下角将会有多少条不同的路径？
```

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghludv12xej30b40533yf.jpg)

```
网格中的障碍物和空位置分别用 1 和 0 来表示。

说明：m 和 n 的值均不超过 100。

示例 1:

输入:
[
  [0,0,0],
  [0,1,0],
  [0,0,0]
]
输出: 2
解释:
3x3 网格的正中间有一个障碍物。
从左上角到右下角一共有 2 条不同的路径：
1. 向右 -> 向右 -> 向下 -> 向下
2. 向下 -> 向下 -> 向右 -> 向右

```

## 前置知识

- 动态规划

## 公司

- 阿里
- 腾讯
- 百度
- 字节

## 思路

这是一道典型的适合使用动态规划解决的题目，它和爬楼梯等都属于动态规划中最简单的题目，因此也经常会被用于面试之中。

读完题目你就能想到动态规划的话，建立模型并解决恐怕不是难事。其实我们很容易看出，由于机器人只能右移动和下移动，
因此第[i, j]个格子的总数应该等于[i - 1, j] + [i, j -1]， 因为第[i,j]个格子一定是从左边或者上面移动过来的。

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghludvgtpxj304z07ga9z.jpg)

dp[i][j] 表示 到格子 obstacleGrid[i - 1][j - 1] 的所有路径数。

由于有障碍物的存在， 因此我们的路径有了限制，具体来说就是：`如果当前各自是障碍物， 那么 dp[i][j] = 0`。否则 dp[i][j] = dp[i - 1][j] + dp[i][j - 1]

如果你刚接触动态规划， 西法建议你先写记忆化递归，然后将其转化为标准动态规划。比如本题我们使用记忆化递归解决：

```py
class Solution:
    def uniquePathsWithObstacles(self, obstacleGrid: List[List[int]]) -> int:
        m = len(obstacleGrid)
        if m == 0: return 0
        n = len(obstacleGrid[0])
        @lru_cache(None)
        def dfs(i, j):
            if i < 0 or i >= m or j < 0 or j >= n: return 0
            if obstacleGrid[i][j] == 1: return 0
            if i == 0 and j == 0: return 1
            return dfs(i - 1, j) + dfs(i, j - 1)
        return dfs(m - 1, n - 1)
```

> lru_cache(None) 可以看成一个哈希表，key 是函数参数， value 是函数的返回值，因此纯函数都可使用 lru_cache(None) 通过空间换时间的方式来优化性能。

代码大概是：

Python Code:

```python
class Solution:
    def uniquePathsWithObstacles(self, obstacleGrid: List[List[int]]) -> int:
        m = len(obstacleGrid)
        n = len(obstacleGrid[0])
        if obstacleGrid[0][0]:
            return 0

        dp = [[0] * (n + 1) for _ in range(m + 1)]
        dp[1][1] = 1

        for i in range(1, m + 1):
            for j in range(1, n + 1):
                if i == 1 and j == 1:
                    continue
                if obstacleGrid[i - 1][j - 1] == 0:
                    dp[i][j] = dp[i - 1][j] + dp[i][j - 1]
                else:
                    dp[i][j] = 0
        return dp[m][n]
```

**复杂度分析**

- 时间复杂度：$O(M * N)$
- 空间复杂度：$O(M * N)$

由于 dp[i][j] 只依赖于左边的元素和上面的元素，因此空间复杂度可以进一步优化， 优化到 O(n).

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghludvwao6j30gr09waaq.jpg)

具体代码请查看代码区。

当然你也可以使用记忆化递归的方式来进行，由于递归深度的原因，性能比上面的方法差不少。

> 直接暴力递归的话会超时。

## 关键点

- 记忆化递归
- 基本动态规划问题
- 空间复杂度可以进一步优化到 O(n), 这会是一个考点

## 代码

代码支持: Python3, CPP

Python3 Code:

```python
class Solution:
    def uniquePathsWithObstacles(self, obstacleGrid: List[List[int]]) -> int:
        m = len(obstacleGrid)
        n = len(obstacleGrid[0])
        if obstacleGrid[0][0]:
            return 0

        dp = [0] * (n + 1)
        dp[1] = 1
        for i in range(1, m + 1):
            for j in range(1, n + 1):
                if obstacleGrid[i - 1][j - 1] == 0:
                    dp[j] += dp[j - 1]
                else:
                    dp[j] = 0
        return dp[-1]
```

CPP Code:

```cpp
class Solution {
public:
    int uniquePathsWithObstacles(vector<vector<int>>& obstacleGrid) {
        int M = obstacleGrid.size(), N = obstacleGrid[0].size();
        vector<int> memo(N, 0);
        memo[N - 1] = 1;
        for (int i = M - 1; i >= 0; --i) {
            for (int j = N - 1; j >= 0; --j) {
                if (obstacleGrid[i][j] == 1) memo[j] = 0;
                else memo[j] += j == N - 1 ? 0 : memo[j + 1];
            }
        }
        return memo[0];
    }
};
```

**复杂度分析**

- 时间复杂度：$O(M * N)$
- 空间复杂度：$O(N)$

## 相关题目

- [70. 爬楼梯](https://leetcode-cn.com/problems/climbing-stairs/)
- [62. 不同路径](./62.unique-paths.md)

大家对此有何看法，欢迎给我留言，我有时间都会一一查看回答。更多算法套路可以访问我的 LeetCode 题解仓库：https://github.com/azl397985856/leetcode 。 目前已经 37K star 啦。
大家也可以关注我的公众号《力扣加加》带你啃下算法这块硬骨头。
![](https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg)
