## 题目地址(1589. 所有排列中的最大和)

https://leetcode-cn.com/problems/maximum-sum-obtained-of-any-permutation/

## 题目描述

```
有一个整数数组 nums ，和一个查询数组 requests ，其中 requests[i] = [starti, endi] 。第 i 个查询求 nums[starti] + nums[starti + 1] + ... + nums[endi - 1] + nums[endi] 的结果 ，starti 和 endi 数组索引都是 从 0 开始 的。

你可以任意排列 nums 中的数字，请你返回所有查询结果之和的最大值。

由于答案可能会很大，请你将它对 109 + 7 取余 后返回。

 

示例 1：

输入：nums = [1,2,3,4,5], requests = [[1,3],[0,1]]
输出：19
解释：一个可行的 nums 排列为 [2,1,3,4,5]，并有如下结果：
requests[0] -> nums[1] + nums[2] + nums[3] = 1 + 3 + 4 = 8
requests[1] -> nums[0] + nums[1] = 2 + 1 = 3
总和为：8 + 3 = 11。
一个总和更大的排列为 [3,5,4,2,1]，并有如下结果：
requests[0] -> nums[1] + nums[2] + nums[3] = 5 + 4 + 2 = 11
requests[1] -> nums[0] + nums[1] = 3 + 5  = 8
总和为： 11 + 8 = 19，这个方案是所有排列中查询之和最大的结果。


示例 2：

输入：nums = [1,2,3,4,5,6], requests = [[0,1]]
输出：11
解释：一个总和最大的排列为 [6,5,4,3,2,1] ，查询和为 [11]。

示例 3：

输入：nums = [1,2,3,4,5,10], requests = [[0,2],[1,3],[1,1]]
输出：47
解释：一个和最大的排列为 [4,10,5,3,2,1] ，查询结果分别为 [19,18,10]。

 

提示：

n == nums.length
1 <= n <= 105
0 <= nums[i] <= 105
1 <= requests.length <= 10^5
requests[i].length == 2
0 <= starti <= endi < n
```

## 前置知识

- 差分&前缀和
- 贪心

## 公司

- 暂无

## 思路

我们直接将 request 离散化，统计每一个索引没查询的次数。接下来，我们贪心地令 nums 中最大的数的替换到**查询索引最频繁的**，这样才可以使得结果更优。第二大的配对到查询第二频繁的，以此类推。

代码：

```py
class Solution:
    def maxSumRangeQuery(self, nums: List[int], requests: List[List[int]]) -> int:
        counter = collections.Counter()
        n = len(nums)
        for s, e in requests:
            for i in range(s, e+1):
                counter[i] += 1
        ans = i = 0
        nums.sort(reverse=True)
        for v in sorted(counter.values(), reverse=True):
            ans += v * nums[i]
            ans %= 10 ** 9 + 7
            i += 1
        return ans
```

计算 counter 的时间复杂度是 $O(n*v)$，其中 n 为 requests 长度，v 为 request[i][1] - request[i][0] 的平均值。也就是说时间复杂度等价于 sum(request[i][1] - request[i][0])，其中 0 <= i < n。

我们可以使用差分技巧，接下来使用前缀和来计算 counter。这可以使计算 counter 的复杂度降低到 $O(n)$。

> 一道飞机乘客的问题也用到了这个技巧，我在前缀和专题中也讲了这道题。

## 关键点

- 差分

## 代码

- 语言支持：Python3

Python3 Code:

```python

class Solution:
    def maxSumRangeQuery(self, nums: List[int], requests: List[List[int]]) -> int:
        counter = collections.Counter()
        n = len(nums)
        for s, e in requests:
            counter[s] += 1
            if e + 1 < n:
                counter[e + 1] -= 1
        for i in range(1, n):
            counter[i] += counter[i - 1]
        ans = i = 0
        nums.sort(reverse=True)
        for v in sorted(counter.values(), reverse=True):
            ans += v * nums[i]
            ans %= 10 ** 9 + 7
            i += 1
        return ans

```

**复杂度分析**

令 n 为 nums 长度。

- 时间复杂度：$O(nlogn)$
- 空间复杂度：$O(n)$

> 此题解由 [力扣刷题插件](https://leetcode-pp.github.io/leetcode-cheat/?tab=solution-template) 自动生成。

力扣的小伙伴可以[关注我](https://leetcode-cn.com/u/fe-lucifer/)，这样就会第一时间收到我的动态啦~

以上就是本文的全部内容了。大家对此有何看法，欢迎给我留言，我有时间都会一一查看回答。更多算法套路可以访问我的 LeetCode 题解仓库：https://github.com/azl397985856/leetcode 。 目前已经 40K star 啦。大家也可以关注我的公众号《力扣加加》带你啃下算法这块硬骨头。

关注公众号力扣加加，努力用清晰直白的语言还原解题思路，并且有大量图解，手把手教你识别套路，高效刷题。

![](https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg)
