## 题目地址(1423. 可获得的最大点数)

https://leetcode-cn.com/problems/maximum-points-you-can-obtain-from-cards/

## 题目描述

```
几张卡牌 排成一行，每张卡牌都有一个对应的点数。点数由整数数组 cardPoints 给出。

每次行动，你可以从行的开头或者末尾拿一张卡牌，最终你必须正好拿 k 张卡牌。

你的点数就是你拿到手中的所有卡牌的点数之和。

给你一个整数数组 cardPoints 和整数 k，请你返回可以获得的最大点数。

 

示例 1：

输入：cardPoints = [1,2,3,4,5,6,1], k = 3
输出：12
解释：第一次行动，不管拿哪张牌，你的点数总是 1 。但是，先拿最右边的卡牌将会最大化你的可获得点数。最优策略是拿右边的三张牌，最终点数为 1 + 6 + 5 = 12 。


示例 2：

输入：cardPoints = [2,2,2], k = 2
输出：4
解释：无论你拿起哪两张卡牌，可获得的点数总是 4 。


示例 3：

输入：cardPoints = [9,7,7,9,7,7,9], k = 7
输出：55
解释：你必须拿起所有卡牌，可以获得的点数为所有卡牌的点数之和。


示例 4：

输入：cardPoints = [1,1000,1], k = 1
输出：1
解释：你无法拿到中间那张卡牌，所以可以获得的最大点数为 1 。


示例 5：

输入：cardPoints = [1,79,80,1,1,1,200,1], k = 3
输出：202


 

提示：

1 <= cardPoints.length <= 10^5
1 <= cardPoints[i] <= 10^4
1 <= k <= cardPoints.length
```

## 前置知识

- 滑动窗口

## 公司

- 暂无

## 思路

这道题一个很简单的思路是直接 dp 取最大值。

代码：

```py
class Solution:
    def maxScore(self, A: List[int], k: int) -> int:
        @lru_cache(None)
        def dp(s, e, k):
          if k == 0: return 0
          return max(A[s] + dp(s + 1, e, k - 1), A[e] + dp(s, e - 1, k - 1))
        return dp(0, len(A)-1, k)
```

这种做法的时间和空间复杂度都是 $O(n^2k)$，看下数据范围 $10^5$ 就知道过不了。

> 不懂为啥？请看我总结的复杂度参考表 https://leetcode-pp.github.io/leetcode-cheat/?tab=data-structure-vis

思路逆转，取两边最大就是取中间最小，这样可以使用滑动窗口(固定窗口大小为 n - k 的滑动窗口) 解决。

不懂滑动窗口的可以看下我写的[滑动窗口专题](https://github.com/azl397985856/leetcode/blob/master/thinkings/slide-window.md)

这种做法时间和空间都是质的提升！

## 关键点

- 思路逆转，取两边最大就是取中间最小

## 代码

- 语言支持：Python3

Python3 Code:

```python

class Solution:
    def maxScore(self, A: List[int], k: int) -> int:
        n = len(A)
        ans = t = sum(A[: n - k])
        for i in range(n - k, n):
            t += A[i]
            t -= A[i - (n - k)]
            ans = min(ans, t)
        return sum(A) - ans


```

**复杂度分析**

令 n 为数组长度。

- 时间复杂度：$O(n)$
- 空间复杂度：$O(1)$

> 此题解由 [力扣刷题插件](https://leetcode-pp.github.io/leetcode-cheat/?tab=solution-template) 自动生成。

力扣的小伙伴可以[关注我](https://leetcode-cn.com/u/fe-lucifer/)，这样就会第一时间收到我的动态啦~

以上就是本文的全部内容了。大家对此有何看法，欢迎给我留言，我有时间都会一一查看回答。更多算法套路可以访问我的 LeetCode 题解仓库：https://github.com/azl397985856/leetcode 。 目前已经 40K star 啦。大家也可以关注我的公众号《力扣加加》带你啃下算法这块硬骨头。

关注公众号力扣加加，努力用清晰直白的语言还原解题思路，并且有大量图解，手把手教你识别套路，高效刷题。

![](https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg)
