# 毎日一题 -  版本号比较

## 信息卡片

* 时间：2019-09-16
* 题目链接：<https://leetcode-cn.com/problems/compare-version-numbers/>
* tag：`String`  
## 题目描述
```
比较两个版本号 version1 和 version2。
如果 version1 > version2 返回 1，如果 version1 < version2 返回 -1， 除此之外返回 0。

你可以假设版本字符串非空，并且只包含数字和 . 字符。

 . 字符不代表小数点，而是用于分隔数字序列。

例如，2.5 不是“两个半”，也不是“差一半到三”，而是第二版中的第五个小版本。

你可以假设版本号的每一级的默认修订版号为 0。例如，版本号 3.4 的第一级（大版本）和第二级（小版本）修订号分别为 3 和 4。其第三级和第四级修订号均为 0。

示例 1:

输入: version1 = "0.1", version2 = "1.1"
输出: -1
示例 2:

输入: version1 = "1.0.1", version2 = "1"
输出: 1
示例 3:

输入: version1 = "7.5.2.4", version2 = "7.5.3"
输出: -1
示例 4：

输入：version1 = "1.01", version2 = "1.001"
输出：0
解释：忽略前导零，“01” 和 “001” 表示相同的数字 “1”。
示例 5：

输入：version1 = "1.0", version2 = "1.0.0"
输出：0
解释：version1 没有第三级修订号，这意味着它的第三级修订号默认为 “0”。
 
提示：

版本字符串由以点 （.） 分隔的数字字符串组成。这个数字字符串可能有前导零。
版本字符串不以点开始或结束，并且其中不会有两个连续的点。
```

## 参考答案

### 1. 递归解决

其实这个问题其实简化后就是依次比较每一个修订版本大小，所以问题有以下几点：

1. 获取每个修订版本号大小；
2. 处理每个修订版本号前导零问题；
3. 处理不同版本有不同次数修订版本；

问题1：这个如果对字符串处理比较熟悉的会比较简单，直接遍历循环找到第一个逗号first_dot（找不到的情况设为-1），str.substr(0, first_dot)即可。针对第二，第三个逗号，我们用递归的方案回避，这样每次我们都相当于找第一个逗号前的数字。

问题2：前导零问题更容易解决，在遍历过程中找到第一个非零数first_no_zero，str.substr(first_no_zero, first_dot - first_no_zero)。当然更简单的方案是定义初值v1 = 0，每次计算v1 = v1*10 + str[i] - 'a'

问题3：针对不同次数的修订版本，我们可以在字符串末尾填0表示。即有一个版本号first_dot = -1。

代码如下：

```c++
class Solution {
public:
    int first_num(string str, int& first_dot){
        int v1 = 0;
        first_dot = -1;
        for(int i = 0; i < str.size(); i++){
            if(str[i] == '.'){
                first_dot = i;
                break;
            }
            else
                v1 =  v1 * 10 + (str[i] - '0');
        }
        return v1;
    }
    
    int compareVersion(string version1, string version2) {
        int v1 = 0, v2 = 0;
        int v1_first_dot, v2_first_dot;
        v1 = first_num(version1, v1_first_dot);
        v2 = first_num(version2, v2_first_dot);
        if(v1 > v2) 
        	return 1;
        else if(v1 < v2) 
        	return -1;
        else{
            if(v1_first_dot == -1 && v2_first_dot == -1) 
             	return 0;
            if(v1_first_dot == -1) 
              	version1 = "0";
            else 
              	version1 = version1.substr(v1_first_dot+1);
            if(v2_first_dot == -1) 
              	version2 = "0";
            else
              	version2 = version2.substr(v2_first_dot+1);
            return compareVersion(version1, version2);
        }
    }
};

```

### 2. 数组

解析每个版本号，放入数组，依次比较大小。

```c
int compareVersion(char * version1, char * version2){
    if (version1 == NULL || version2 == NULL) return -1;
    int *val1 = (int *)calloc(1024, sizeof(int));
    int *val2 = (int *)calloc(1024, sizeof(int));
    int len1 = strlen(version1), top1 = 0;
    int len2 = strlen(version2), top2 = 0;
    int i, n;
    for (i = 0, n = 0; i < len1; ++i) {  //解析版本1
        if (version1[i] == '.') {
            val1[top1++] = n;
            n = 0;
        }else n = n*10 + (version1[i] & 0x0f);
    }
    val1[top1++] = n;
    for (i = 0, n = 0; i < len2; ++i) {  //解析版本1
        if (version2[i] == '.') {
            val2[top2++] = n;
            n = 0;
        }else n = n*10 + (version2[i] & 0x0f);
    }
    val2[top2++] = n;
    for (i = 0; i < top1 && i < top2; ++i) {  //比较版本大小
        if      (val1[i] > val2[i]) return 1;
        else if (val1[i] < val2[i]) return -1;
    }
    if (i < top1) {  //由于可能有的版本还没遍历完
        while (i < top1) if (val1[i++]) return 1;  //只要版本后面的数字出现的不是0，就意味着两个版本不一样
    }else{
        while (i < top2) if (val2[i++]) return -1;
    }
    return 0;
}
//作者：ljj666
//链接：https://leetcode-cn.com/problems/compare-version-numbers/solution/cyu-yan-jian-jian-dan-dan-de-ji-xing-dai-ma-jie-37/
//来源：力扣（LeetCode）
//著作权归作者所有。商业转载请联系作者获得授权，非商业转载请注明出处。
```


## 优秀解答

>暂缺
