## 题目地址（721. 账户合并）

https://leetcode-cn.com/problems/accounts-merge/

## 题目描述

给定一个列表 accounts，每个元素 accounts[i]  是一个字符串列表，其中第一个元素 accounts[i][0]  是   名称 (name)，其余元素是 emails 表示该帐户的邮箱地址。

现在，我们想合并这些帐户。如果两个帐户都有一些共同的邮件地址，则两个帐户必定属于同一个人。请注意，即使两个帐户具有相同的名称，它们也可能属于不同的人，因为人们可能具有相同的名称。一个人最初可以拥有任意数量的帐户，但其所有帐户都具有相同的名称。

合并帐户后，按以下格式返回帐户：每个帐户的第一个元素是名称，其余元素是按顺序排列的邮箱地址。accounts 本身可以以任意顺序返回。

例子 1:

Input:
accounts = [["John", "johnsmith@mail.com", "john00@mail.com"], ["John", "johnnybravo@mail.com"], ["John", "johnsmith@mail.com", "john_newyork@mail.com"], ["Mary", "mary@mail.com"]]
Output: [["John", 'john00@mail.com', 'john_newyork@mail.com', 'johnsmith@mail.com'], ["John", "johnnybravo@mail.com"], ["Mary", "mary@mail.com"]]
Explanation:
第一个和第三个 John 是同一个人，因为他们有共同的电子邮件 "johnsmith@mail.com"。
第二个 John 和 Mary 是不同的人，因为他们的电子邮件地址没有被其他帐户使用。
我们可以以任何顺序返回这些列表，例如答案[['Mary'，'mary@mail.com']，['John'，'johnnybravo@mail.com']，
['John'，'john00@mail.com'，'john_newyork@mail.com'，'johnsmith@mail.com']]仍然会被接受。

注意：

accounts 的长度将在[1，1000]的范围内。
accounts[i]的长度将在[1，10]的范围内。
accounts[i][j]的长度将在[1，30]的范围内。

## 前置知识

- 并查集

## 公司

- 字节

## 思路

我们抛开 name 不管。 我们只根据 email 建立并查集即可。这样一个连通分量中的 email 就是一个人，我们在用一个 hashtable 记录 email 和 name 的映射，将其输出即可。

> 如果题目不要求我们输出 name，我们自然根本不需要 hashtable 做映射

## 代码

`find`, `union`, `connected` 都是典型的模板方法。 懂的同学可能也发现了，我没有做路径压缩，这直接导致 find union connected 的时间复杂度最差的情况退化到 $O(N)$。

当然优化也不难，我们只需要给每一个顶层元素设置一个 size 用来表示连通分量的大小，这样 union 的时候我们将小的拼接到大的上即可。 另外 find 的时候我们甚至可以路径压缩，将树高限定到常数，这样时间复杂度可以降低到 $O(1)$。

```python
class UF:
    def __init__(self):
        self.parent = {}

    def find(self, x):
        self.parent.setdefault(x, x)
        while x != self.parent[x]:
            x = self.parent[x]
        return x
    def union(self, p, q):
        self.parent[self.find(p)] = self.find(q)


class Solution:
    def accountsMerge(self, accounts: List[List[str]]) -> List[List[str]]:
        uf = UF()
        email_to_name = {}
        res = collections.defaultdict(list)
        for account in accounts:
            for i in range(1, len(account)):
                email_to_name[account[i]] = account[0]
                if i < len(account) - 1:uf.union(account[i], account[i + 1])
        for email in email_to_name:
            res[uf.find(email)].append(email)

        return [[email_to_name[value[0]]] + sorted(value) for value in res.values()]
```

**复杂度分析**

- 时间复杂度：平均 $O(logN)$，最坏的情况是 $O(N)$
- 空间复杂度：我们使用了 parent， 因此空间复杂度为 $O(N)$

欢迎关注我的公众号《脑洞前端》获取更多更新鲜的 LeetCode 题解

![](https://tva1.sinaimg.cn/large/007S8ZIlly1ghlucengjhj31bi0hcq5s.jpg)
