## 每日一题 - 三门问题 (Three Doors Problem / Monty Hall problem)

### 信息卡片

今天这道题不是算法题，而是一道概率论的经典问题，相当违反直觉，很有意思。题目描述如下：

- 时间: 2019-06-13
- tag: `Probability Theory`

## 题目描述

```
假设你在参加一个春节抽奖游戏，主持人在三个红包里面分别放了 1 块钱、1 块钱和 1000 块钱。你选中哪一个，你就可以领到对应的钱。当你选定一个红包之后，主持人会打开一个 1 块钱的红包，并给你一次机会更换所选红包。请问：应不应该换？
```

## 答案

**要换**。换了之后有 `2/3` 的概率拿到 1000 的红包。而不是直觉告诉我们的 `1/2`.

这份[代码](./answers/three-doors-problem.js)进行了多次实验，验证了这一结论。

## 简要解释

这里的核心在于，主持人不是随机打开一个红包，而是挑选了一定是 1 块钱的那个红包。

## 详细解释

以下链接给出了数学证明和非常详细的解释：有兴趣可以看看。

[Monty Hall 问题](https://mp.weixin.qq.com/s?__biz=MzIzODExMDE5MA==&mid=445629202&idx=1&sn=451fe436511f2b00d2354e8dd074b7fa#rd)
