# LeetCode

[![Travis](https://img.shields.io/badge/language-C++-green.svg)]()
[![Travis](https://img.shields.io/badge/language-JavaScript-yellow.svg)]()
[![Travis](https://img.shields.io/badge/language-Python-red.svg)]()
[![Travis](https://img.shields.io/badge/language-Java-blue.svg)]()
![Total visitor](https://visitor-count-badge.herokuapp.com/total.svg?repo_id=azl397985856.leetcode.en)
![Visitors in today](https://visitor-count-badge.herokuapp.com/today.svg?repo_id=azl397985856.leetcode.en)

> since 2019-09-03 19:40

[简体中文](./README.md) | English

---

![leetcode.jpeg](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwf4xivj30dw0780sm.jpg)

This essay records the course of and my emotion to this project from initialization to 10,000 stars.
[Milestone for 10,000+ stars](./thanksGiving.md)

If you are interested in this project, **do not mean your star**. This project will be **supported for a long enough time** by the community. Thanks for every audience and contributor.

## Introduction

![leetcode.jpeg](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwf4xivj30dw0780sm.jpg)

LeetCode Solutions: A Journey of Problem Solving.

This repository is divided into five parts for now:

- The first part is the solutions to some classic problems on LeetCode, including the idea thinkings, key points and code implementations.

- The second part is a summary of data structures and algorithms.

- The third part is [Anki flashcards](https://apps.ankiweb.net) that organizes the LeetCode problems in a certain way to make it easier to remember.

- The fourth part is daily challenges which were held at group chat. We usually solve one problem altogether to get more feedback. Moreover, the problems can be drafted to add to the problem solving module.

- The fifth part is a future planning on content that will be introduced into the above parts.

> Only when having mastered the basic data structures and algorithms can you solve complex problems easily.

## About me

I, a programmer, am all passionate about technology.

Used to write `.net` and `Java`, I am a frontend engineer and focused on the engineering, optimization and standardization for frontend.

If you want to do some contributions or collaborations, just feel free to contact me via [azl397985856@gmail.com].

## Usage Instructions

- For the parts that were added recently, there will be a 🆕 behind.
- For the parts that were updated recently, there will be a 🖊 behind.
- Here will be the place to update Anki Flashcards in the future as well.
- Here is a mind mapping graph showing the summary of categorizations of problems that are questioned frequently in interviews. We could analyze according to the information in the graph.

![leetcode-zhihu](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwgi53bj30k00jx0te.jpg)

(Picture credited by [LeetCode-cn](https://www.zhihu.com/question/24964987/answer/586425979).)

The algorithms mainly include:

- Basic skills: Divide-and-Conquer; Binary; Greedy
- Sorting algorithms: Quicksort; Merge Sort; Counting Sort
- Searching algorithms: Backtracking; Recursion; Depth-First-Search (DFS); Breath-First-Search (BFS); Binary Search Tree; etc.
- Graph theory: Shortest Path Problem; Minimal Spanning Tree
- Dynamic Programming: Knapsack Problem; Longest Common Subsequence (LCS) Problem

The data structures mainly include:

- Array and linked list: Singly/Doubly-Linked List
- Stack and queue
- Hash table
- Heap: Min-Max Heap
- Tree and Graph: Lowest Common Ancestor (LCA); Disjoint-Set
- String: Prefix Tree (Trie); Suffix Tree

## Previews (Translation in Progress)

[0547.friend-circles](./problems/547.friend-circles-en.md) :

![friend circle BFS](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwh1getj30u0140tdc.jpg)

[backtrack problems](./problems/90.subsets-ii-en.md):

![backtrack](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwhwowgj30n20nptas.jpg)

[0454.4-sum-ii](./problems/454.4-sum-ii.en.md) :

![454.4-sum-ii](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwivf65j30le0deab3.jpg)

## Portals

### Solutions to LeetCode Classic Problems

> Here only lists some **representative problems** but not all.

#### Easy (Translation in Progress)

- [0001.TwoSum](./problems/1.two-sum.en.md)🆕
- [0053.maximum-sum-subarray](./problems/53.maximum-sum-subarray-en.md) 🆕
- [0198.house-robber](./problems/198.house-robber.en.md)🆕
- [0501.find-mode-in-binary-search-tree](./problems/501.Find-Mode-in-Binary-Search-Tree-en.md)🆕

#### Medium (Translation in Progress)

- [0002. Add Two Numbers](./problems/2.add-two-numbers.en.md)
- [0078.subsets](./problems/78.subsets-en.md)
- [0079.word-search](./problems/79.word-search-en.md)
- [0086.partition-list](./problems/86.partition-list.md)
- [0090.subsets-ii](./problems/90.subsets-ii-en.md)

* [0474.ones-and-zeros](./problems/474.ones-and-zeros-en.md)

* [0547.friend-circles](./problems/547.friend-circles-en.md) 🆕
* [0560.subarray-sum-equals-k](./problems/560.subarray-sum-equals-k.en.md)

* [1011.capacity-to-ship-packages-within-d-days](./problems/1011.capacity-to-ship-packages-within-d-days-en.md) 🆕

* [1371.find-the-longest-substring-containing-vowels-in-even-counts](./problems/1371.find-the-longest-substring-containing-vowels-in-even-counts.en.md) 🆕

#### Hard (Translation in Progress)

- [0025.reverse-nodes-in-k-group](./problems/25.reverse-nodes-in-k-groups-en.md) 🆕
- [0042.trapping-rain-water](./problems/42.trapping-rain-water.en.md)🆕
- [1168.optimize-water-distribution-in-a-village](./problems/1168.optimize-water-distribution-in-a-village-en.md) 🆕

### Summary of Data Structures and Algorithm

- [Data Structure](./thinkings/basic-data-structure-en.md)
- [Basic Algorithm](./thinkings/basic-algorithm-en.md)
- [Binary Tree Traversal](./thinkings/binary-tree-traversal.en.md)
- [Dynamic Programming](./thinkings/dynamic-programming-en.md)
- [Huffman Encode and Run Length Encode](./thinkings/run-length-encode-and-huffman-encode-en.md)
- [Bloom Filter](./thinkings/bloom-filter-en.md)
- [String Problems](./thinkings/string-problems-en.md)
- [Sliding Window Technique](./thinkings/slide-window.en.md)
- [Union Find](./thinkings/union-find.en.md) 🆕
- [Trie](./thinkings/trie.en.md) 🆕

### Anki Flashcards

Anki falshcards would be mainly two parts: the mappings from key points to problems; the mappings from problems to idea thinks, key points and code implementations.

All flashcards are put in [anki-card](./assets/anki/leetcode.apkg).

> Please check [here](https://apps.ankiweb.net/) for more about the usage of Anki.

Latest updated flashcards (only lists the front page):

- What is the key point of the binary search algorithm? Related problems?
- How to simplify the operations using the features of stacks? Related problems?
- The thinkings and related problems of double-pointers problems?
- The thinkings and related problems of sliding window problems?
- The thinkings and related problems of backtracking?
- The thinkings and related problems of number theory?
- The thinkings and related problems of bit operations?

> WIP: the translation of the flashcards are on the way.

> problems added：#2 #3 #11

## Community Chat Groups

We're still on the early stage, so feedback from community is very welcome. For sake of reducing the costs of communication, I created some chat groups.

### Telegram

[http://t.me/leetcode_intl](http://t.me/leetcode_intl)

### QQ (For China Region)

![qq-group-chat](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwje9plj3060060wel.jpg)

### WeChat (For China Region)

![wechat-group-chat](https://tva1.sinaimg.cn/large/007S8ZIlly1ghltwjrk6ij30e80e875j.jpg)

(Add this bot and reply "leetcode" to join the group.)

## Contribution

- If you have any ideas, [Issues](https://github.com/azl397985856/leetcode/issues) or chat in groups.
- If you want to commit to the repository, Pull Request is welcome. Here is the [CONTRIBUTION GUIDE](./CONTRIBUTING.en.md)
- If you want to edit images resources in this project, [here](./assets/drawio/) lists the files that can be edited on [draw.io](https://www.draw.io/).

## Thank you

A big Thank you to every [contributor](https://github.com/azl397985856/leetcode/graphs/contributors) of this project.

## License

[Apache-2.0](./LICENSE.txt)
