/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class Code128Writer
extends UPCEANWriter {
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    public byte[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        int codeWidth = 35;
        for (int i = 0; i < length; ++i) {
            int[] patterns = Code128Reader.CODE_PATTERNS[contents.charAt(i) - 32];
            for (int j = 0; j < patterns.length; ++j) {
                codeWidth += patterns[j];
            }
        }
        byte[] result = new byte[codeWidth];
        int pos = Code128Writer.appendPattern(result, 0, Code128Reader.CODE_PATTERNS[104], 1);
        int check = 104;
        for (int i = 0; i < length; ++i) {
            check += (contents.charAt(i) - 32) * (i + 1);
            pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[contents.charAt(i) - 32], 1);
        }
        pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[check %= 103], 1);
        pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[106], 1);
        return result;
    }
}

