/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson.server;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.activation.UnsupportedDataTypeException;
import zuo.biao.apijson.JSON;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.MethodAccess;
import zuo.biao.apijson.RequestMethod;
import zuo.biao.apijson.RequestRole;
import zuo.biao.apijson.server.JSONRequest;
import zuo.biao.apijson.server.NotNull;
import zuo.biao.apijson.server.SQLConfig;
import zuo.biao.apijson.server.Verifier;
import zuo.biao.apijson.server.Visitor;
import zuo.biao.apijson.server.exception.ConflictException;
import zuo.biao.apijson.server.exception.NotLoggedInException;
import zuo.biao.apijson.server.model.Column;
import zuo.biao.apijson.server.model.Document;
import zuo.biao.apijson.server.model.Request;
import zuo.biao.apijson.server.model.Response;
import zuo.biao.apijson.server.model.Table;
import zuo.biao.apijson.server.model.Test;
import zuo.biao.apijson.server.model.TestRecord;

public abstract class AbstractVerifier
implements Verifier {
    private static final String TAG = "AbstractVerifier";
    public static final Map<String, Map<RequestMethod, RequestRole[]>> ACCESS_MAP = new HashMap<String, Map<RequestMethod, RequestRole[]>>();
    @NotNull
    protected Visitor visitor;
    protected long visitorId;

    public static HashMap<RequestMethod, RequestRole[]> getAccessMap(MethodAccess access) {
        if (access == null) {
            return null;
        }
        HashMap<RequestMethod, RequestRole[]> map = new HashMap<RequestMethod, RequestRole[]>();
        map.put(RequestMethod.GET, access.GET());
        map.put(RequestMethod.HEAD, access.HEAD());
        map.put(RequestMethod.GETS, access.GETS());
        map.put(RequestMethod.HEADS, access.HEADS());
        map.put(RequestMethod.POST, access.POST());
        map.put(RequestMethod.PUT, access.PUT());
        map.put(RequestMethod.DELETE, access.DELETE());
        return map;
    }

    @Override
    @NotNull
    public Visitor getVisitor() {
        return this.visitor;
    }

    @Override
    public AbstractVerifier setVisitor(Visitor visitor) {
        this.visitor = visitor;
        this.visitorId = visitor == null ? 0L : AbstractVerifier.value(visitor.getId());
        return this;
    }

    @Override
    public boolean verify(SQLConfig config) throws Exception {
        String table;
        String string = table = config == null ? null : config.getTable();
        if (table == null) {
            return true;
        }
        RequestRole role = config.getRole();
        if (role == null) {
            role = RequestRole.UNKNOWN;
        }
        if (role != RequestRole.UNKNOWN) {
            this.verifyLogin();
        }
        RequestMethod method = config.getMethod();
        this.verifyRole(table, method, role);
        String visitorIdkey = this.getVisitorIdKey(config.getTable());
        switch (role) {
            case LOGIN: {
                break;
            }
            case CONTACT: 
            case CIRCLE: {
                ArrayList<Object> list;
                ArrayList<Object> arrayList = list = this.visitor.getContactIdList() == null ? new ArrayList<Object>() : new ArrayList<Long>(this.visitor.getContactIdList());
                if (role == RequestRole.CIRCLE) {
                    list.add(this.visitorId);
                }
                Number requestId = (Number)config.getWhere(visitorIdkey, true);
                JSONArray requestIdArray = (JSONArray)config.getWhere(visitorIdkey + "{}", true);
                if (requestId != null) {
                    if (requestIdArray == null) {
                        requestIdArray = new JSONArray();
                    }
                    requestIdArray.add((Object)requestId);
                }
                if (requestIdArray == null) {
                    config.putWhere(visitorIdkey + "{}", JSON.parseArray(list), true);
                    break;
                }
                for (Object id : requestIdArray) {
                    if (id == null) continue;
                    if (!(id instanceof Number)) {
                        throw new UnsupportedDataTypeException(table + ".id\u7c7b\u578b\u9519\u8bef\uff0cid\u7c7b\u578b\u5fc5\u987b\u662fLong\uff01");
                    }
                    if (list.contains(new Long("" + id))) continue;
                    throw new IllegalAccessException(visitorIdkey + " = " + id + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role.name() + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                }
                break;
            }
            case OWNER: {
                Number requestId = (Number)config.getWhere(visitorIdkey, true);
                if (requestId != null && requestId.longValue() != this.visitorId) {
                    throw new IllegalAccessException(visitorIdkey + " = " + requestId + " \u7684 " + table + " \u4e0d\u5141\u8bb8 " + role.name() + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
                }
                config.putWhere(visitorIdkey, this.visitorId, true);
                break;
            }
            case ADMIN: {
                break;
            }
        }
        return true;
    }

    @Override
    public void verifyRole(String table, RequestMethod method, RequestRole role) throws Exception {
        Log.d(TAG, "verifyRole  table = " + table + "; method = " + (Object)((Object)method) + "; role = " + (Object)((Object)role));
        if (table != null) {
            Map<RequestMethod, RequestRole[]> map;
            if (method == null) {
                method = RequestMethod.GET;
            }
            if (role == null) {
                role = RequestRole.UNKNOWN;
            }
            if ((map = ACCESS_MAP.get(table)) == null || !Arrays.asList((Object[])map.get((Object)method)).contains((Object)role)) {
                throw new IllegalAccessException(table + " \u4e0d\u5141\u8bb8 " + role.name() + " \u7528\u6237\u7684 " + method.name() + " \u8bf7\u6c42\uff01");
            }
        }
    }

    @Override
    public void verifyLogin() throws Exception {
        if (this.visitorId <= 0L) {
            throw new NotLoggedInException("\u672a\u767b\u5f55\uff0c\u8bf7\u767b\u5f55\u540e\u518d\u64cd\u4f5c\uff01");
        }
    }

    @Override
    public void verifyRepeat(String table, String key, Object value) throws Exception {
        this.verifyRepeat(table, key, value, 0L);
    }

    @Override
    public void verifyRepeat(String table, String key, Object value, long exceptId) throws Exception {
        JSONObject repeat;
        if (key == null || value == null) {
            Log.e(TAG, "verifyRepeat  key == null || value == null >> return;");
            return;
        }
        if (value instanceof JSON) {
            throw new UnsupportedDataTypeException(key + ":value \u4e2dvalue\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
        }
        JSONRequest request = new JSONRequest(key, value);
        if (exceptId > 0L) {
            request.put(JSONRequest.KEY_ID + "!", (Object)exceptId);
        }
        JSONObject jSONObject = repeat = (repeat = this.createParser().setMethod(RequestMethod.HEAD).setNoVerify(true).parseResponse(new JSONRequest(table, (Object)request))) == null ? null : repeat.getJSONObject(table);
        if (repeat == null) {
            throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef  verifyRepeat  repeat == null");
        }
        if (repeat.getIntValue("count") > 0) {
            throw new ConflictException(key + ": " + value + " \u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
    }

    @Override
    public JSONObject removeAccessInfo(JSONObject requestObject) {
        return requestObject;
    }

    public static long value(Long v) {
        return v == null ? 0L : v;
    }

    static {
        ACCESS_MAP.put(Table.class.getSimpleName(), AbstractVerifier.getAccessMap(Table.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(Column.class.getSimpleName(), AbstractVerifier.getAccessMap(Column.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(Test.class.getSimpleName(), AbstractVerifier.getAccessMap(Test.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(Request.class.getSimpleName(), AbstractVerifier.getAccessMap(Request.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(Response.class.getSimpleName(), AbstractVerifier.getAccessMap(Response.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(Document.class.getSimpleName(), AbstractVerifier.getAccessMap(Document.class.getAnnotation(MethodAccess.class)));
        ACCESS_MAP.put(TestRecord.class.getSimpleName(), AbstractVerifier.getAccessMap(TestRecord.class.getAnnotation(MethodAccess.class)));
    }
}

