/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zuo.biao.apijson.JSONResponse;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.StringUtil;
import zuo.biao.apijson.server.AbstractParser;
import zuo.biao.apijson.server.Join;
import zuo.biao.apijson.server.NotNull;
import zuo.biao.apijson.server.SQLConfig;
import zuo.biao.apijson.server.SQLExecutor;

public abstract class AbstractSQLExecutor
implements SQLExecutor {
    private static final String TAG = "SQLExecutor";
    protected Map<String, Map<Integer, JSONObject>> cacheMap = new HashMap<String, Map<Integer, JSONObject>>();

    @Override
    public synchronized void putCache(String sql, Map<Integer, JSONObject> map, boolean isStatic) {
        if (sql == null || map == null) {
            Log.i(TAG, "saveList  sql == null || map == null >> return;");
            return;
        }
        this.cacheMap.put(sql, map);
    }

    @Override
    public synchronized void removeCache(String sql, boolean isStatic) {
        if (sql == null) {
            Log.i(TAG, "removeList  sql == null >> return;");
            return;
        }
        this.cacheMap.remove(sql);
    }

    @Override
    public JSONObject getCache(String sql, int position, boolean isStatic) {
        Map<Integer, JSONObject> map = this.cacheMap.get(sql);
        if (map == null) {
            return null;
        }
        JSONObject result = map.get(position);
        return result != null ? result : new JSONObject();
    }

    @Override
    public void close() {
        this.cacheMap.clear();
        this.cacheMap = null;
    }

    @Override
    public JSONObject execute(SQLConfig config) throws Exception {
        if (config == null) {
            Log.e(TAG, "select  config==null >> return null;");
            return null;
        }
        boolean prepared = config.isPrepared();
        String sql = config.getSQL(false);
        config.setPrepared(prepared);
        if (!StringUtil.isNotEmpty(sql, true)) {
            Log.e(TAG, "select  StringUtil.isNotEmpty(sql, true) == false >> return null;");
            return null;
        }
        JSONObject result = null;
        long startTime = System.currentTimeMillis();
        Log.d(TAG, "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n select  startTime = " + startTime + "\n sql = \n " + sql + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
        ResultSet rs = null;
        switch (config.getMethod()) {
            case HEAD: 
            case HEADS: {
                rs = this.executeQuery(config);
                result = rs.next() ? AbstractParser.newSuccessResult() : AbstractParser.newErrorResult(new SQLException("\u6570\u636e\u5e93\u9519\u8bef, rs.next() \u5931\u8d25\uff01"));
                result.put("count", (Object)rs.getLong(1));
                rs.close();
                return result;
            }
            case POST: 
            case PUT: 
            case DELETE: {
                long updateCount = this.executeUpdate(config);
                result = AbstractParser.newResult(updateCount > 0L ? 200 : 404, updateCount > 0L ? "success" : "\u53ef\u80fd\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
                if (config.getId() != null && config.getId() != "") {
                    result.put(JSONResponse.KEY_ID, (Object)config.getId());
                } else {
                    result.put(JSONResponse.KEY_ID + "[]", config.getWhere(JSONResponse.KEY_ID_IN, true));
                }
                result.put("count", (Object)updateCount);
                return result;
            }
            case GET: 
            case GETS: {
                break;
            }
            default: {
                Log.e(TAG, "select  sql = " + sql + " ; method = " + (Object)((Object)config.getMethod()) + " >> return null;");
                return null;
            }
        }
        int position = config.getPosition();
        result = this.getCache(sql, position, config.isCacheStatic());
        Log.i(TAG, ">>> select  result = getCache('" + sql + "', " + position + ") = " + result);
        if (result != null) {
            Log.d(TAG, "\n\n select  result != null >> return result;\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
            return result;
        }
        rs = this.executeQuery(config);
        Map<Integer, JSONObject> resultMap = new HashMap<Integer, JSONObject>();
        int index = -1;
        ResultSetMetaData rsmd = rs.getMetaData();
        int length = rsmd.getColumnCount();
        HashMap<String, JSONObject> childMap = new HashMap<String, JSONObject>();
        while (rs.next()) {
            Log.d(TAG, "\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n select while (rs.next()){  index = " + ++index + "\n\n");
            result = new JSONObject(true);
            for (int i = 1; i <= length; ++i) {
                result = this.onPutColumn(config, rs, rsmd, index, result, i, childMap);
            }
            resultMap = this.onPutTable(config, rs, rsmd, resultMap, index, result);
            Log.d(TAG, "\n select  while (rs.next()) { resultMap.put( " + index + ", result); \n >>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n");
        }
        rs.close();
        Set set = childMap.entrySet();
        for (Map.Entry entry : set) {
            HashMap<Integer, JSONObject> m = new HashMap<Integer, JSONObject>();
            m.put(0, (JSONObject)entry.getValue());
            this.putCache((String)entry.getKey(), m, false);
        }
        this.putCache(sql, resultMap, config.isCacheStatic());
        Log.i(TAG, ">>> select  putCache('" + sql + "', resultMap);  resultMap.size() = " + resultMap.size());
        long endTime = System.currentTimeMillis();
        Log.d(TAG, "\n\n select  endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n return resultMap.get(" + position + ");\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
        return resultMap.get(position);
    }

    protected JSONObject onPutColumn(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws Exception {
        if (rsmd.getColumnName(columnIndex).startsWith("_")) {
            Log.i(TAG, "select while (rs.next()){ ... >>  rsmd.getColumnName(i).startsWith(_) >> continue;");
            return table;
        }
        String lable = rsmd.getColumnLabel(columnIndex);
        int dotIndex = lable.indexOf(".");
        String column = dotIndex < 0 ? lable : lable.substring(dotIndex + 1);
        String childTable = dotIndex < 0 ? null : lable.substring(0, dotIndex);
        JSONObject finalTable = null;
        String childSql = null;
        SQLConfig childConfig = null;
        if (childTable == null) {
            finalTable = table;
        } else {
            lable = column;
            List<Join> joinList = config.getJoinList();
            if (joinList != null) {
                for (Join j : joinList) {
                    if (!childTable.equals(j.getName())) continue;
                    childConfig = j.getCacheConfig();
                    childConfig.putWhere(j.getKey(), table.get((Object)j.getTargetKey()), false);
                    childSql = childConfig.getSQL(false);
                    if (StringUtil.isEmpty(childSql, true)) {
                        return table;
                    }
                    finalTable = childMap.get(childSql);
                    break;
                }
            }
            if (finalTable == null) {
                finalTable = new JSONObject(true);
                childMap.put(childSql, finalTable);
            }
        }
        Object value = rs.getObject(columnIndex);
        if (value != null) {
            if (value instanceof Timestamp) {
                value = ((Timestamp)value).toString();
            } else if (value instanceof String && this.isJSONType(rsmd, columnIndex)) {
                value = JSON.parse((String)((String)value));
            }
        }
        finalTable.put(lable, value);
        return table;
    }

    protected Map<Integer, JSONObject> onPutTable(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, @NotNull Map<Integer, JSONObject> resultMap, int position, @NotNull JSONObject table) {
        resultMap.put(position, table);
        return resultMap;
    }

    @Override
    public boolean isJSONType(ResultSetMetaData rsmd, int position) {
        try {
            return rsmd.getColumnTypeName(position).toLowerCase().contains("json");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

