/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import zuo.biao.apijson.JSONObject;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.RequestMethod;
import zuo.biao.apijson.RequestRole;
import zuo.biao.apijson.SQL;
import zuo.biao.apijson.StringUtil;
import zuo.biao.apijson.server.Join;
import zuo.biao.apijson.server.Logic;
import zuo.biao.apijson.server.NotNull;
import zuo.biao.apijson.server.Pair;
import zuo.biao.apijson.server.SQLConfig;
import zuo.biao.apijson.server.exception.NotExistException;
import zuo.biao.apijson.server.model.Column;
import zuo.biao.apijson.server.model.Table;

public abstract class AbstractSQLConfig
implements SQLConfig {
    private static final String TAG = "SQLConfig";
    public static final Map<String, String> TABLE_KEY_MAP = new HashMap<String, String>();
    private String id;
    private RequestMethod method;
    private boolean prepared = true;
    private boolean main = true;
    private RequestRole role;
    private String database;
    private String schema;
    private String table;
    private String alias;
    private String group;
    private String having;
    private String order;
    private String column;
    private String values;
    private Map<String, Object> content;
    private Map<String, Object> where;
    private Map<String, List<String>> combine;
    private int count;
    private int page;
    private int position;
    private int query;
    private int type;
    private List<Join> joinList;
    private boolean test;
    private boolean cacheStatic;
    private List<Object> preparedValueList = new ArrayList<Object>();
    private static final Pattern PATTERN_RANGE;
    private static final Pattern PATTERN_HAVING;
    private static final Pattern PATTERN_HAVING_SUFFIX;
    private boolean keyPrefix;

    public AbstractSQLConfig(RequestMethod method) {
        this.setMethod(method);
    }

    public AbstractSQLConfig(RequestMethod method, String table) {
        this(method);
        this.setTable(table);
    }

    public AbstractSQLConfig(RequestMethod method, int count, int page) {
        this(method);
        this.setCount(count);
        this.setPage(page);
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        if (this.method == null) {
            this.method = RequestMethod.GET;
        }
        return this.method;
    }

    @Override
    public AbstractSQLConfig setMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public AbstractSQLConfig setPrepared(boolean prepared) {
        this.prepared = prepared;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public AbstractSQLConfig setMain(boolean main) {
        this.main = main;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AbstractSQLConfig setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public RequestRole getRole() {
        return this.role;
    }

    public AbstractSQLConfig setRole(String roleName) throws Exception {
        return this.setRole(RequestRole.get(roleName));
    }

    @Override
    public AbstractSQLConfig setRole(RequestRole role) {
        this.role = role;
        return this;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public SQLConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    @Override
    public String getSchema() {
        String sqlTable = this.getSQLTable();
        if (sqlTable != null && sqlTable.startsWith("`")) {
            return "`information_schema`";
        }
        return this.schema;
    }

    @Override
    public AbstractSQLConfig setSchema(String schema) {
        if (schema != null) {
            String s;
            String string = s = schema.startsWith("`") && schema.endsWith("`") ? schema.substring(1, schema.length() - 1) : schema;
            if (!StringUtil.isName(s)) {
                throw new IllegalArgumentException("@schema:value \u4e2dvalue\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
            }
        }
        this.schema = schema;
        return this;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    @JSONField(serialize=false)
    public String getSQLTable() {
        return (TABLE_KEY_MAP.containsKey(this.table) ? TABLE_KEY_MAP.get(this.table) : this.table) + (this.isKeyPrefix() ? " AS " + this.getAlias() : "");
    }

    @Override
    @JSONField(serialize=false)
    public String getTablePath() {
        return this.getSchema() + "." + this.getSQLTable();
    }

    @Override
    public AbstractSQLConfig setTable(String table) {
        this.table = table;
        return this;
    }

    @Override
    public String getAlias() {
        if (StringUtil.isEmpty(this.alias, true)) {
            this.alias = this.getTable();
        }
        return this.alias;
    }

    @Override
    public AbstractSQLConfig setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public AbstractSQLConfig setGroup(String ... keys) {
        return this.setGroup(StringUtil.getString(keys));
    }

    @Override
    public AbstractSQLConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    @JSONField(serialize=false)
    public String getGroupString() {
        this.group = StringUtil.getTrimedString(this.group);
        if (this.group.isEmpty()) {
            return "";
        }
        Object[] keys = StringUtil.split(this.group);
        if (keys == null || keys.length <= 0) {
            return "";
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.isPrepared() && !StringUtil.isName(keys[i])) {
                throw new IllegalArgumentException("@group:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey((String)keys[i]);
        }
        return " GROUP BY " + StringUtil.getString(keys);
    }

    @Override
    public String getHaving() {
        return this.having;
    }

    public AbstractSQLConfig setHaving(String ... conditions) {
        return this.setHaving(StringUtil.getString(conditions));
    }

    @Override
    public AbstractSQLConfig setHaving(String having) {
        this.having = having;
        return this;
    }

    @JSONField(serialize=false)
    public String getHavingString() {
        this.having = StringUtil.getTrimedString(this.having);
        if (this.having.isEmpty()) {
            return "";
        }
        Object[] keys = StringUtil.split(this.having, ";");
        if (keys == null || keys.length <= 0) {
            return "";
        }
        for (int i = 0; i < keys.length; ++i) {
            String expression = keys[i];
            int start = expression.indexOf("(");
            if (start < 0) {
                if (!this.isPrepared() || PATTERN_HAVING.matcher(expression).matches()) continue;
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + expression + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d column?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f ^[A-Za-z0-9%!=<>]+$ \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
            }
            int end = expression.indexOf(")");
            if (start >= end) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01@having:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
            }
            String method = expression.substring(0, start);
            if (!StringUtil.isName(method)) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2dSQL\u51fd\u6570\u540d function \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f ^[0-9a-zA-Z_]+$ \uff01");
            }
            String suffix = expression.substring(end + 1, expression.length());
            if (this.isPrepared() && !PATTERN_HAVING_SUFFIX.matcher(suffix).matches()) {
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + suffix + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d ?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f ^[0-9%!=<>]+$ \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
            }
            Object[] ckeys = StringUtil.split(expression.substring(start + 1, end));
            if (ckeys != null) {
                for (int j = 0; j < ckeys.length; ++j) {
                    if (this.isPrepared() && (!StringUtil.isName((String)ckeys[j]) || ((String)ckeys[j]).startsWith("_"))) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + (String)ckeys[j] + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
                    }
                    ckeys[j] = this.getKey((String)ckeys[j]);
                }
            }
            keys[i] = method + "(" + StringUtil.getString(ckeys) + ")" + suffix;
        }
        return " HAVING " + StringUtil.getString(keys, " AND ");
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    public AbstractSQLConfig setOrder(String ... conditions) {
        return this.setOrder(StringUtil.getString(conditions));
    }

    @Override
    public AbstractSQLConfig setOrder(String order) {
        this.order = order;
        return this;
    }

    @JSONField(serialize=false)
    public String getOrderString() {
        Object[] keys;
        this.order = StringUtil.getTrimedString(this.order);
        if (this.order.isEmpty()) {
            return "";
        }
        if (this.order.contains("+")) {
            this.order = this.order.replaceAll("\\+", " ASC ");
        }
        if (this.order.contains("-")) {
            this.order = this.order.replaceAll("-", " DESC ");
        }
        if ((keys = StringUtil.split(this.order)) == null || keys.length <= 0) {
            return "";
        }
        for (int i = 0; i < keys.length; ++i) {
            Object origin;
            String sort;
            int index;
            int n = index = keys[i].trim().endsWith(" ASC") ? ((String)keys[i]).lastIndexOf(" ASC") : -1;
            if (index < 0) {
                index = ((String)keys[i]).trim().endsWith(" DESC") ? ((String)keys[i]).lastIndexOf(" DESC") : -1;
                sort = index <= 0 ? "" : " DESC ";
            } else {
                sort = " ASC ";
            }
            Object object = origin = index < 0 ? keys[i] : ((String)keys[i]).substring(0, index);
            if (this.isPrepared() && !StringUtil.isName((String)origin)) {
                throw new IllegalArgumentException("\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @order:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column+ / column- \u4e2d column\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey((String)origin) + sort;
        }
        return " ORDER BY " + StringUtil.getString(keys);
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public AbstractSQLConfig setColumn(String ... keys) {
        return this.setColumn(StringUtil.getString(keys));
    }

    @Override
    public AbstractSQLConfig setColumn(String column) {
        this.column = column;
        return this;
    }

    @JSONField(serialize=false)
    public String getColumnString() throws Exception {
        switch (this.getMethod()) {
            case HEAD: 
            case HEADS: {
                if (this.isPrepared() && !StringUtil.isEmpty(this.column, true) && !this.column.contains(",") && !StringUtil.isName(this.column)) {
                    throw new IllegalArgumentException("HEAD\u8bf7\u6c42: @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
                }
                return SQL.count(this.column);
            }
            case POST: {
                String[] keys;
                if (StringUtil.isEmpty(this.column, true)) {
                    throw new NotExistException("SQLConfiggetColumnString  getMethod() = POST >> StringUtil.isEmpty(column, true)");
                }
                if (this.isPrepared() && (keys = StringUtil.split(this.column)) != null && keys.length > 0) {
                    for (int i = 0; i < keys.length; ++i) {
                        if (StringUtil.isName(keys[i])) continue;
                        throw new IllegalArgumentException("POST\u8bf7\u6c42: \u6bcf\u4e00\u4e2a key:value \u4e2d\u7684key\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
                    }
                }
                return "(" + this.column + ")";
            }
            case GET: 
            case GETS: {
                boolean isQuery = RequestMethod.isQueryMethod(this.method);
                String joinColumn = "";
                if (isQuery && this.joinList != null) {
                    boolean first = true;
                    for (Join j : this.joinList) {
                        SQLConfig c = j.getJoinConfig();
                        c.setAlias(c.getTable());
                        joinColumn = joinColumn + (first ? "" : ", ") + ((AbstractSQLConfig)c).getColumnString();
                        first = false;
                    }
                }
                String tableAlias = this.getAlias();
                String c = StringUtil.getString(this.column);
                Object[] keys = StringUtil.split(c, ";");
                if (keys == null || keys.length <= 0) {
                    return !this.isKeyPrefix() ? "*" : tableAlias + ".*" + (StringUtil.isEmpty(joinColumn, true) ? "" : ", " + joinColumn);
                }
                String method = null;
                for (int i = 0; i < keys.length; ++i) {
                    String alias;
                    boolean isColumn;
                    Object[] ckeys;
                    Object expression = keys[i];
                    int start = ((String)expression).indexOf("(");
                    int end = 0;
                    if (start >= 0) {
                        end = ((String)expression).indexOf(")");
                        if (start >= end) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + (String)expression + " \u4e0d\u5408\u6cd5\uff01@having:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
                        }
                        method = ((String)expression).substring(0, start);
                        if (!StringUtil.isName(method)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2dSQL\u51fd\u6570\u540d function \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f ^[0-9a-zA-Z_]+$ \uff01");
                        }
                    }
                    if ((ckeys = StringUtil.split((String)((isColumn = start < 0) ? expression : ((String)expression).substring(start + 1, end)))) != null && ckeys.length > 0) {
                        for (int j = 0; j < ckeys.length; ++j) {
                            int index = ((String)ckeys[j]).lastIndexOf(":");
                            Object origin = index < 0 ? ckeys[j] : ((String)ckeys[j]).substring(0, index);
                            String string = alias = index < 0 ? null : ((String)ckeys[j]).substring(index + 1);
                            if (this.isPrepared()) {
                                if (isColumn) {
                                    if (!StringUtil.isName((String)origin) || alias != null && !StringUtil.isName(alias)) {
                                        throw new IllegalArgumentException("GET\u8bf7\u6c42: \u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                                    }
                                } else if (!StringUtil.isName((String)ckeys[j]) || ((String)ckeys[j]).startsWith("_")) {
                                    throw new IllegalArgumentException("\u5b57\u7b26 " + (String)ckeys[j] + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
                                }
                            }
                            if (this.isKeyPrefix()) {
                                ckeys[j] = tableAlias + "." + (String)origin;
                                if (!isColumn) continue;
                                int n = j;
                                ckeys[n] = (String)ckeys[n] + " AS `" + (this.isMain() ? "" : tableAlias + ".") + (String)(StringUtil.isEmpty(alias, true) ? origin : alias) + "`";
                                continue;
                            }
                            ckeys[j] = (String)origin + (StringUtil.isEmpty(alias, true) ? "" : " AS `" + alias + "`");
                        }
                    }
                    if (isColumn) {
                        keys[i] = StringUtil.getString(ckeys);
                        continue;
                    }
                    String suffix = ((String)expression).substring(end + 1, ((String)expression).length());
                    String string = alias = suffix.startsWith(":") ? suffix.substring(1) : null;
                    if (StringUtil.isEmpty(alias, true)) {
                        if (!suffix.isEmpty()) {
                            throw new IllegalArgumentException("GET\u8bf7\u6c42: \u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 ; \u5206\u5272\u7684\u6bcf\u4e00\u9879 function(arg0,arg1,...):alias \u4e2d alias \u5982\u679c\u6709\u5c31\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                        }
                    } else if (!StringUtil.isEmpty(alias, true) && !StringUtil.isName(alias)) {
                        throw new IllegalArgumentException("GET\u8bf7\u6c42: \u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 ; \u5206\u5272\u7684\u6bcf\u4e00\u9879 function(arg0,arg1,...):alias \u4e2d alias \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                    }
                    String origin = method + "(" + StringUtil.getString(ckeys) + ")";
                    keys[i] = this.isKeyPrefix() ? origin + " AS `" + (this.isMain() ? "" : tableAlias + ".") + (StringUtil.isEmpty(alias, true) ? method : alias) + "`" : origin + (StringUtil.isEmpty(alias, true) ? "" : " AS `" + alias + "`");
                }
                c = StringUtil.getString(keys);
                return (!c.contains(":") ? c : c.replaceAll(":", " AS ")) + (StringUtil.isEmpty(joinColumn, true) ? "" : ", " + joinColumn);
            }
        }
        throw new UnsupportedOperationException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1agetColumnString \u4e0d\u652f\u6301 " + RequestMethod.getName(this.getMethod()) + " \u7b49 [GET,GETS,HEAD,HEADS,POST] \u5916\u7684ReuqestMethod\uff01");
    }

    @Override
    public String getValues() {
        return this.values;
    }

    @JSONField(serialize=false)
    public String getValuesString() {
        return this.values;
    }

    public AbstractSQLConfig setValues(Object[][] valuess) {
        String s = "";
        if (valuess != null && valuess.length > 0) {
            Object[] items = new Object[valuess.length];
            for (int i = 0; i < valuess.length; ++i) {
                Object[] vs = valuess[i];
                if (vs == null) continue;
                items[i] = "(";
                for (int j = 0; j < vs.length; ++j) {
                    int n = i;
                    items[n] = items[n] + (j <= 0 ? "" : ",") + this.getValue(vs[j]);
                }
                int n = i;
                items[n] = items[n] + ")";
            }
            s = StringUtil.getString(items);
        }
        return this.setValues(s);
    }

    @Override
    public AbstractSQLConfig setValues(String values) {
        this.values = values;
        return this;
    }

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public AbstractSQLConfig setContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public AbstractSQLConfig setCount(int count) {
        this.count = count;
        return this;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public AbstractSQLConfig setPage(int page) {
        this.page = page;
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public AbstractSQLConfig setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getQuery() {
        return this.query;
    }

    @Override
    public AbstractSQLConfig setQuery(int query) {
        this.query = query;
        return this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public AbstractSQLConfig setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public List<Join> getJoinList() {
        return this.joinList;
    }

    @Override
    public SQLConfig setJoinList(List<Join> joinList) {
        this.joinList = joinList;
        return this;
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public AbstractSQLConfig setTest(boolean test) {
        this.test = test;
        return this;
    }

    @Override
    public boolean isCacheStatic() {
        return this.cacheStatic;
    }

    @Override
    public AbstractSQLConfig setCacheStatic(boolean cacheStatic) {
        this.cacheStatic = cacheStatic;
        return this;
    }

    @JSONField(serialize=false)
    public int getOffset() {
        return AbstractSQLConfig.getOffset(this.getPage(), this.getCount());
    }

    public static int getOffset(int page, int count) {
        return page * count;
    }

    @JSONField(serialize=false)
    public String getLimitString() {
        return AbstractSQLConfig.getLimitString(this.getPage(), this.getCount());
    }

    public static String getLimitString(int page, int count) {
        return "";
    }

    @Override
    public Map<String, Object> getWhere() {
        return this.where;
    }

    @Override
    public AbstractSQLConfig setWhere(Map<String, Object> where) {
        this.where = where;
        return this;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getCombine() {
        List<String> andList;
        List<String> list = andList = this.combine == null ? null : this.combine.get("&");
        if (andList == null) {
            List<String> list2 = andList = this.where == null ? new ArrayList<String>() : new ArrayList<String>(this.where.keySet());
            if (this.combine == null) {
                this.combine = new HashMap<String, List<String>>();
            }
            this.combine.put("&", andList);
        }
        return this.combine;
    }

    @Override
    public AbstractSQLConfig setCombine(Map<String, List<String>> combine) {
        this.combine = combine;
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key) {
        return this.getWhere(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key, boolean exactMatch) {
        Set<String> set;
        if (exactMatch) {
            return this.where == null ? null : this.where.get(key);
        }
        Set<String> set2 = set = key == null || this.where == null ? null : this.where.keySet();
        if (set != null) {
            Map<String, Object> map = this.where;
            synchronized (map) {
                if (this.where != null) {
                    for (String k : set) {
                        int index = k.indexOf(key);
                        if (index < 0 || StringUtil.isName(k.substring(index))) continue;
                        return this.where.get(k);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AbstractSQLConfig putWhere(String key, Object value, boolean prior) {
        if (key != null) {
            List<String> andList;
            if (this.where == null) {
                this.where = new LinkedHashMap<String, Object>();
            }
            this.where.put(key, value);
            this.combine = this.getCombine();
            List<String> list = andList = this.combine == null ? null : this.combine.get("&");
            if (value == null) {
                andList.remove(key);
            } else if (andList == null || !andList.contains(key)) {
                int i = 0;
                if (andList == null) {
                    andList = new ArrayList<String>();
                } else if (prior && !andList.isEmpty()) {
                    if (andList.contains(JSONObject.KEY_ID)) {
                        ++i;
                    }
                    if (andList.contains(JSONObject.KEY_ID_IN)) {
                        ++i;
                    }
                    if (andList.contains(JSONObject.KEY_USER_ID)) {
                        ++i;
                    }
                    if (andList.contains(JSONObject.KEY_USER_ID_IN)) {
                        ++i;
                    }
                }
                if (prior) {
                    andList.add(i, key);
                } else {
                    andList.add(key);
                }
            }
            this.combine.put("&", andList);
        }
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix) throws Exception {
        return this.getWhereString(hasPrefix, this.getMethod(), this.getWhere(), this.getCombine(), this.getJoinList(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix, RequestMethod method, Map<String, Object> where, Map<String, List<String>> combine, List<Join> joinList, boolean verifyName) throws Exception {
        String s;
        int logic;
        Set<Map.Entry<String, List<String>>> combineSet;
        Set<Map.Entry<String, List<String>>> set = combineSet = combine == null ? null : combine.entrySet();
        if (combineSet == null || combineSet.isEmpty()) {
            Log.w(TAG, "getWhereString  combineSet == null || combineSet.isEmpty() >> return \"\";");
            return "";
        }
        String whereString = "";
        boolean isCombineFirst = true;
        for (Map.Entry<String, List<String>> ce : combineSet) {
            List<String> keyList = ce == null ? null : ce.getValue();
            if (keyList == null || keyList.isEmpty()) continue;
            logic = "|".equals(ce.getKey()) ? 0 : ("!".equals(ce.getKey()) ? 2 : 1);
            boolean isItemFirst = true;
            String cs = "";
            for (String key : keyList) {
                String c = this.getWhereItem(key, where.get(key), method, verifyName);
                if (StringUtil.isEmpty(c, true)) continue;
                cs = cs + (isItemFirst ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + "(" + c + ")";
                isItemFirst = false;
            }
            whereString = whereString + (isCombineFirst ? "" : " AND ") + (Logic.isNot(logic) ? " NOT " : "") + " (  " + cs + "  ) ";
            isCombineFirst = false;
        }
        if (joinList != null) {
            for (Join j : joinList) {
                switch (j.getJoinType()) {
                    case "": 
                    case "|": 
                    case "&": 
                    case "!": {
                        logic = Logic.getType(j.getJoinType());
                        SQLConfig jc = j.getJoinConfig();
                        boolean isMain = jc.isMain();
                        jc.setMain(false).setPrepared(this.isPrepared()).setPreparedValueList(new ArrayList<Object>());
                        String js = jc.getWhereString(false);
                        jc.setMain(isMain);
                        if (StringUtil.isEmpty(js, true)) break;
                        whereString = " ( " + AbstractSQLConfig.getCondition(Logic.isNot(logic), whereString + (StringUtil.isEmpty(whereString, true) ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + " ( " + js + " ) ") + " ) ";
                        this.preparedValueList.addAll(jc.getPreparedValueList());
                    }
                }
            }
        }
        String string = (whereString = whereString + (whereString.isEmpty() ? " " : " AND") + " rownum <= " + (this.page + 1) * this.count).isEmpty() ? "" : (s = (hasPrefix ? " WHERE " : "") + whereString);
        if (s.isEmpty() && !RequestMethod.isQueryMethod(method)) {
            throw new UnsupportedOperationException("\u5199\u64cd\u4f5c\u8bf7\u6c42\u5fc5\u987b\u5e26\u6761\u4ef6\uff01\uff01\uff01");
        }
        return s;
    }

    private String getWhereItem(String key, Object value, RequestMethod method, boolean verifyName) throws Exception {
        Log.d(TAG, "getWhereItem  key = " + key);
        if (key == null || value == null || key.startsWith("@") || key.endsWith("()")) {
            Log.d(TAG, "getWhereItem  key == null || value == null || key.startsWith(@) || key.endsWith(()) >> continue;");
            return null;
        }
        if (key.endsWith("@")) {
            throw new IllegalArgumentException("SQLConfig.getWhereItem: \u5b57\u7b26 " + key + " \u4e0d\u5408\u6cd5\uff01");
        }
        int keyType = key.endsWith("$") ? 1 : (key.endsWith("?") ? 2 : (key.endsWith("{}") ? 3 : (key.endsWith("<>") ? 4 : 0)));
        key = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
        switch (keyType) {
            case 1: {
                return this.getSearchString(key, value);
            }
            case 2: {
                return this.getRegExpString(key, value);
            }
            case 3: {
                return this.getRangeString(key, value);
            }
            case 4: {
                return this.getContainString(key, value);
            }
        }
        return this.getEqualString(key, value);
    }

    @JSONField(serialize=false)
    public String getEqualString(String key, Object value) {
        return this.getKey(key) + "=" + this.getValue(value);
    }

    public String getKey(String key) {
        return (this.isKeyPrefix() ? this.getAlias() + "." : "") + key;
    }

    private Object getValue(@NotNull Object value) {
        if (this.isPrepared()) {
            this.preparedValueList.add(value);
            return "?";
        }
        return "'" + value + "'";
    }

    @Override
    public List<Object> getPreparedValueList() {
        return this.preparedValueList;
    }

    @Override
    public AbstractSQLConfig setPreparedValueList(List<Object> preparedValueList) {
        this.preparedValueList = preparedValueList;
        return this;
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, Object value) throws IllegalArgumentException {
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getSearchString key = " + key);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getSearchString(key, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + "$\":value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u4e3aString\u6216String[]\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getLikeString(key, values[i]);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getLikeString(String key, Object value) {
        return this.getKey(key) + " LIKE " + this.getValue(value);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, Object value) throws IllegalArgumentException {
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getRegExpString key = " + key);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getRegExpString(key, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + "$\":value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u4e3aString\u6216String[]\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getRegExpString(key, (String)values[i]);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, String value) {
        return this.getKey(key) + " REGEXP " + this.getValue(value);
    }

    @JSONField(serialize=false)
    public String getRangeString(String key, Object range) throws Exception {
        Log.i(TAG, "getRangeString key = " + key);
        if (range == null) {
            throw new NotExistException("SQLConfiggetRangeString(" + key + ", " + range + ") range == null");
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getRangeString key = " + key);
        if (range instanceof List) {
            if (logic.isOr() || logic.isNot()) {
                return this.getKey(key) + this.getInString(key, ((List)range).toArray(), logic.isNot());
            }
            throw new IllegalArgumentException(key + "{}\":[] \u4e2dkey\u672b\u5c3e\u7684\u903b\u8f91\u8fd0\u7b97\u7b26\u53ea\u80fd\u7528'|','!'\u4e2d\u7684\u4e00\u79cd \uff01");
        }
        if (range instanceof String) {
            if (this.isPrepared() && !PATTERN_RANGE.matcher((String)range).matches()) {
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + range + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b key{}:\"condition\" \u4e2d condition \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f ^[0-9%!=<>,]+$ \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
            }
            String[] conditions = StringUtil.split((String)range);
            String condition = "";
            if (conditions != null) {
                for (int i = 0; i < conditions.length; ++i) {
                    int index = conditions[i] == null ? -1 : conditions[i].indexOf("(");
                    condition = condition + (i <= 0 ? "" : (logic.isAnd() ? " AND " : " OR ")) + (index >= 0 && index < conditions[i].indexOf(")") ? "" : this.getKey(key) + " ") + conditions[i];
                }
            }
            if (condition.isEmpty()) {
                return "";
            }
            return AbstractSQLConfig.getCondition(logic.isNot(), condition);
        }
        throw new IllegalArgumentException(key + "{}:range \u7c7b\u578b\u4e3a" + range.getClass().getSimpleName() + "\uff01range\u53ea\u80fd\u662f \u7528','\u5206\u9694\u6761\u4ef6\u7684\u5b57\u7b26\u4e32 \u6216\u8005 \u53ef\u53d6\u9009\u9879JSONArray\uff01");
    }

    @JSONField(serialize=false)
    public String getInString(String key, Object[] in, boolean not) throws NotExistException {
        String condition = "";
        if (in != null) {
            for (int i = 0; i < in.length; ++i) {
                condition = condition + (i > 0 ? "," : "") + this.getValue(in[i]);
            }
        }
        if (condition.isEmpty()) {
            throw new NotExistException("SQLConfig.getInString(" + key + ", [], " + not + ") >> condition.isEmpty() >> IN()");
        }
        return (not ? " NOT " : "") + " IN (" + condition + ")";
    }

    @JSONField(serialize=false)
    public String getContainString(String key, Object value) throws NotExistException {
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(key);
        key = logic.getKey();
        Log.i(TAG, "getRangeString key = " + key);
        return this.getContainString(key, AbstractSQLConfig.newJSONArray(value).toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getContainString(String key, Object[] childs, int type) throws IllegalArgumentException {
        boolean not = Logic.isNot(type);
        String condition = "";
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i] == null) continue;
                if (childs[i] instanceof JSON) {
                    throw new IllegalArgumentException(key + "<>\":value \u4e2dvalue\u7c7b\u578b\u4e0d\u80fd\u4e3aJSON\uff01");
                }
                if (childs[i] instanceof String) {
                    childs[i] = "\"" + childs[i] + "\"";
                }
                condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + "JSON_CONTAINS(" + this.getKey(key) + ", " + this.getValue(childs[i]) + ")";
            }
            condition = condition.isEmpty() ? SQL.isNull(key, true) + " OR " + this.getLikeString(key, "[]") : SQL.isNull(key, false) + " AND " + "(" + condition + ")";
        }
        if (condition.isEmpty()) {
            return "";
        }
        return AbstractSQLConfig.getCondition(not, condition);
    }

    private static String getCondition(boolean not, String condition) {
        return not ? " NOT (" + condition + ")" : condition;
    }

    @NotNull
    public static JSONArray newJSONArray(Object obj) {
        JSONArray array = new JSONArray();
        if (obj != null) {
            if (obj instanceof Collection) {
                array.addAll((Collection)obj);
            } else {
                array.add(obj);
            }
        }
        return array;
    }

    @JSONField(serialize=false)
    public String getSetString() throws Exception {
        return this.getSetString(this.getMethod(), this.getContent(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getSetString(RequestMethod method, Map<String, Object> content, boolean verifyName) throws Exception {
        Set<String> set;
        Set<String> set2 = set = content == null ? null : content.keySet();
        if (set != null && set.size() > 0) {
            String setString = "";
            boolean isFirst = true;
            int keyType = 0;
            for (String key : set) {
                if (key == null || JSONObject.KEY_ID.equals(key)) continue;
                if (key.endsWith("+")) {
                    keyType = 1;
                } else if (key.endsWith("-")) {
                    keyType = 2;
                }
                Object value = content.get(key);
                key = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
                setString = setString + (isFirst ? "" : ", ") + key + "=" + (keyType == 1 ? this.getAddString(key, value) : (keyType == 2 ? this.getRemoveString(key, value) : this.getValue(value)));
                isFirst = false;
            }
            if (setString.isEmpty()) {
                throw new NotExistException("SQLConfiggetSetString  >> setString.isEmpty()");
            }
            return " SET " + setString;
        }
        return "";
    }

    @JSONField(serialize=false)
    public String getAddString(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return key + " + " + value;
        }
        if (value instanceof String) {
            return " CONCAT (" + key + ", " + this.getValue(value) + ") ";
        }
        throw new IllegalArgumentException(key + "+ \u5bf9\u5e94\u7684\u503c " + value + " \u4e0d\u662fNumber,String,Array\u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @JSONField(serialize=false)
    public String getRemoveString(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return key + " - " + value;
        }
        if (value instanceof String) {
            return SQL.replace(key, (String)this.getValue(value), "");
        }
        throw new IllegalArgumentException(key + "- \u5bf9\u5e94\u7684\u503c " + value + " \u4e0d\u662fNumber,String,Array\u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @Override
    @JSONField(serialize=false)
    public String getSQL(boolean prepared) throws Exception {
        return AbstractSQLConfig.getSQL(this.setPrepared(prepared));
    }

    public static String getSQL(AbstractSQLConfig config) throws Exception {
        String tablePath;
        String string = tablePath = config == null ? null : config.getTablePath();
        if (!StringUtil.isNotEmpty(tablePath, true)) {
            Log.i(TAG, "getSQL  StringUtil.isNotEmpty(tablePath, true) == false >> return null;");
            return null;
        }
        switch (config.getMethod()) {
            case POST: {
                return "INSERT INTO " + tablePath + config.getColumnString() + " VALUES" + config.getValuesString();
            }
            case PUT: {
                return "UPDATE " + tablePath + config.getSetString() + config.getWhereString(true);
            }
            case DELETE: {
                return "DELETE FROM " + tablePath + config.getWhereString(true);
            }
        }
        config.setPreparedValueList((List)new ArrayList());
        String column = config.getColumnString();
        return "SELECT " + column + " FROM " + AbstractSQLConfig.getConditionString(column, tablePath, config);
    }

    private static String getConditionString(String column, String table, AbstractSQLConfig config) throws Exception {
        String where = config.getWhereString(true);
        String condition = table + config.getJoinString() + where + (!RequestMethod.isGetMethod(config.getMethod(), true) ? "" : config.getGroupString() + config.getHavingString() + config.getOrderString());
        return condition + config.getLimitString();
    }

    @Override
    public boolean isKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public AbstractSQLConfig setKeyPrefix(boolean keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public String getJoinString() throws Exception {
        String joinOns = "";
        if (this.joinList != null) {
            String sql = null;
            for (Join j : this.joinList) {
                SQLConfig jc = j.getJoinConfig();
                jc.setPrepared(this.isPrepared());
                switch (j.getJoinType()) {
                    case "": 
                    case "|": 
                    case "&": 
                    case "!": {
                        sql = " INNER JOIN " + jc.getTablePath() + " ON " + jc.getTable() + "." + j.getKey() + " = " + j.getTargetName() + "." + j.getTargetKey();
                        break;
                    }
                    case "<": 
                    case ">": {
                        jc.setMain(true).setKeyPrefix(false);
                        sql = (">".equals(j.getJoinType()) ? " RIGHT" : " LEFT") + " JOIN ( " + jc.getSQL(this.isPrepared()) + " ) AS " + j.getName() + " ON " + jc.getTable() + "." + j.getKey() + " = " + j.getTargetName() + "." + j.getTargetKey();
                        jc.setMain(false).setKeyPrefix(true);
                        this.preparedValueList.addAll(jc.getPreparedValueList());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1a\u4e0d\u652f\u6301JOIN\u7c7b\u578b " + this.type + " !");
                    }
                }
                joinOns = joinOns + "  \n  " + sql;
            }
        }
        return joinOns;
    }

    public static AbstractSQLConfig newSQLConfig(RequestMethod method, String table, com.alibaba.fastjson.JSONObject request, List<Join> joinList, Callback callback) throws Exception {
        String id;
        if (request == null) {
            throw new NullPointerException("SQLConfig: newSQLConfig  request == null!");
        }
        AbstractSQLConfig config = callback.getSQLConfig(method, table);
        if (request.isEmpty()) {
            return config;
        }
        Object idIn = request.get((Object)JSONObject.KEY_ID_IN);
        if (method == RequestMethod.POST) {
            if (idIn != null) {
                if (!(idIn instanceof List) || ((List)idIn).isEmpty()) {
                    throw new IllegalArgumentException("POST\u8bf7\u6c42\uff0c\u751f\u6210\u591a\u6761\u8bb0\u5f55\u8bf7\u7528 id{}:[] \uff01 [] \u7c7b\u578b\u4e3aJSONArray\u4e14\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else if (request.get((Object)JSONObject.KEY_ID) == null) {
                request.put(JSONObject.KEY_ID, (Object)System.currentTimeMillis());
            }
        }
        if ((id = request.getString(JSONObject.KEY_ID)) != null && idIn != null && idIn instanceof List && idIn != null && !((List)idIn).contains(id)) {
            Log.w(TAG, "newSQLConfig  id > 0 >> idInObj != null && idInObj.contains(id) == false >> return null;");
            throw new NotExistException("SQLConfig: newSQLConfig  idIn != null && ((JSONArray) idIn).contains(id) == false");
        }
        String role = request.getString("@role");
        String database = request.getString("@database");
        String schema = request.getString("@schema");
        String combine = request.getString("@combine");
        String column = request.getString("@column");
        String group = request.getString("@group");
        String having = request.getString("@having");
        String order = request.getString("@order");
        request.remove((Object)JSONObject.KEY_ID);
        request.remove((Object)JSONObject.KEY_ID_IN);
        request.remove((Object)"@role");
        request.remove((Object)"@database");
        request.remove((Object)"@schema");
        request.remove((Object)"@combine");
        request.remove((Object)"@column");
        request.remove((Object)"@group");
        request.remove((Object)"@having");
        request.remove((Object)"@order");
        LinkedHashMap<String, Object> tableWhere = new LinkedHashMap<String, Object>();
        Set set = request.keySet();
        if (method == RequestMethod.POST) {
            if (set != null && !set.isEmpty()) {
                Object[] values;
                ArrayList<String> idList;
                if (id != null) {
                    if (idIn != null) {
                        throw new IllegalArgumentException("POST\u8bf7\u6c42\u4e2d id \u548c id{} \u4e0d\u80fd\u540c\u65f6\u5b58\u5728!");
                    }
                    idList = new ArrayList(1);
                    idList.add(id);
                } else {
                    idList = new ArrayList<String>((Collection<String>)((JSONArray)idIn));
                }
                Object[] columns = set.toArray(new String[0]);
                Collection valueCollection = request.values();
                Object[] objectArray = values = valueCollection == null ? null : valueCollection.toArray();
                if (values == null || values.length != columns.length) {
                    throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef:\nSQLConfig newSQLConfig  values == null || values.length != columns.length !");
                }
                column = JSONObject.KEY_ID + "," + StringUtil.getString(columns);
                int size = columns.length + 1;
                Object[][] valuess = new Object[idList.size()][];
                for (int i = 0; i < idList.size(); ++i) {
                    Object[] items = new Object[size];
                    items[0] = idList.get(i);
                    for (int j = 1; j < size; ++j) {
                        items[j] = values[j - 1];
                    }
                    valuess[i] = items;
                }
                config.setValues(valuess);
            }
        } else {
            String[] ws;
            boolean isWhere = method != RequestMethod.PUT;
            ArrayList<String> whereList = null;
            LinkedHashMap combineMap = new LinkedHashMap();
            ArrayList<String> andList = new ArrayList<String>();
            ArrayList<String> orList = new ArrayList<String>();
            ArrayList<String> notList = new ArrayList<String>();
            if (id != null) {
                tableWhere.put(JSONObject.KEY_ID, id);
                andList.add(JSONObject.KEY_ID);
            }
            if (idIn != null) {
                tableWhere.put(JSONObject.KEY_ID_IN, idIn);
                andList.add(JSONObject.KEY_ID_IN);
            }
            if ((ws = StringUtil.split(combine)) != null) {
                if (method == RequestMethod.DELETE || method == RequestMethod.GETS || method == RequestMethod.HEADS) {
                    throw new IllegalArgumentException("DELETE,GETS,HEADS \u8bf7\u6c42\u4e0d\u5141\u8bb8\u4f20 @combine:\"conditons\" !");
                }
                whereList = new ArrayList<String>();
                for (int i = 0; i < ws.length; ++i) {
                    String w = ws[i];
                    if (w != null) {
                        if (w.startsWith("&")) {
                            w = w.substring(1);
                            andList.add(w);
                        } else if (w.startsWith("|")) {
                            if (method == RequestMethod.PUT) {
                                throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                            }
                            w = w.substring(1);
                            orList.add(w);
                        } else if (w.startsWith("!")) {
                            if (method == RequestMethod.PUT) {
                                throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                            }
                            w = w.substring(1);
                            notList.add(w);
                        } else {
                            orList.add(w);
                        }
                        if (w.isEmpty()) {
                            throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u503c\uff01");
                        }
                        if (JSONObject.KEY_ID.equals(w) || JSONObject.KEY_ID_IN.equals(w) || JSONObject.KEY_USER_ID.equals(w) || JSONObject.KEY_USER_ID_IN.equals(w)) {
                            throw new UnsupportedOperationException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20 [" + JSONObject.KEY_ID + ", " + JSONObject.KEY_ID_IN + ", " + JSONObject.KEY_USER_ID + ", " + JSONObject.KEY_USER_ID_IN + "] \u5176\u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                        }
                        whereList.add(w);
                    }
                    if (request.containsKey((Object)w)) continue;
                    throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc " + ws[i] + " \u5bf9\u5e94\u7684 " + w + " \u4e0d\u5728\u5b83\u91cc\u9762\uff01");
                }
            }
            LinkedHashMap<String, Object> tableContent = new LinkedHashMap<String, Object>();
            for (String key : set) {
                Object value = request.get((Object)key);
                if (value instanceof Map) {
                    throw new IllegalArgumentException("\u4e0d\u5141\u8bb8 " + key + " \u7b49\u4efb\u4f55key\u7684value\u7c7b\u578b\u4e3a {JSONObject} !");
                }
                if (isWhere) {
                    tableWhere.put(key, value);
                    if (whereList != null && whereList.contains(key)) continue;
                    andList.add(key);
                    continue;
                }
                if (whereList != null && whereList.contains(key)) {
                    tableWhere.put(key, value);
                    continue;
                }
                tableContent.put(key, value);
            }
            combineMap.put("&", andList);
            combineMap.put("|", orList);
            combineMap.put("!", notList);
            config.setCombine((Map)combineMap);
            config.setContent(tableContent);
        }
        config.setWhere(tableWhere);
        config.setId(id == null ? "" : id);
        config.setRole(role);
        config.setDatabase(database);
        config.setSchema(schema);
        config.setColumn(column);
        config.setGroup(group);
        config.setHaving(having);
        config.setOrder(order);
        config.setJoinList(AbstractSQLConfig.parseJoin(method, joinList, callback));
        config.setKeyPrefix(RequestMethod.isQueryMethod(method) && (!config.isMain() || joinList != null && !joinList.isEmpty()));
        request.put(JSONObject.KEY_ID, (Object)id);
        request.put(JSONObject.KEY_ID_IN, idIn);
        request.put("@role", (Object)role);
        request.put("@database", (Object)database);
        request.put("@schema", (Object)schema);
        request.put("@combine", (Object)combine);
        request.put("@column", (Object)column);
        request.put("@group", (Object)group);
        request.put("@having", (Object)having);
        request.put("@order", (Object)order);
        return config;
    }

    public static List<Join> parseJoin(RequestMethod method, List<Join> joinList, Callback callback) throws Exception {
        if (joinList == null || joinList.isEmpty()) {
            return null;
        }
        for (Join j : joinList) {
            String name = j.getName();
            AbstractSQLConfig joinConfig = AbstractSQLConfig.newSQLConfig(method, name, j.getTable(), null, callback).setMain(false).setKeyPrefix(true);
            AbstractSQLConfig cacheConfig = AbstractSQLConfig.newSQLConfig(method, name, j.getTable(), null, callback).setCount(1);
            j.setJoinConfig(joinConfig);
            j.setCacheConfig(cacheConfig);
        }
        return joinList;
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic) throws Exception {
        return AbstractSQLConfig.getRealKey(method, originKey, isTableKey, saveLogic, true);
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic, boolean verifyName) throws Exception {
        Log.i(TAG, "getRealKey  saveLogic = " + saveLogic + "; originKey = " + originKey);
        if (originKey == null || originKey.startsWith("`") || JSONObject.isArrayKey(originKey)) {
            Log.w(TAG, "getRealKey  originKey == null || originKey.startsWith(`) || zuo.biao.apijson.JSONObject.isArrayKey(originKey) >>  return originKey;");
            return originKey;
        }
        String key = new String(originKey);
        if (key.endsWith("$")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("?")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("{}")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("<>")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("()")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("@")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("+")) {
            if (method == RequestMethod.PUT) {
                key = key.substring(0, key.length() - 1);
            }
        } else if (key.endsWith("-") && method == RequestMethod.PUT) {
            key = key.substring(0, key.length() - 1);
        }
        String last = null;
        if (RequestMethod.isQueryMethod(method)) {
            String string = last = key.isEmpty() ? "" : key.substring(key.length() - 1);
            if ("&".equals(last) || "|".equals(last) || "!".equals(last)) {
                key = key.substring(0, key.length() - 1);
            } else {
                last = null;
            }
        }
        key = isTableKey ? Pair.parseEntry(key, true).getKey() : Pair.parseEntry(key).getValue();
        if (verifyName && !StringUtil.isName(key.startsWith("@") ? key.substring(1) : key)) {
            throw new IllegalArgumentException((Object)((Object)method) + "\u8bf7\u6c42\uff0c\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01 key:value \u4e2d\u7684key\u53ea\u80fd\u5173\u952e\u8bcd '@key' \u6216 'key[\u903b\u8f91\u7b26][\u6761\u4ef6\u7b26]' \u6216 PUT\u8bf7\u6c42\u4e0b\u7684 'key+' / 'key-' \uff01");
        }
        if (saveLogic && last != null) {
            key = key + last;
        }
        Log.i(TAG, "getRealKey  return key = " + key);
        return key;
    }

    static {
        TABLE_KEY_MAP.put(Table.class.getSimpleName(), "`tables`");
        TABLE_KEY_MAP.put(Column.class.getSimpleName(), "`columns`");
        PATTERN_RANGE = Pattern.compile("^[0-9%!=<>,]+$");
        PATTERN_HAVING = Pattern.compile("^[A-Za-z0-9%!=<>]+$");
        PATTERN_HAVING_SUFFIX = Pattern.compile("^[0-9%!=<>]+$");
    }

    public static interface Callback {
        public AbstractSQLConfig getSQLConfig(RequestMethod var1, String var2);
    }
}

