/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import zuo.biao.apijson.JSONObject;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.RequestMethod;
import zuo.biao.apijson.StringUtil;
import zuo.biao.apijson.server.AbstractParser;
import zuo.biao.apijson.server.AbstractSQLConfig;
import zuo.biao.apijson.server.JSONRequest;
import zuo.biao.apijson.server.Join;
import zuo.biao.apijson.server.NotNull;
import zuo.biao.apijson.server.ObjectParser;
import zuo.biao.apijson.server.Pair;
import zuo.biao.apijson.server.Parser;
import zuo.biao.apijson.server.SQLConfig;
import zuo.biao.apijson.server.exception.ConflictException;
import zuo.biao.apijson.server.exception.NotExistException;

public abstract class AbstractObjectParser
implements ObjectParser {
    private static final String TAG = "ObjectParser";
    @NotNull
    protected Parser parser;
    protected com.alibaba.fastjson.JSONObject request;
    protected String parentPath;
    protected SQLConfig arrayConfig;
    protected final int type;
    protected final List<Join> joinList;
    protected final boolean isTable;
    protected final String path;
    protected final String table;
    protected final boolean tri;
    protected final boolean drop;
    protected com.alibaba.fastjson.JSONObject correct;
    public static final Map<String, Pattern> COMPILE_MAP = new HashMap<String, Pattern>();
    protected Map<String, String> corrected;
    private boolean invalidate = false;
    private boolean breakParse = false;
    protected com.alibaba.fastjson.JSONObject response;
    protected com.alibaba.fastjson.JSONObject sqlRequest;
    protected com.alibaba.fastjson.JSONObject sqlReponse;
    protected Map<String, Object> customMap;
    protected Map<String, Map<String, String>> functionMap;
    protected Map<String, com.alibaba.fastjson.JSONObject> childMap;
    protected SQLConfig sqlConfig = null;
    protected RequestMethod method;

    public AbstractObjectParser setParser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public AbstractObjectParser(@NotNull com.alibaba.fastjson.JSONObject request, String parentPath, String name, SQLConfig arrayConfig) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("ObjectParser.ObjectParser  request == null!!!");
        }
        this.request = request;
        this.parentPath = parentPath;
        this.arrayConfig = arrayConfig;
        this.type = arrayConfig == null ? 0 : arrayConfig.getType();
        this.joinList = arrayConfig == null ? null : arrayConfig.getJoinList();
        this.path = AbstractParser.getAbsPath(parentPath, name);
        this.table = Pair.parseEntry(name, true).getKey();
        this.isTable = JSONObject.isTableKey(this.table);
        boolean isEmpty = request.isEmpty();
        if (isEmpty) {
            this.tri = false;
            this.drop = false;
        } else {
            this.tri = request.getBooleanValue("@try");
            this.drop = request.getBooleanValue("@drop");
            this.correct = request.getJSONObject("@correct");
            request.remove((Object)"@try");
            request.remove((Object)"@drop");
            request.remove((Object)"@correct");
            try {
                this.parseCorrect();
            }
            catch (Exception e) {
                if (!this.tri) {
                    throw e;
                }
                this.invalidate();
            }
        }
        Log.d(TAG, "ObjectParser  table = " + this.table + "; isTable = " + this.isTable);
        Log.d(TAG, "ObjectParser  isEmpty = " + isEmpty + "; tri = " + this.tri + "; drop = " + this.drop);
    }

    @Override
    public AbstractObjectParser parseCorrect() throws Exception {
        HashSet set;
        HashSet hashSet = set = this.correct == null ? null : new HashSet(this.correct.keySet());
        if (set != null && !set.isEmpty()) {
            this.corrected = new HashMap<String, String>();
            for (String k : set) {
                String v = k == null ? null : this.correct.getString(k);
                String value = v == null ? null : this.request.getString(k);
                String[] posibleKeys = value == null ? null : StringUtil.split(v);
                if (posibleKeys == null || posibleKeys.length <= 0) continue;
                String rk = null;
                for (String pk : posibleKeys) {
                    Pattern p;
                    Pattern pattern = p = pk == null ? null : COMPILE_MAP.get(pk);
                    if (p == null || !p.matcher(value).matches()) continue;
                    rk = pk;
                    break;
                }
                if (rk == null) {
                    throw new IllegalArgumentException("\u683c\u5f0f\u9519\u8bef\uff01\u627e\u4e0d\u5230 " + k + ":" + value + " \u5bf9\u5e94[" + v + "]\u5185\u7684\u4efb\u4f55\u4e00\u9879\uff01");
                }
                this.request.put(rk, this.request.remove((Object)k));
                this.corrected.put(k, rk);
            }
        }
        return this;
    }

    public void invalidate() {
        this.invalidate = true;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public void breakParse() {
        this.breakParse = true;
    }

    public boolean isBreakParse() {
        return this.breakParse || this.isInvalidate();
    }

    @Override
    public AbstractObjectParser parse() throws Exception {
        if (!this.isInvalidate()) {
            this.breakParse = false;
            this.response = new com.alibaba.fastjson.JSONObject(true);
            this.sqlRequest = new com.alibaba.fastjson.JSONObject(true);
            this.sqlReponse = null;
            this.customMap = null;
            this.functionMap = null;
            this.childMap = null;
            LinkedHashSet set = new LinkedHashSet(this.request.entrySet());
            if (set != null && !set.isEmpty()) {
                if (this.isTable) {
                    this.customMap = new LinkedHashMap<String, Object>();
                    this.childMap = new LinkedHashMap<String, com.alibaba.fastjson.JSONObject>();
                }
                this.functionMap = new LinkedHashMap<String, Map<String, String>>();
                ArrayList<String> whereList = null;
                if (this.method == RequestMethod.PUT) {
                    String[] combine = StringUtil.split(this.request.getString("@combine"));
                    if (combine != null) {
                        for (int i = 0; i < combine.length; ++i) {
                            String w = combine[i];
                            if (w == null || !w.startsWith("&") && !w.startsWith("|") && !w.startsWith("!")) continue;
                            combine[i] = w.substring(1);
                        }
                    }
                    whereList = new ArrayList<String>(Arrays.asList(combine != null ? combine : new String[]{}));
                    whereList.add(zuo.biao.apijson.JSONRequest.KEY_ID);
                    whereList.add(zuo.biao.apijson.JSONRequest.KEY_ID_IN);
                }
                int index = 0;
                for (Map.Entry entry : set) {
                    if (this.isBreakParse()) break;
                    Object value = entry.getValue();
                    if (value == null) continue;
                    String key = (String)entry.getKey();
                    try {
                        if (value instanceof com.alibaba.fastjson.JSONObject && !key.startsWith("@")) {
                            if (this.childMap != null) {
                                this.childMap.put(key, (com.alibaba.fastjson.JSONObject)value);
                                continue;
                            }
                            this.response.put(key, (Object)this.onChildParse(index, key, (com.alibaba.fastjson.JSONObject)value));
                            ++index;
                            continue;
                        }
                        if (this.method == RequestMethod.PUT && value instanceof JSONArray && (whereList == null || !whereList.contains(key))) {
                            this.onPUTArrayParse(key, (JSONArray)value);
                            continue;
                        }
                        if (this.onParse(key, value)) continue;
                        this.invalidate();
                    }
                    catch (Exception e) {
                        if (!this.tri) {
                            throw e;
                        }
                        this.invalidate();
                    }
                }
            }
        }
        if (this.isInvalidate()) {
            this.recycle();
            return null;
        }
        return this;
    }

    @Override
    public boolean onParse(@NotNull String key, @NotNull Object value) throws Exception {
        if (key.endsWith("@")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("\"key@\": \u540e\u9762\u5fc5\u987b\u4e3a\u4f9d\u8d56\u8def\u5f84String\uff01");
            }
            String replaceKey = key.substring(0, key.length() - 1);
            String targetPath = AbstractParser.getValuePath(this.type == 1 ? this.path : this.parentPath, new String((String)value));
            Object target = this.onReferenceParse(targetPath);
            Log.i(TAG, "onParse targetPath = " + targetPath + "; target = " + target);
            if (target == null) {
                Log.d(TAG, "onParse  target == null  >>  continue;");
                return true;
            }
            if (target instanceof Map) {
                Log.d(TAG, "onParse  target instanceof Map  >>  continue;");
                return false;
            }
            if (targetPath.equals(target)) {
                Log.d(TAG, "onParse  targetPath.equals(target)  >>");
                if (this.isTable && (!key.startsWith("@") || JSONRequest.TABLE_KEY_LIST.contains(key))) {
                    Log.e(TAG, "onParse  isTable && (key.startsWith(@) == false || JSONRequest.TABLE_KEY_LIST.contains(key)) >>  return null;");
                    return false;
                }
                Log.d(TAG, "onParse  isTable(table) == false >> continue;");
                return true;
            }
            Log.i(TAG, "onParse    >>  key = replaceKey; value = target;");
            key = replaceKey;
            value = target;
            Log.d(TAG, "onParse key = " + key + "; value = " + value);
        }
        if (key.endsWith("()")) {
            String type;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(this.path + "/" + key + ":function() \u540e\u9762\u5fc5\u987b\u4e3a\u51fd\u6570String\uff01");
            }
            String k = key.substring(0, key.length() - 2);
            if (k.endsWith("-")) {
                type = "-";
                k = k.substring(0, k.length() - 1);
                this.parseFunction(this.request, k, (String)value);
            } else {
                if (k.endsWith("+")) {
                    type = "+";
                    k = k.substring(0, k.length() - 1);
                } else {
                    type = "0";
                }
                Map<String, String> map = this.functionMap.get(type);
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                }
                map.put(k, (String)value);
                this.functionMap.put(type, map);
            }
        } else if (this.isTable && key.startsWith("@") && !JSONRequest.TABLE_KEY_LIST.contains(key)) {
            this.customMap.put(key, value);
        } else {
            this.sqlRequest.put(key, value);
        }
        return true;
    }

    @Override
    public JSON onChildParse(int index, String key, com.alibaba.fastjson.JSONObject value) throws Exception {
        boolean isEmpty;
        JSONArray child;
        boolean isMain;
        boolean isFirst = index <= 0;
        boolean bl = isMain = isFirst && this.type == 1;
        if (JSONObject.isArrayKey(key)) {
            if (isMain) {
                throw new IllegalArgumentException(this.parentPath + "/" + key + ":{} \u4e0d\u5408\u6cd5\uff01" + "\u6570\u7ec4 []:{} \u4e2d\u7b2c\u4e00\u4e2a key:{} \u5fc5\u987b\u662f\u4e3b\u8868 TableKey:{} \uff01\u4e0d\u80fd\u4e3a arrayKey[]:{} \uff01");
            }
            child = this.parser.onArrayParse(value, this.path, key);
            isEmpty = child == null || child.isEmpty();
        } else {
            if (this.type == 1 && !JSONRequest.isTableKey(Pair.parseEntry(key, true).getKey())) {
                throw new IllegalArgumentException(this.parentPath + "/" + key + ":{} \u4e0d\u5408\u6cd5\uff01" + "\u6570\u7ec4 []:{} \u4e2d\u6bcf\u4e2a key:{} \u90fd\u5fc5\u987b\u662f\u8868 TableKey:{} \u6216 \u6570\u7ec4 arrayKey[]:{} \uff01");
            }
            child = this.parser.onObjectParse(value, this.path, key, isMain ? this.arrayConfig.setType(2) : null);
            boolean bl2 = isEmpty = child == null || ((com.alibaba.fastjson.JSONObject)child).isEmpty();
            if (isFirst && isEmpty) {
                this.invalidate();
            }
        }
        Log.i(TAG, "onChildParse  ObjectParser.onParse  key = " + key + "; child = " + child);
        return isEmpty ? null : child;
    }

    @Override
    public void onPUTArrayParse(@NotNull String key, @NotNull JSONArray array) throws Exception {
        JSONArray targetArray;
        if (!this.isTable || array.isEmpty()) {
            Log.e(TAG, "onPUTArrayParse  isTable == false || array == null || array.isEmpty() >> return;");
            return;
        }
        int putType = 0;
        if (key.endsWith("+")) {
            putType = 1;
        } else if (key.endsWith("-")) {
            putType = 2;
        }
        String realKey = AbstractSQLConfig.getRealKey(this.method, key, false, false);
        com.alibaba.fastjson.JSONObject rq = new com.alibaba.fastjson.JSONObject();
        rq.put(JSONRequest.KEY_ID, this.request.get((Object)JSONRequest.KEY_ID));
        rq.put("@column", (Object)realKey);
        com.alibaba.fastjson.JSONObject rp = this.parseResponse(new JSONRequest(this.table, rq));
        if (rp != null) {
            rp = rp.getJSONObject(this.table);
        }
        JSONArray jSONArray = targetArray = rp == null ? null : rp.getJSONArray(realKey);
        if (targetArray == null) {
            targetArray = new JSONArray();
        }
        for (Object obj : array) {
            if (obj == null) continue;
            if (putType == 1) {
                if (targetArray.contains(obj)) {
                    throw new ConflictException("PUT " + this.path + ", " + realKey + ":" + obj + " \u5df2\u5b58\u5728\uff01");
                }
                targetArray.add(obj);
                continue;
            }
            if (putType != 2) continue;
            if (!targetArray.contains(obj)) {
                throw new NullPointerException("PUT " + this.path + ", " + realKey + ":" + obj + " \u4e0d\u5b58\u5728\uff01");
            }
            targetArray.remove(obj);
        }
        this.sqlRequest.put(realKey, (Object)targetArray);
    }

    @Override
    public AbstractObjectParser executeSQL() throws Exception {
        return this.executeSQL(1, 0, 0);
    }

    @Override
    public AbstractObjectParser executeSQL(int count, int page, int position) throws Exception {
        if (!this.isTable) {
            this.sqlReponse = new com.alibaba.fastjson.JSONObject((Map)this.sqlRequest);
        } else {
            try {
                if (this.sqlConfig == null) {
                    this.sqlConfig = this.newSQLConfig();
                }
                this.sqlConfig.setCount(count).setPage(page).setPosition(position);
                this.sqlReponse = this.onSQLExecute();
            }
            catch (Exception e) {
                Log.e(TAG, "getObject  try { response = getSQLObject(config2); } catch (Exception e) {");
                if (e instanceof NotExistException) {
                    this.sqlReponse = null;
                }
                throw e;
            }
            if (this.drop) {
                this.sqlReponse = null;
            }
        }
        return this;
    }

    @Override
    public com.alibaba.fastjson.JSONObject response() throws Exception {
        if (this.sqlReponse == null || this.sqlReponse.isEmpty()) {
            if (this.isTable) {
                return this.response;
            }
        } else {
            this.response.putAll((Map)this.sqlReponse);
        }
        if (this.corrected != null) {
            this.response.put("@correct", this.corrected);
        }
        if (this.customMap != null) {
            this.response.putAll(this.customMap);
        }
        this.onFunctionResponse("0");
        this.onChildResponse();
        this.onFunctionResponse("+");
        this.onComplete();
        return this.response;
    }

    @Override
    public void onFunctionResponse(String type) throws Exception {
        Set<Map.Entry<String, String>> functionSet;
        Map<String, String> map = this.functionMap == null ? null : this.functionMap.get(type);
        Set<Map.Entry<String, String>> set = functionSet = map == null ? null : map.entrySet();
        if (functionSet != null && !functionSet.isEmpty()) {
            for (Map.Entry<String, String> entry : functionSet) {
                this.parseFunction(this.response, entry.getKey(), entry.getValue());
            }
        }
    }

    public void parseFunction(com.alibaba.fastjson.JSONObject json, String key, String value) throws Exception {
        Object result = this.onFunctionParse(json, value);
        if (result != null) {
            String k = AbstractSQLConfig.getRealKey(this.method, key, false, false);
            this.response.put(k, result);
            this.parser.putQueryResult(AbstractParser.getAbsPath(this.path, k), result);
        }
    }

    @Override
    public void onChildResponse() throws Exception {
        Set<Map.Entry<String, com.alibaba.fastjson.JSONObject>> set;
        Set<Map.Entry<String, com.alibaba.fastjson.JSONObject>> set2 = set = this.childMap == null ? null : this.childMap.entrySet();
        if (set != null) {
            int index = 0;
            for (Map.Entry<String, com.alibaba.fastjson.JSONObject> entry : set) {
                if (entry == null) continue;
                this.response.put(entry.getKey(), (Object)this.onChildParse(index, entry.getKey(), entry.getValue()));
                ++index;
            }
        }
    }

    @Override
    public Object onFunctionParse(com.alibaba.fastjson.JSONObject json, String function) throws Exception {
        return null;
    }

    @Override
    public Object onReferenceParse(@NotNull String path) {
        return this.parser.getValueByPath(path);
    }

    @Override
    public com.alibaba.fastjson.JSONObject onSQLExecute() throws Exception {
        com.alibaba.fastjson.JSONObject result = this.parser.executeSQL(this.sqlConfig);
        if (result != null) {
            this.parser.putQueryResult(this.path, result);
        }
        return result;
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void recycle() {
        if (this.tri) {
            this.request.put("@try", (Object)this.tri);
        }
        if (this.drop) {
            this.request.put("@drop", (Object)this.drop);
        }
        if (this.correct != null) {
            this.request.put("@correct", (Object)this.correct);
        }
        this.correct = null;
        this.corrected = null;
        this.method = null;
        this.parentPath = null;
        this.arrayConfig = null;
        this.request = null;
        this.response = null;
        this.sqlRequest = null;
        this.sqlReponse = null;
        this.functionMap = null;
        this.customMap = null;
        this.childMap = null;
    }

    @Override
    public AbstractObjectParser setMethod(RequestMethod method) {
        if (this.method != method) {
            this.method = method;
            this.sqlConfig = null;
        }
        return this;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public boolean isTable() {
        return this.isTable;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public SQLConfig getArrayConfig() {
        return this.arrayConfig;
    }

    @Override
    public SQLConfig getSQLConfig() {
        return this.sqlConfig;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getResponse() {
        return this.response;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getSqlRequest() {
        return this.sqlRequest;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getSqlReponse() {
        return this.sqlReponse;
    }

    @Override
    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    @Override
    public Map<String, Map<String, String>> getFunctionMap() {
        return this.functionMap;
    }

    @Override
    public Map<String, com.alibaba.fastjson.JSONObject> getChildMap() {
        return this.childMap;
    }
}

