/*
 * Decompiled with CFR 0.152.
 */
package zuo.biao.apijson;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Set;
import zuo.biao.apijson.JSON;
import zuo.biao.apijson.JSONObject;
import zuo.biao.apijson.Log;
import zuo.biao.apijson.StringUtil;

public class JSONResponse
extends JSONObject {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "JSONResponse";
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_UNSUPPORTED_ENCODING = 400;
    public static final int CODE_ILLEGAL_ACCESS = 401;
    public static final int CODE_UNSUPPORTED_OPERATION = 403;
    public static final int CODE_NOT_FOUND = 404;
    public static final int CODE_ILLEGAL_ARGUMENT = 406;
    public static final int CODE_NOT_LOGGED_IN = 407;
    public static final int CODE_TIME_OUT = 408;
    public static final int CODE_CONFLICT = 409;
    public static final int CODE_CONDITION_ERROR = 412;
    public static final int CODE_UNSUPPORTED_TYPE = 415;
    public static final int CODE_OUT_OF_RANGE = 416;
    public static final int CODE_NULL_POINTER = 417;
    public static final int CODE_SERVER_ERROR = 500;
    public static final String MSG_SUCCEED = "success";
    public static final String MSG_SERVER_ERROR = "Internal Server Error!";
    public static final String KEY_CODE = "code";
    public static final String KEY_MSG = "msg";
    public static final String KEY_COUNT = "count";
    public static final String KEY_TOTAL = "total";

    public JSONResponse() {
    }

    public JSONResponse(String json) {
        this(JSONResponse.parseObject((String)json));
    }

    public JSONResponse(com.alibaba.fastjson.JSONObject object) {
        super(JSONResponse.format(object));
    }

    public int getCode() {
        try {
            return this.getIntValue(KEY_CODE);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getMsg() {
        return this.getString(KEY_MSG);
    }

    public long getId() {
        try {
            return this.getLongValue(KEY_ID);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int getCount() {
        try {
            return this.getIntValue(KEY_COUNT);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getTotal() {
        try {
            return this.getIntValue(KEY_TOTAL);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isSuccess() {
        return JSONResponse.isSuccess(this.getCode());
    }

    public static boolean isSuccess(int code) {
        return code == 200;
    }

    public static boolean isSuccess(JSONResponse response) {
        return response != null && response.isSuccess();
    }

    public boolean isExist() {
        return JSONResponse.isExist(this.getCount());
    }

    public static boolean isExist(int count) {
        return count > 0;
    }

    public static boolean isExist(JSONResponse response) {
        return response != null && response.isExist();
    }

    public JSONResponse getJSONResponse(String key) {
        return this.getObject(key, JSONResponse.class);
    }

    public <T> T getObject(Class<T> clazz) {
        return this.getObject(clazz == null ? "" : clazz.getSimpleName(), clazz);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        return JSONResponse.getObject(this, key, clazz);
    }

    public static <T> T getObject(com.alibaba.fastjson.JSONObject object, String key, Class<T> clazz) {
        return JSONResponse.toObject(object == null ? null : object.getJSONObject(key), clazz);
    }

    public <T> T toObject(Class<T> clazz) {
        return JSONResponse.toObject(this, clazz);
    }

    public static <T> T toObject(com.alibaba.fastjson.JSONObject object, Class<T> clazz) {
        return JSON.parseObject(JSON.toJSONString(object), clazz);
    }

    public <T> List<T> getList(Class<T> clazz) {
        return this.getList("[]", clazz);
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        return JSONResponse.getList(this, key, clazz);
    }

    public static <T> List<T> getList(com.alibaba.fastjson.JSONObject object, Class<T> clazz) {
        return JSONResponse.getList(object, "[]", clazz);
    }

    public static <T> List<T> getList(com.alibaba.fastjson.JSONObject object, String key, Class<T> clazz) {
        return object == null ? null : JSON.parseArray(object.getString(JSONResponse.replaceArray(key)), clazz);
    }

    public JSONArray getArray() {
        return this.getArray("[]");
    }

    public JSONArray getArray(String key) {
        return JSONResponse.getArray(this, key);
    }

    public static JSONArray getArray(com.alibaba.fastjson.JSONObject object) {
        return JSONResponse.getArray(object, "[]");
    }

    public static JSONArray getArray(com.alibaba.fastjson.JSONObject object, String key) {
        return object == null ? null : object.getJSONArray(JSONResponse.replaceArray(key));
    }

    public static com.alibaba.fastjson.JSONObject format(com.alibaba.fastjson.JSONObject object) {
        if (object == null || object.isEmpty()) {
            Log.i(TAG, "format  object == null || object.isEmpty() >> return object;");
            return object;
        }
        com.alibaba.fastjson.JSONObject formatedObject = new com.alibaba.fastjson.JSONObject(true);
        Set set = object.keySet();
        if (set != null) {
            for (String key : set) {
                Object value = object.get((Object)key);
                if (value instanceof JSONArray) {
                    formatedObject.put(JSONResponse.replaceArray(key), (Object)JSONResponse.format((JSONArray)value));
                    continue;
                }
                if (value instanceof com.alibaba.fastjson.JSONObject) {
                    formatedObject.put(JSONResponse.getSimpleName(key), (Object)JSONResponse.format((com.alibaba.fastjson.JSONObject)value));
                    continue;
                }
                formatedObject.put(JSONResponse.getSimpleName(key), value);
            }
        }
        return formatedObject;
    }

    public static JSONArray format(JSONArray array) {
        if (array == null || array.isEmpty()) {
            Log.i(TAG, "format  array == null || array.isEmpty() >> return array;");
            return array;
        }
        JSONArray formatedArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (value instanceof JSONArray) {
                formatedArray.add((Object)JSONResponse.format((JSONArray)value));
                continue;
            }
            if (value instanceof com.alibaba.fastjson.JSONObject) {
                formatedArray.add((Object)JSONResponse.format((com.alibaba.fastjson.JSONObject)value));
                continue;
            }
            formatedArray.add(value);
        }
        return formatedArray;
    }

    public static String replaceArray(String key) {
        if (JSONResponse.isArrayKey(key)) {
            key = JSONResponse.getArrayKey(key.substring(0, key.lastIndexOf("[]")));
        }
        return JSONResponse.getSimpleName(key);
    }

    public static String getArrayKey(String key) {
        return StringUtil.addSuffix(key, "list");
    }

    public static String getSimpleName(String fullName) {
        int index;
        int n = index = fullName == null ? -1 : fullName.indexOf(":");
        if (index >= 0) {
            fullName = fullName.substring(index + 1);
        }
        return fullName;
    }
}

