﻿///////////////////////////////////////////////////////////////////////
//
// Приемочные тесты объекта ЗаписьXML
// 
//
///////////////////////////////////////////////////////////////////////

Перем юТест;

////////////////////////////////////////////////////////////////////
// Программный интерфейс

Функция ПолучитьСписокТестов(ЮнитТестирование) Экспорт
	
	юТест = ЮнитТестирование;
	
	ВсеТесты = Новый Массив;
	
	ВсеТесты.Добавить("ТестДолжен_ЗаписатьВСтроку");
	ВсеТесты.Добавить("ТестДолжен_ЗаписатьВФайл");
	ВсеТесты.Добавить("ТестДолжен_ПрочитатьИзФайлаСРазнымиПереводамиСтрок");
	
	Возврат ВсеТесты;
КонецФункции

Процедура ТестДолжен_ЗаписатьВСтроку() Экспорт

	З = Новый ЗаписьXML;
	З.УстановитьСтроку("windows-1251");
	ЗаписатьСодержимое(З);
	С = З.Закрыть();
	НормализоватьПереводыСтрок(С);
	юТест.ПроверитьРавенство(ЭталонДокумента(), С);
	
КонецПроцедуры

Процедура ТестДолжен_ЗаписатьВФайл() Экспорт

	ВремФайл = КаталогВременныхФайлов() + "/os-xml-write-test.xml";
	
	З = Новый ЗаписьXML;
	З.ОткрытьФайл(ВремФайл, "windows-1251");
	С = "";
	
	Попытка
		ЗаписатьСодержимое(З);
		З.Закрыть();
		
		Чтение = Новый ЧтениеТекста(ВремФайл, "windows-1251");
		С = Чтение.Прочитать();
		Чтение.Закрыть();
		
	Исключение
		УдалитьВременныйФайл(ВремФайл);
		ВызватьИсключение;
	КонецПопытки;
	
	УдалитьВременныйФайл(ВремФайл);
	НормализоватьПереводыСтрок(С);
	юТест.ПроверитьРавенство(ЭталонДокумента(), С);
	
КонецПроцедуры

Процедура ТестДолжен_ПрочитатьИзФайлаСРазнымиПереводамиСтрок() //Экспорт

	ПутьФайла = КаталогИсходников() + "/testdata/ObjectModule.txt";

	Текст = Новый ЧтениеТекста; 
	Текст.Открыть(ПутьФайла,"UTF-8");
	КоличествоСтрок = 0;
	Пока Истина Цикл
		Стр = Текст.ПрочитатьСтроку();
		Если Стр = Неопределено Тогда
			Прервать;
		КонецЕсли;
		КоличествоСтрок = КоличествоСтрок + 1;
	КонецЦикла;
	Текст.Открыть(ПутьФайла,"UTF-8");
	Стр = Текст.Прочитать();
	
	юТест.ПроверитьРавенство(6, КоличествоСтрок);
	юТест.ПроверитьРавенство(125, СтрДлина(Стр));
	
КонецПроцедуры

Функция КаталогИсходников()
	
	Файл = Новый Файл(ТекущийСценарий().Источник);
	Возврат Файл.Путь;

КонецФункции

Функция ЭталонДокумента()
	
	Текст = 
	"<?xml version=""1.0"" encoding=""windows-1251""?>
	|<Привет xmlns:тест=""http://beaversoft.ru/oscript/test"">
	|    <Сообщение>Это текст &lt;---&gt;</Сообщение>
	|</Привет>";
	
	НормализоватьПереводыСтрок(Текст);
	
	Возврат Текст;

КонецФункции

Процедура ЗаписатьСодержимое(ЗаписьXML)
	ЗаписьXML.ЗаписатьОбъявлениеXML();
	ЗаписьXML.ЗаписатьНачалоЭлемента("Привет");
	ЗаписьXML.ЗаписатьСоответствиеПространстваИмен("тест","http://beaversoft.ru/oscript/test");
	ЗаписьXML.ЗаписатьНачалоЭлемента("Сообщение");
	ЗаписьXML.ЗаписатьТекст("Это текст <--->");
	ЗаписьXML.ЗаписатьКонецЭлемента();
	ЗаписьXML.ЗаписатьКонецЭлемента();
КонецПроцедуры

Процедура УдалитьВременныйФайл(Знач ВремФайл)
	
	Ф = Новый Файл(ВремФайл);
		
	Если Ф.Существует() Тогда
		//УдалитьФайлы(Ф.ПолноеИмя);
	КонецЕсли;
	
КонецПроцедуры

Процедура НормализоватьПереводыСтрок(Строка)
	Строка = СтрЗаменить(Строка, Символы.ВК + Символы.ПС, Символы.ПС);
КонецПроцедуры
