﻿///////////////////////////////////////////////////////////////////////
//
// Тест проверки поведения некоторых глобальных функций
// 
//
///////////////////////////////////////////////////////////////////////

Перем юТест;

////////////////////////////////////////////////////////////////////
// Программный интерфейс

Функция ПолучитьСписокТестов(ЮнитТестирование) Экспорт
	
	юТест = ЮнитТестирование;
	
	ВсеТесты = Новый Массив;
	
	ВсеТесты.Добавить("ТестДолжен_ПроверитьТипБулево");
	ВсеТесты.Добавить("ТестДолжен_ПроверитьТипСтроки");
	ВсеТесты.Добавить("ТестДолжен_ПроверитьТипМассив");
	 
	ВсеТесты.Добавить("ТестДолжен_ПроверитьНеравенствоРазличныхТипов");
	
	Возврат ВсеТесты;
КонецФункции

// 
////////////////////////////////////////////////////////////////////

Процедура ТестДолжен_ПроверитьТипБулево() Экспорт
	юТест.ПроверитьРавенство(Тип("Булево"), ТипЗнч(Истина), "Проверка для Истина");
	юТест.ПроверитьРавенство(Тип("Булево"), ТипЗнч(Ложь), "Проверка для Ложь");

	юТест.ПроверитьРавенство(Строка(Тип("Булево")), "Булево", "Тип(""Булево"") = ""Булево""");
	юТест.ПроверитьРавенство(Строка(ТипЗнч(Истина)), "Булево", "ТипЗнч(Истина) = ""Булево""");
	юТест.ПроверитьРавенство(Строка(ТипЗнч(Ложь)), "Булево", "ТипЗнч(Ложь) = ""Булево""");
КонецПроцедуры

Процедура ТестДолжен_ПроверитьТипСтроки() Экспорт
	юТест.ПроверитьРавенство(Тип("Строка"), ТипЗнч(""), "Проверка для пустой строки");
	юТест.ПроверитьРавенство(Тип("Строка"), ТипЗнч("   "), "Проверка для строки из пробелов");
	юТест.ПроверитьРавенство(Тип("Строка"), ТипЗнч("цущкг"), "Проверка для заполненной строки");

	юТест.ПроверитьРавенство(Строка(Тип("Строка")), "Строка", "Тип(""Строка"") = ""Строка""");
	юТест.ПроверитьРавенство(Строка(ТипЗнч("")), "Строка", "ТипЗнч(пустая строка) = ""Строка""");
	юТест.ПроверитьРавенство(Строка(ТипЗнч("  ")), "Строка", "ТипЗнч(строка из пробелов) = ""Строка""");
	юТест.ПроверитьРавенство(Строка(ТипЗнч("Ложь")), "Строка", "ТипЗнч(заполненная строка) = ""Строка""");
КонецПроцедуры

Процедура ТестДолжен_ПроверитьТипМассив() Экспорт
	Массив = Новый Массив;
	юТест.ПроверитьРавенство(Тип("Массив"), ТипЗнч(Массив), "Массив пуст");
	
	Массив.Добавить(10);
	юТест.ПроверитьРавенство(Тип("Массив"), ТипЗнч(Массив), "Массив заполнен");
	юТест.ПроверитьРавенство(ТипЗнч(15), ТипЗнч(Массив[0]), "Элемент Массива");
	
	Массив.Удалить(0);
	юТест.ПроверитьРавенство(Тип("Массив"), ТипЗнч(Массив), "Массив очищен");

	юТест.ПроверитьРавенство(Строка(Тип("Массив")), "Массив", "Тип(""Массив"") = ""Массив""");
КонецПроцедуры

Процедура ТестДолжен_ПроверитьНеравенствоРазличныхТипов() Экспорт
	юТест.ПроверитьНеРавенство(Тип("Строка"), Тип("Булево"), "Тип(""Строка""), Тип(""Булево"")");
	юТест.ПроверитьНеРавенство(Тип("Число"), Тип("Булево"), "Тип(""Число""), Тип(""Булево"")");
	юТест.ПроверитьНеРавенство(Тип("Число"), Тип("Строка"), "Тип(""Число""), Тип(""Строка"")");
	
	юТест.ПроверитьНеРавенство(Тип("Массив"), Тип("Строка"), "Тип(""Массив""), Тип(""Строка"")");
	юТест.ПроверитьНеРавенство(Тип("Массив"), Тип("Число"), "Тип(""Массив""), Тип(""Число"")");
	юТест.ПроверитьНеРавенство(Тип("Массив"), Тип("Булево"), "Тип(""Массив""), Тип(""Булево"")");
КонецПроцедуры

