﻿///////////////////////////////////////////////////////////////////////
//
// Тест проверки работы генератора случайных чисел
// 
//
///////////////////////////////////////////////////////////////////////

Перем юТест;

////////////////////////////////////////////////////////////////////
// Программный интерфейс

Функция Версия() Экспорт
	Возврат "0.1";
КонецФункции

Функция ПолучитьСписокТестов(ЮнитТестирование) Экспорт
	
	юТест = ЮнитТестирование;
	
	ВсеТесты = Новый Массив;
	
	ВсеТесты.Добавить("ТестДолжен_СоздатьГенератор");
	ВсеТесты.Добавить("ТестДолжен_ПроверитьДоступныеГраницы");
	
	Возврат ВсеТесты;
	
КонецФункции

Процедура ТестДолжен_СоздатьГенератор() Экспорт

	Перем Г;
	
	Попытка
		
		Г = Новый ГенераторСлучайныхЧисел();
		
	Исключение
	
		юТест.ПроверитьИстину(Ложь, "Ошибка создания генератора случайных чисел!");
	
	КонецПопытки;
	
КонецПроцедуры


Процедура ТестДолжен_ПроверитьДоступныеГраницы() Экспорт

	// Заявляется работа с диапазоном [0..4294967295]
	
	Перем Г;
	
	Г = Новый ГенераторСлучайныхЧисел();
	
	Г.СлучайноеЧисло(0, 4294967295); // Проверить, что не валится с ошибкой
	
	Попытка
		
		Г.СлучайноеЧисло(-10, 4294967295);
		Г.СлучайноеЧисло(0, 4294967296);
		Г.СлучайноеЧисло(10, 5);
		
		Ошибка = Истина;
		
	Исключение
	
		Ошибка = Ложь;
	
	КонецПопытки;

	юТест.ПроверитьЛожь(Ошибка, "Ошибка проверок границ работы метода `СлучайноеЧисло()`.");
	
	КоличествоПроверок = 1000;
	Пока КоличествоПроверок > 0 Цикл
	
		Граница1 = Г.СлучайноеЧисло(0, 4294967295);
		Граница2 = Г.СлучайноеЧисло(Граница1, 4294967295);
		
		Ч = Г.СлучайноеЧисло(Граница1, Граница2);
		
		юТест.ПроверитьИстину(Ч >= Граница1, "Проверка диапазона 1");
		юТест.ПроверитьИстину(Ч <= Граница2, "Проверка диапазона 2");
	
		КоличествоПроверок = КоличествоПроверок - 1;
	
	КонецЦикла;

КонецПроцедуры
