﻿//////////////////////////////////////////////////////////////////////
// Демонстрационный скрипт создания дистрибутива
//	Copyright: EvilBeaver <ovsiankin.aa@gmail.com> 2014
//
// Выполняет следующие шаги:
//  1. Получает из Хранилища крайнюю версию конфигурации
//  2. Создает на ее основе файл "конфигурации поставщика"
//  3. Собирает дистрибутив, включающий в себя конфигурацию поставщика
//
// Во время работы сценарий использует специальный "каталог сборки" (BuildArea) в котором 
// накапливает временные файлы и сохраняет финальный результат.
// 
// В качестве входных параметров используются:
//  1. Путь к хранилищу конфигурации
//  2. Логин/Пароль доступа в хранилище в виде строки Пользователь[:Пароль]
//   (если пароля нет, то текст в квадратных скобках можно опустить)
//  3. Путь к файлу настройки дистрибутива (*.edf). Файл создается в Конфигураторе
//     в меню Конфигурация\Поставка конфигурации\Комплект поставки. 
//     О том, как его создать см. документацию 1С:Предприятия 8
//
// Путь к платформе и каталог сборки жестко прописаны в процедуре ЗадатьНачальныеНастройки
//
// DISCLAIMER:
// Этот скрипт является примером использования OneScript и не может быть использован в реальных бизнес-решениях.
// Скрипт поставляется "как есть" и вы используете его на свой страх и риск.
// Вы также несете ответственность за любые желательные и нежелательные последствия его применения.

Перем мПараметрыДоступаКБазе;
Перем мПараметрыДоступаКХранилищу;
Перем мПутьКПлатформе;
Перем мКаталогСборки;

Функция СкопироватьМассив(Источник)
	
	НовыйМассив = Новый Массив;
	Для Каждого Элемент Из Источник Цикл
		НовыйМассив.Добавить(Элемент);
	КонецЦикла;
	
	Возврат НовыйМассив;
	
КонецФункции

Функция ЗапуститьИПодождать(Параметры)

	СтрокаЗапуска = "";
	Для Каждого Параметр Из Параметры Цикл
	
		СтрокаЗапуска = СтрокаЗапуска + " " + Параметр;
	
	КонецЦикла;

	КодВозврата = 0;
	ЗапуститьПриложение(мПутьКПлатформе + СтрокаЗапуска, , Истина, КодВозврата);
	
	Возврат КодВозврата;

КонецФункции

Функция ФайлИнформации()

	Возврат мКаталогСборки + "\log.txt";

КонецФункции

Функция ПутьКВременнойБазе()
	Возврат мКаталогСборки + "\TempDB";
КонецФункции

Процедура ВывестиФайлИнформации()

	Файл = Новый Файл(ФайлИнформации());
	Если Файл.Существует() Тогда
		Чтение = Новый ЧтениеТекста(Файл.ПолноеИмя);
		Сообщение = Чтение.Прочитать();
		Сообщить(Сообщение);
		Чтение.Закрыть();
	Иначе
		Сообщить("Информации об ошибке нет");
	КонецЕсли;

КонецПроцедуры

Функция ПараметрыВременнойБазы()

	ПараметрыВремБазы = СкопироватьМассив(мПараметрыДоступаКБазе);
	ПараметрыВремБазы[1] = "/F""" + ПутьКВременнойБазе() + """";
	ПараметрыВремБазы.Удалить(2);
	
	Возврат ПараметрыВремБазы;

КонецФункции

Процедура ПолучитьВерсиюИзХранилища()

	КаталогСборки = мКаталогСборки;
	
	Файл = Новый Файл(КаталогСборки);
	Если НЕ Файл.Существует() Тогда
		СоздатьКаталог(КаталогСборки);
	ИначеЕсли Не Файл.ЭтоКаталог() Тогда
		ВызватьИсключение "Каталог сборки не является каталогом";
	КонецЕсли;
	
	ПараметрыПолучитьВерсию = СкопироватьМассив(мПараметрыДоступаКХранилищу);
	ПараметрыПолучитьВерсию.Добавить("/ConfigurationRepositoryDumpCfg """+КаталогСборки+"\source.cf""");

	Сообщить("Получение версии из хранилища");
	КодВозврата = ЗапуститьИПодождать(ПараметрыПолучитьВерсию);
	Если КодВозврата = 0 Тогда
		Сообщить("Версия получена");
	Иначе
		Сообщить("Не удалось получить версию из хранилища:");
		ВывестиФайлИнформации();
		ЗавершитьРаботу(1);
	КонецЕсли;
	
КонецПроцедуры

Процедура СоздатьВременнуюБазу()

	КаталогВременнойБазы = ПутьКВременнойБазе();
	Файл = Новый Файл(КаталогВременнойБазы);
	Если Не Файл.Существует() Тогда
		СоздатьКаталог(КаталогВременнойБазы);
	ИначеЕсли Файл.ЭтоКаталог() Тогда
		УдалитьФайлы(КаталогВременнойБазы, "*.*");
	Иначе
		ВызватьИсключение "Не удалось создать каталог временной базы TempDB";
	КонецЕсли;
	
	ПараметрыЗапуска = Новый Массив;
	ПараметрыЗапуска.Добавить("CREATEINFOBASE");
	ПараметрыЗапуска.Добавить("File="""+КаталогВременнойБазы+""";");
	ПараметрыЗапуска.Добавить("/UseTemplate""" + мКаталогСборки + "\source.cf" + """"); 
	ПараметрыЗапуска.Добавить("/Out""" + ФайлИнформации() + """");
	
	Сообщить("Создание временной базы");
	КодВозврата = ЗапуститьИПодождать(ПараметрыЗапуска);
	Если КодВозврата = 0 Тогда
		Сообщить("Временная база создана");
	Иначе
		Сообщить("Не удалось создать временную базу:");
		ВывестиФайлИнформации();
		ЗавершитьРаботу(1);
	КонецЕсли;

КонецПроцедуры

Процедура СоздатьФайлПоставки()

	ПараметрыВремБазы = ПараметрыВременнойБазы();
	
	ПараметрыВремБазы.Добавить("/CreateDistributionFiles -cffile """ + мКаталогСборки + "\1cv8.cf" + """");

	Сообщить("Создание файла поставки");
	Если ЗапуститьИПодождать(ПараметрыВремБазы) = 0 Тогда
		Сообщить("Файл поставки создан");
	Иначе
		Сообщить("Не удалось создать файл поставки:");
		ВывестиФайлИнформации();
		ЗавершитьРаботу(1);
	КонецЕсли;

КонецПроцедуры

Процедура СоздатьДистрибутив()

	КаталогСборки = мКаталогСборки + "\setup";
	Файл = Новый Файл(КаталогСборки);
	Если Не Файл.Существует() Тогда
		СоздатьКаталог(КаталогСборки);
	ИначеЕсли Файл.ЭтоКаталог() Тогда
		УдалитьФайлы(КаталогСборки, "*.*");
	Иначе
		ВызватьИсключение "Не удалось создать каталог сборки";
	КонецЕсли;
	
	// Сюда должен быть передан путь к файлу настройки дистрибутива, например:
	// "С:\Users\Андрей\Documents\install.edf";
	
	ФайлПараметров = АргументыКоманднойСтроки[2];
	
	ПараметрыВремБазы = ПараметрыВременнойБазы();
	ПараметрыВремБазы.Добавить("/CreateDistributive """ + КаталогСборки + """"); 
	ПараметрыВремБазы.Добавить("-File """ + ФайлПараметров + """");
	ПараметрыВремБазы.Добавить("-MakeSetup");

	Сообщить("Создание дистрибутива");
	Если ЗапуститьИПодождать(ПараметрыВремБазы) = 0 Тогда
		Сообщить("Дистрибутив создан");
	Иначе
		Сообщить("Не удалось создать дистрибутив:");
		ВывестиФайлИнформации();
		ЗавершитьРаботу(1);
	КонецЕсли;

КонецПроцедуры

Функция ОпределитьПараметрыВходаВХранилище(Знач СтрокаПараметров)
	
	ПараметрыВхода = Новый Структура;
	
	ПозицияРазделителя = Найти(СтрокаПараметров,":");
	
	Если ПозицияРазделителя > 0 Тогда
		ПараметрыВхода.Вставить("Пользователь", Лев(СтрокаПараметров, ПозицияРазделителя-1));
		ПараметрыВхода.Вставить("Пароль", Сред(СтрокаПараметров, ПозицияРазделителя+1));
	Иначе
		ПараметрыВхода.Вставить("Пользователь", СтрокаПараметров);
		ПараметрыВхода.Вставить("Пароль", "");
	КонецЕсли;
	
	Возврат ПараметрыВхода;
	
КонецФункции

Процедура ЗадатьНачальныеНастройки()

	Если АргументыКоманднойСтроки.Количество() <> 3 Тогда
		Сообщить("Не заданы аргументы командной строки");
		Сообщить("Требуется задать:");
		Сообщить("<КаталогХранилища> <ПользовательХранилища[:ПарольХранилища]> <ПараметрыДистрибутива>");
		ЗавершитьРаботу(1);
	КонецЕсли;
	
	мПутьКПлатформе = """C:\Program Files (x86)\1cv82\8.2.19.102\bin\1cv8.exe""";
	мКаталогСборки = "c:\Users\Андрей\Documents\1C\BuildArea";
	
	КаталогИБ = ПутьКВременнойБазе();
	Хранилище = АргументыКоманднойСтроки[0];
	ВходВХранилище = ОпределитьПараметрыВходаВХранилище(АргументыКоманднойСтроки[1]);
	
	мПараметрыДоступаКБазе = Новый Массив;
	мПараметрыДоступаКБазе.Добавить("DESIGNER");
	мПараметрыДоступаКБазе.Добавить("/F""" + КаталогИБ + """");
	мПараметрыДоступаКБазе.Добавить("/Out""" + ФайлИнформации() + """");
	
	мПараметрыДоступаКХранилищу = СкопироватьМассив(мПараметрыДоступаКБазе);
	мПараметрыДоступаКХранилищу.Добавить("/ConfigurationRepositoryF """+Хранилище+"""");
	мПараметрыДоступаКХранилищу.Добавить("/ConfigurationRepositoryN """ + ВходВХранилище.Пользователь + """");
	Если Не ПустаяСтрока(ВходВХранилище.Пароль) Тогда
		мПараметрыДоступаКХранилищу.Добавить("/ConfigurationRepositoryP """ + ВходВХранилище.Пароль + """");
	КонецЕсли;
	мПараметрыДоступаКХранилищу.Добавить("/DisableStartupDialogs /DisableStartupMessages");
	
КонецПроцедуры

ЗадатьНачальныеНастройки();
СоздатьВременнуюБазу();
ПолучитьВерсиюИзХранилища();
СоздатьФайлПоставки();
СоздатьДистрибутив();
Сообщить("Работа завершена");

