//  HTMLTokenizerState.h
//
//  Public domain. https://github.com/nolanw/HTMLReader

/**
    The many states of an HTML tokenizer.
 
    For more information, see http://www.whatwg.org/specs/web-apps/current-work/multipage/tokenization.html
 */
typedef NS_ENUM(NSInteger, HTMLTokenizerState)
{
    HTMLDataTokenizerState,
    HTMLCharacterReferenceInDataTokenizerState,
    HTMLRCDATATokenizerState,
    HTMLCharacterReferenceInRCDATATokenizerState,
    HTMLRAWTEXTTokenizerState,
    HTMLScriptDataTokenizerState,
    HTMLPLAINTEXTTokenizerState,
    HTMLTagOpenTokenizerState,
    HTMLEndTagOpenTokenizerState,
    HTMLTagNameTokenizerState,
    HTMLRCDATALessThanSignTokenizerState,
    HTMLRCDATAEndTagOpenTokenizerState,
    HTMLRCDATAEndTagNameTokenizerState,
    HTMLRAWTEXTLessThanSignTokenizerState,
    HTMLRAWTEXTEndTagOpenTokenizerState,
    HTMLRAWTEXTEndTagNameTokenizerState,
    HTMLScriptDataLessThanSignTokenizerState,
    HTMLScriptDataEndTagOpenTokenizerState,
    HTMLScriptDataEndTagNameTokenizerState,
    HTMLScriptDataEscapeStartTokenizerState,
    HTMLScriptDataEscapeStartDashTokenizerState,
    HTMLScriptDataEscapedTokenizerState,
    HTMLScriptDataEscapedDashTokenizerState,
    HTMLScriptDataEscapedDashDashTokenizerState,
    HTMLScriptDataEscapedLessThanSignTokenizerState,
    HTMLScriptDataEscapedEndTagOpenTokenizerState,
    HTMLScriptDataEscapedEndTagNameTokenizerState,
    HTMLScriptDataDoubleEscapeStartTokenizerState,
    HTMLScriptDataDoubleEscapedTokenizerState,
    HTMLScriptDataDoubleEscapedDashTokenizerState,
    HTMLScriptDataDoubleEscapedDashDashTokenizerState,
    HTMLScriptDataDoubleEscapedLessThanSignTokenizerState,
    HTMLScriptDataDoubleEscapeEndTokenizerState,
    HTMLBeforeAttributeNameTokenizerState,
    HTMLAttributeNameTokenizerState,
    HTMLAfterAttributeNameTokenizerState,
    HTMLBeforeAttributeValueTokenizerState,
    HTMLAttributeValueDoubleQuotedTokenizerState,
    HTMLAttributeValueSingleQuotedTokenizerState,
    HTMLAttributeValueUnquotedTokenizerState,
    HTMLCharacterReferenceInAttributeValueTokenizerState,
    HTMLAfterAttributeValueQuotedTokenizerState,
    HTMLSelfClosingStartTagTokenizerState,
    HTMLBogusCommentTokenizerState,
    HTMLMarkupDeclarationOpenTokenizerState,
    HTMLCommentStartTokenizerState,
    HTMLCommentStartDashTokenizerState,
    HTMLCommentTokenizerState,
    HTMLCommentEndDashTokenizerState,
    HTMLCommentEndTokenizerState,
    HTMLCommentEndBangTokenizerState,
    HTMLDOCTYPETokenizerState,
    HTMLBeforeDOCTYPENameTokenizerState,
    HTMLDOCTYPENameTokenizerState,
    HTMLAfterDOCTYPENameTokenizerState,
    HTMLAfterDOCTYPEPublicKeywordTokenizerState,
    HTMLBeforeDOCTYPEPublicIdentifierTokenizerState,
    HTMLDOCTYPEPublicIdentifierDoubleQuotedTokenizerState,
    HTMLDOCTYPEPublicIdentifierSingleQuotedTokenizerState,
    HTMLAfterDOCTYPEPublicIdentifierTokenizerState,
    HTMLBetweenDOCTYPEPublicAndSystemIdentifiersTokenizerState,
    HTMLAfterDOCTYPESystemKeywordTokenizerState,
    HTMLBeforeDOCTYPESystemIdentifierTokenizerState,
    HTMLDOCTYPESystemIdentifierDoubleQuotedTokenizerState,
    HTMLDOCTYPESystemIdentifierSingleQuotedTokenizerState,
    HTMLAfterDOCTYPESystemIdentifierTokenizerState,
    HTMLBogusDOCTYPETokenizerState,
    HTMLCDATASectionTokenizerState,
};
