import json

from coreapi.codecs.base import BaseCodec
from coreapi.compat import force_bytes
from coreapi.document import Document
from coreapi.exceptions import ParseError
from openapi_codec.encode import generate_swagger_object
from openapi_codec.decode import _parse_document


__version__ = '1.2.1'


class OpenAPICodec(BaseCodec):
    media_type = 'application/openapi+json'
    format = 'openapi'

    def decode(self, bytes, **options):
        """
        Takes a bytestring and returns a document.
        """
        try:
            data = json.loads(bytes.decode('utf-8'))
        except ValueError as exc:
            raise ParseError('Malformed JSON. %s' % exc)

        base_url = options.get('base_url')
        doc = _parse_document(data, base_url)
        if not isinstance(doc, Document):
            raise ParseError('Top level node must be a document.')

        return doc

    def encode(self, document, **options):
        if not isinstance(document, Document):
            raise TypeError('Expected a `coreapi.Document` instance')
        data = generate_swagger_object(document)
        return force_bytes(json.dumps(data))
