/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.supermap.DBOpenHelp;
import com.supermap.RequestControl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImgDatabase {
    private DBOpenHelp dbOpenHelper;
    private SQLiteDatabase db;

    public ImgDatabase(Context context) {
        this.dbOpenHelper = new DBOpenHelp(context, String.valueOf(RequestControl.dir) + RequestControl.dbName);
        this.db = this.dbOpenHelper.getWritableDatabase();
    }

    public void saveByte(String x, String y, String z, byte[] data) {
        String key = String.valueOf(x) + "_" + y + "_" + z;
        String sql = "insert into tiles (tile_column,tile_row,zoom_level,tile_data) values (?,?,?,?);";
        Object[] args = new Object[]{x, y, z, data};
        try {
            this.db.execSQL(sql, args);
            RequestControl.keyMap.put(key, 1);
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public byte[] queryByte(String x, String y, String z) {
        byte[] imgdata = null;
        try {
            JSONObject config = RequestControl.metaconfig;
            Boolean compatible = config.getBoolean("compatible");
            if (compatible.booleanValue()) {
                int y1 = (1 << Integer.parseInt(z)) - Integer.parseInt(y) - 1;
                y = String.valueOf(y1);
            }
            JSONArray res = config.getJSONArray("resolutions");
            String resolution = res.getString(Integer.parseInt(z));
            String sql = "select tile_data from tiles where tile_column=? and tile_row=? and resolution>?-0.0000001 and resolution<?+0.0000001";
            Cursor cursor = this.db.rawQuery(sql, new String[]{x, y, resolution, resolution});
            if (cursor.moveToFirst()) {
                imgdata = cursor.getBlob(0);
            }
            cursor.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return imgdata;
    }

    public void queryImg(String x, String y, String z) {
        byte[] imgdata = this.queryByte(x, y, z);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        Bitmap map = BitmapFactory.decodeByteArray((byte[])imgdata, (int)0, (int)imgdata.length);
    }

    public String queryImgBase64(String x, String y, String z) {
        String dataStr = "null";
        byte[] imgdata = this.queryByte(x, y, z);
        if (imgdata != null) {
            dataStr = Base64.encodeToString((byte[])imgdata, (int)0);
            dataStr = dataStr.replaceAll("\n", "");
        }
        return dataStr;
    }

    public boolean isExist(String x, String y, String z) {
        boolean isExist = false;
        int y1 = (1 << Integer.parseInt(z)) - Integer.parseInt(y) - 1;
        y = String.valueOf(y1);
        System.out.println("isExist:x=" + x + ",y=" + y + ",z=" + z);
        String sql = "select count(*) from tiles where tile_column=? and tile_row=? and zoom_level=?";
        Cursor cursor = this.db.rawQuery(sql, new String[]{x, y, z});
        cursor.moveToFirst();
        int count = cursor.getInt(0);
        if (count > 0) {
            isExist = true;
        }
        return isExist;
    }

    public String saveMap(Bitmap map, String x, String y, String z) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        map.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)baos);
        byte[] imgdata = baos.toByteArray();
        this.saveByte(x, y, z, imgdata);
        String dataStr = Base64.encodeToString((byte[])imgdata, (int)0);
        dataStr = dataStr.replaceAll("\n", "");
        return dataStr;
    }

    public void close() {
        this.dbOpenHelper.close();
    }

    public static void main(String[] args) {
    }
}

