# DroneKit-python (formerly DroneAPI-python)

[![Windows Build status](https://img.shields.io/appveyor/ci/3drobotics/dronekit-python.svg?label=windows)](https://ci.appveyor.com/project/3drobotics/dronekit-python/branch/master)
[![OS X Build Status](https://img.shields.io/travis/dronekit/dronekit-python.svg?label=os%20x)](https://travis-ci.org/dronekit/dronekit-python)
[![Linux Build Status](https://img.shields.io/circleci/project/dronekit/dronekit-python.svg?label=linux)](https://circleci.com/gh/dronekit/dronekit-python)

[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/dronekit/dronekit-python?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

This package contains the python language bindings for the drone API and the associated MAVProxy module.

## Users wanted!

We'd love your [feedback and suggestions](https://github.com/dronekit/dronekit-python/issues) about this API and are eager to evolve it to meet your needs.

For documentation on how to use this API please see:

* The new DroneKit-python [website](http://python.dronekit.io/)
* Our [tutorial](http://dev.ardupilot.com/wiki/droneapi-tutorial/) on the ardupilot wiki
* The [overview document](https://docs.google.com/document/d/1ihKneLwA4hXmKS1W2pbG9lty_EAwbmy0giusUwQ8dto)
* The [python autodocs](http://python.dronekit.io/automodule.html)
* The [python code](droneapi/lib/__init__.py) itself
* Answers to [technical support queries](http://stackoverflow.com/questions/tagged/dronekit-python) on Stack Overflow.
* Example code can be found here: ['examples/'](examples/)
    * Beginner ['vehicle_state'](examples/vehicle_state/vehicle_state.py)
    * Beginner ['simple_goto'](examples/simple_goto/simple_goto.py)
    * Beginner ['flight_replay'](examples/flight_replay/flight_replay.py)
    * Beginner ['gcs'](examples/gcs/microgcs.py)
    * Advanced ['drone_delivery'](examples/drone_delivery/)
    * Advanced ['follow-me'](examples/follow_me/)

[Stack Overflow](http://stackoverflow.com/questions/tagged/dronekit-python) is the best place to ask for *technical support* on how to use the API.

Copyright 2014 3D Robotics, Inc. - Licensed under the Apache 2.0 License.
