**TCPのタイムサーバ**を書いてください！

サーバは最初の引数で供給されているポートをリッスンするサーバです。それぞれのコネクションに今の日付と時間24時間表記）を返してください。

```
"YYYY-MM-DD hh:mm"
```

その後は改行です。月、日、時間や分は２桁にゼロパディング(※)してください。例：

```
"2013-07-06 17:42"
```

※ ゼロパディング：足りない桁を0で埋める事。例えば `1` を2桁にする場合は `01` となります。

----------------------------------------------------------------------
## ヒント

この例題のために生の TCP サーバを書いてください。 HTTP 専用の TCP は使っていないので Node.js の `net` モジュールが必要になります。 `net` モジュールには全ての基本的なネットワーキング機能が含まれます。

`net` にはイベントハンドラのような関数を引数に取る `net.createServer()` という関数があります。引数が関数のみでイベント名が無いのでコールバックのようですが、コールバックと違って何回も呼ばれます。それぞれの接続が確立するごとに引数に定義した関数が呼ばれます。

一般的なイベントハンドラ用関数の例：

```js
function handler (eventData) { /* ... */ }
```

`net.createServer()` もサーバのオブジェクトを返しています。特定のポートをリッスンするためは `server.listen(portNumber)` を呼んでください。

一般的な Node.js の TCP サーバはこのように記述されています：

```js
var net = require('net')
var server = net.createServer(function (socket) {
  // socket handling logic
})
server.listen(8000)
```

ポート番号としてコマンドラインの一つ目の引数を使いましょう。忘れないでください！

`socket` と言うオブジェクトに色々な meta のデータが含まれます。ただ、その `socket` は読み書きもできます。 読み書きStream は`duplex Stream` と言われています。今回の問題はデータを送信して接続を閉じるだけです。

`socket.write(data)` を使ってデータが送り出せます。`socket.end()` はその Socket (接続)を閉じます。`.end()` は任意で引数を一つ取ることができます。その引数は `.write` と同じく data ですので、`socket.end(data)` などとするとコードが簡単なると思います。 

`net` モジュールのドキュメントはブラウザーでこのリンクを見てください:

  {rootdir:/node_apidoc/net.html}

問題に書いてあった通り `new Date()` の日付を整形する必要があります。`date` には色々な役に立つ関数があります：

```js
date.getFullYear()
date.getMonth()     // 0からスタートしています
date.getDate()      // 月の日
date.getHours()
date.getMinutes()
```

また、 `strftime` というnpmパッケージには、 Unix の `date` 関数と同じフォーマットで日付を整形可能な機能 `strftime(fmt, date)` があります。 `strftime' のドキュメントは次のURLを参照してください。：https://github.com/samsonjs/strftime

----------------------------------------------------------------------
