
撰寫一個程式，使用 **同步（Synchronous）** 操作方式的檔案系統 API。這個程式要開啟指定檔案，然後讀取並計算該檔案內容的行數，最後利用 console （標準輸出 stdout）方法將計算結果輸出到終端機命令列，輸出的結果就像是使用下列終端機命令一樣：

```
cat 檔案路徑 | wc -l
```

程式的第一個命令列參數將是檔案的完整路徑。

----------------------------------------------------------------------
## 提示

為了進行檔案系統（filesystem）的操作，你必須使用 Node.js 內建的 `fs` 核心模組。要載入此核心模祖，或任何全域（Global）的模組，您可以使用以下的語法：

```js
var fs = require('fs')
```
現在，您可以透過變數 `fs` 以使用 `fs` 模組的完整功能。因為 `fs` 模組已經被載入，並存放在名為 `fs` 的變數中。

fs 模組裡所有同步（ synchronous ，或稱為阻塞， blocking ）的功能都會以「Sync」結尾。您需要使用 `fs.readFileSync('檔案路徑')` 這個 API 去讀取一個檔案。這個 API 將會 *返回* 一個包含完整檔案內容的 `Buffer` 物件。

要閱讀並參考 `fs` 模組的說明文件，可以在瀏覽器中打開這個頁面：

  {rootdir:/node_apidoc/fs.html}

任何的大量資料，無論編碼是 ASCII、二位元或其他的格式， Node.js 都可以用 `Buffer` 物件有效地儲存和操作。使用 `Buffer` 本身的 `toString()` 方法，就可以簡單的把 `Buffer` 物件的內容轉換成可見字串（String）。如 `var str = buf.toString()` 。


要閱讀並參考關於 Buffer 物件的文件，可以在瀏覽器中打開這個頁面：
  {rootdir:/node_apidoc/buffer.html}

如果您正在尋找計算字串中換行符號的數目的方法，最簡單的做法是計算換行符號。請記得 Javascript 中是使用「\n」表示換行符號，所以你可以用 `String` 的 `.split()` 方法，對字串所有的換行符號處進行切割，並生成一個多字串組成的陣列（Array），然後由 Array 的大小得知行數 。注意，測試檔案的最後一行不會以換行符號「\n」結尾，所以使用這個方法得到的 Array 元素數目（也就是行數）將會比換行符號多一個。

注：終端機命令 `wc -l` 是計算換行符號的數量，並非是真實內容行數。

----------------------------------------------------------------------
