**同期** ファイルシステムの関数を使ってファイルの改行数を出すアプリを書いてください。`cat file | wc -l`と同じようなアプリです。

アプリの一つ目のコマンドライン引数はそのファイルのパスです。

----------------------------------------------------------------------
## ヒント

ファイルシステムにアクセスするためにはNodeのコアライブラリーの `fs`モジュールが必要となります。モジュールをロードするには以下のようにします:

```js
var fs = require('fs')
```

その後は `fs` という変数で `fs` というモジュールを利用出来ます。

同期(ブロッキング)ファイルシステム関数の名前には後ろに全て `Sync` がついています。  ファイルを読むためには `fs.readFileSync('/あなた/の/ファイル')` を使ってください. この関数は `Buffer` オブジェクトを返します。その`Buffer` を使って全てのファイルコンテンツにアクセスできます。

`fs` モジュールのドキュメントはブラウザーでこのリンクを見てください:
  {rootdir:/node_apidoc/fs.html}

`Buffer` オブジェクトは、ASCIIやバイナリ、その他のフォーマットを扱う際の Nodeの効率的な方法です。エンコーディングは関係ありません。`Buffer` のオブジェクトは `toString()` をつかってStringに変換できます。 例えば `var str = buf.toString()`.

`Buffer` モジュールのドキュメントはブラウザーでこのリンクを見てください:
  {rootdir:/node_apidoc/buffer.html}

改行を数える簡単な方法が探しているのなら、このヒントは役に立つでしょう：  
JavaScriptの `String` は `.split()` 関数を使って 文字列 を分割出来ます。`\n` を区切り文字として使えば全てのラインが入った Array を受け取ることが出来ます。ただし、ファイルの最後の改行には気をつけてください。

----------------------------------------------------------------------
