一つ目のコマンドラインの引数が URL 文字列である、 HTTP のデーターをロード (※)するアプリを書いてください。`"data"` イベント**一つ一つ**の文字列を改行をつかってコンソールに書き出してください。

※これからは「GET リクエスト」と記述します。

----------------------------------------------------------------------
## ヒント

この例題のために `http` の Node.js モジュールが必要になります。

`http` モジュールのドキュメントはブラウザーでこのリンクを見てください:
  {rootdir:/node_apidoc/http.html}

`http.get()` という関数は簡単な GET リクエストのショートカットです。解決方法をシンプルするのに役に立つと思います。 `http.get()` の一つ目の引数は GET リクエストの URL です。二つ目はコールバック関数です。

```js
http.get(url, callback)
```

`http` はよくあるイディオム  `(error, result)` と違って以下のようなコールバックになります：

```js
function callback (response) { /* ... */ }
```

`response` のオブジェクトは Node.js の **Stream** です。Stream はイベントを発行するオブジェクトと考えてよいです。 Stream における大切な三つのイベントは： `data` 、 `error` と `end` です。各イベント時にデータを受け取る為には、以下のようにリスナーを設定します。

```js
response.on("data", function (data) { /* ... */ })
```

`data` イベントは処理できるデータチャンク(※)が現れた時に発行されます。チャンクのサイズはデータの出元によって変わります。
※ データの一部分。Stream ではこれが断続的に提供されます。

`http.get()` の `response` の Stream オブジェクトには `setEncoding()` という関数があります。それを `utf8` という値を使って呼ぶとデータイベントの `Buffer` の代わりに文字列が渡ってきます。

----------------------------------------------------------------------
