#!/usr/bin/env bash

# Customization parameters.
RUBY_VERSION=2.1
RVM_PATH=/usr/local/rvm
GEMS=bundler

# Get information about the newest versions of Ubuntu packages.
sudo apt-get update

# Install Ubuntu packages.
sudo apt-get install nodejs git -y

# Install Ruby.
if [ ! -e $RVM_PATH ]; then
	gpg --keyserver hkp://keys.gnupg.net --recv-keys 409B6B1796C275462A1703113804BB82D39DC0E3
	curl -sSL https://get.rvm.io | bash -s
fi

source $RVM_PATH/scripts/rvm

rvm use --install $RUBY_VERSION --default

# Install ruby gems specified in Customization parameters on top of this file.
gem install $GEMS

# Clean up Ubuntu system after software installation.
sudo apt-get autoremove -y

# Clone the 'devdocs' repo from GitHub in a shared directory.
cd /vagrant/
git clone https://github.com/magento/devdocs.git

# Install gems and dependencies from 'devdocs/Gemfile'
cd devdocs/
bundle install

# Run Jekyll to generate the devdocs site

bundle exec jekyll serve --host=0.0.0.0