---
layout: default
group: pattern
subgroup: 
title: Admin Design Pattern Library
menu_title: Introduction
menu_order: 
menu_node: 
version: 2.0
github_link: pattern-library/bk-pattern.md
redirect_from: /guides/v1.0/pattern-library/bk-pattern.html
---
<h3>What is a design pattern?</h3>
 
Design patterns can be simple elements or complex pieces of functionality - like buttons, scroll bars, data tables and forms - that are standardized to be easily repeated and reused across a website or application.

Patterns include definitions, examples, instructions and specifications that break down spacial relationships and interactions / behaviors. 
 
<h3>Why use patterns?</h3>
 
Using patterns enhances customer experience through maintaining consistency and ease of use. And, sticking to defined standards simplifies updating patterns across multiple pages when changes are required.

Patterns libraries are designed to evolve over time, never going out of date. Changes should be communicated, as they occur, to the design community.

<br> <br>
Find more details about the Admin Design Pattern Library in the following topic:

####Container
<a href="containers/staticContentContainer/contentContainer.html">Static Content Container</a><br>
<a href="containers/slideouts-modals-overlays/slideouts-modals-overalys.html">Slide-out Panels, Modal Windows, and Overlays</a><br>
<a href="containers/tabs/tabs.html">Tabs</a><br>

####Controls
<a href="controls/buttons/buttons.html">Buttons</a><br>
<a href="controls/button-bar/button-bar.html">Button Bar</a>

####Displaying and Dealing with Data
<a href="displaying-data/tile/tile.html">Tile</a><br>
<a href="filters/data-table-filters/filtering.html">Filters</a><br>
<a href="displaying-data/datatable/datatable.html">Data Table</a><br>
<a href="displaying-data/tree/tree.html">Tree</a><br>


####Feedback to User
<a href="feedbackToUser/progressIndicator/progressIndicator.html">Progress Indicator</a>


####Getting User Input
<a href="getting-user-input/form_elements/form_elements.html">Form Elements</a><br>
<a href="getting-user-input/image_uploader/image_uploader.html">Image Uploader</a><br>
<a href="getting-user-input/date_time_selector/date_time_selector.html">Date and Time Selector</a>
<a href="getting-user-input/use_default_config/use_default_config.html">Use Default Config</a><br>
<a href="getting-user-input/select_from_list/select_from_list.html">Select From List</a>


####Navigation
<a href="navigation/links/links.html">Links</a><br>
<a href="navigation/wizard/wizard.html">Wizard</a><br>


####Templates
<a href="templates/address-form/address-form.html">Address Form</a><br>
<a href="templates/sign-in-form/sign-in-form.html">Sign In Form</a><br>


####General
<a href="general/accessibilityguideline/accessibilityGuideline.html">Accessibility Guidelines</a><br>





