---
layout: default
group: howdoi
subgroup: checkout
title: Customize Checkout
menu_title: Customize Checkout
menu_node: parent
menu_order: 1
version: 2.0
github_link: howdoi/checkout/checkout_overview.md
---

Magento checkout is implemented using the UI components. 
Out of the box, the checkout consists of two steps:
 
 - Shipping Information
 - Review and Payment Information


You can customize the default checkout in many ways. Here the following customizations are described:

 - [Add a new checkout step]({{site.gdeurl}}howdoi/checkout/checkout_new_step.html)
 - [Customize the view of an existing step]({{site.gdeurl}}howdoi/checkout/checkout_new_step.html)
 - [Add a custom payment method to checkout]({{site.gdeurl}}howdoi/checkout/checkout_payment.html)
 - [Add custom validations before order placement]({{site.gdeurl}}howdoi/checkout/checkout_order.html)
 - [Add custom shipping carrier validations]({{site.gdeurl}}howdoi/checkout/checkout_carrier.html)
 - [Add custom input mask for ZIP code]({{site.gdeurl}}howdoi/checkout/checkout_zip.html)
 - [Add a custom template for a form field on Checkout page]({{site.gdeurl}}howdoi/checkout/checkout_edit_form.html)
 - [Add custom shipping address renderer]({{site.gdeurl}}howdoi/checkout/checkout_address.html)

For the sake of compatibility, upgradability, and easy maintenance, do not edit the default Magento code, add your customizations in a custom module. 

