---
layout: default
group: fedg
title: Frontend Developer Guide
menu_title: Introduction
menu_order: 1
version: 2.0
github_link: frontend-dev-guide/bk-frontend-dev-guide.md
redirect_from: /guides/v1.0/frontend-dev-guide/bk-frontend-dev-guide.html
---

<h2 id="overview-introduction">Introduction</h2>
This document provides instructions for creating and installing custom storefront themes for a Magento application. It describes Magento's content rendering process and explains the view layer of the system to the extent required to build a theme efficiently. The document also walks through everyday frontend developer's tasks.

Developing the view part of a custom module and customizing the Magento Admin panel design is out of the scope of this guide.

Frontend developers can use this guide to create custom themes to tailor the Magento storefront for a specific customer.

<p>You can apply these levels of customization to your site, where the levels require different development skills:</p>
<ul>
<li><p>You can make relatively simple changes to your site using cascading style sheets (CSS) to change colors and the look-and-feel of various interface components, replacing images, and other relatively cosmetic changes.</p>
<p>No structural changes are made to pages&mdash;you accept the structure of the site provided by default by modules you load on to your site.</p>
<p>This can be a good starting point for a site as it is requires the least effort and knowledge.</p></li>
<li><p>A small step beyond changing CSS and images on your site is to make changes to the HTML generated by existing modules.</p>
<p>This requires rudimentary PHP skills to adjust PHTML template files.</p>
<p>Although PHP coding is involved, this is typically copying and pasting small fragments of PHP code from existing template files into a new template file with differently structured HTML.</p>
<p>This can be useful if the existing HTML generated does not have sufficient CSS class names or HTML elements to achieve the presentation change you would like to achieve.</p></li>
<li><p>The next level of sophistication is to make structural changes to your site by moving functionality between places on a page or to completely different pages.</p>
<p>This is achieved using the Magento layout engine.  No PHP coding is required to make layout changes, but the layout engine is moderately sophisticated.</p></li>
<li><p>Finally, you can develop new modules to add new custom functionality to your site or to extend functionality provided by existing Magento or third party modules.</p>
<p>This third level of customization is not addressed in this guide.</p>
<p>See the Developers' Guide for details on how to develop new modules.</p>
<p>This requires PHP programming knowledge in addition to knowledge of all of the preceding areas.</p></li>
</ul>

<div class="bs-callout bs-callout-info" id="info">
<p>There have been some inquiries about the status of the Visual Design Editor (VDE), which is currently part of the Magento development code base. The VDE enables assigning and unassigning themes, editing theme CSS and JS files, changing page layouts, and managing blocks and their positions on pages in a WYSIWYG mode. We'd like to clarify that to meet higher priority objectives, the VDE will <em>not</em> be part of the initial Magento release. Future plans for the VDE will be communicated at a later point in time. You are welcome to continue to provide input on the VDE, but please note that we will not be actively reviewing or actioning these comments in the near term.</p>
</div>

<h2 id="fedg-prereqs">Frontend development prerequisites</h2>

To implement what is discussed in this guide, you need a working Magento installation and the following browser versions installed on your device:

{% include browsers/supported-browsers.md %}

To use this guide, you must be familiar with:

*	CSS and CSS 3
*	HTML and HTML 5
*	XML
*	JavaScript
*	Responsive Web Design (RWD)

#### Related topics:

*	<a href="{{ site.gdeurl }}frontend-dev-guide/themes/theme-general.html">Themes</a>
*	<a href="{{ site.gdeurl }}frontend-dev-guide/css-topics/theme-ui-lib.html">Magento UI library</a>
*	<a href="{{ site.gdeurl }}frontend-dev-guide/css-topics/css-overview.html">Cascading style sheets (CSS) </a>
*	<a href="{{ site.gdeurl }}coding-standards/code-standard-javascript.html">JavaScript coding standard</a>
*	<a href="{{ site.gdeurl }}frontend-dev-guide/responsive-web-design/rwd_overview.html">Responsive web design</a>
*	<a href="{{ site.gdeurl }}architecture/behavior/xlate.html">Translation</a>

