---
layout: default
group: extension-dev-guide
subgroup: 99_Module Development
title: Component development
menu_title: Component development
menu_order: 1
menu_node: parent
version: 2.0
github_link: extension-dev-guide/module-development.md
---

##{{page.menu_title}}

Magento 2 is flexible and as a result has varied functionality, so developing a component in Magento takes into account a number of different of the following topics. Please read the information on compatibility &#8212; [Service Contracts]({{ site.gdeurl }}extension-dev-guide/service-contracts/service-contracts.html), [Design Patterns]({{ site.gdeurl }}extension-dev-guide/service-contracts/design-patterns.html), and the information on [Dependency Injection]({{ site.gdeurl }}extension-dev-guide/depend-inj.html), [Routing]({{ site.gdeurl }}extension-dev-guide/routing.html), and [Working With Public Interfaces and APIs]({{ site.gdeurl }}extension-dev-guide/api-concepts.html) closely; they are essential to creating a good Magento 2 component.



* Compatibility (backward and forward)
   * [Service contracts]({{ site.gdeurl }}extension-dev-guide/service-contracts/service-contracts.html)
   * [Design patterns]({{ site.gdeurl }}extension-dev-guide/service-contracts/design-patterns.html) 
  
* [Working with public interfaces and APIs]({{ site.gdeurl }}extension-dev-guide/api-concepts.html)
* [Object manager and dependency injection]({{ site.gdeurl }}extension-dev-guide/depend-inj.html)
* [Code generation]({{ site.gdeurl }}extension-dev-guide/code-generation.html)
* [EAV attributes]({{ site.gdeurl }}extension-dev-guide/attributes.html)
* [Plug-ins (aka interceptors)]({{ site.gdeurl }}extension-dev-guide/plugins.html)
* [Routing]({{ site.gdeurl }}extension-dev-guide/routing.html)
* [Indexing]({{ site.gdeurl }}extension-dev-guide/indexing.html)
* [Configure a service as a web API]({{ site.gdeurl }}extension-dev-guide/service-contracts/service-to-web-service.html#configure-webapi)

