---
layout: default
group: extension-dev-guide
subgroup: 03_Build
title: Build
menu_title: Build
menu_order: 1
menu_node: parent
version: 2.0
github_link: extension-dev-guide/build/build.md
redirect_from: /guides/v2.0/extension-dev-guide/build.html
---

##{{page.menu_title}}

Building your component involves laying out the file structure, creating the necessary configuration files, building out any needed API interfaces and services, and adding any frontend parts needed for your component.

<h2 id="create-component-basics">Prerequisites</h2>
Before you begin creating your new component, make sure that you have a working installation of Magento 2.0, and the Magento [System Requirements]({{ site.gdeurl }}install-gde/system-requirements.html).

Also, Magento recommends that you disable caching while setting up the component file structure and adding configuration files. 

The following details the component building process:

*	[Create composer.json]({{ site.gdeurl }}extension-dev-guide/build/composer-integration.html)
*	[Define your configuration files]({{ site.gdeurl }}extension-dev-guide/build/required-configuration-files.html)
*	[Create your component file structure]({{ site.gdeurl }}extension-dev-guide/build/module-file-structure.html)
*	[Register your component]({{ site.gdeurl }}extension-dev-guide/build/component-registration.html)
*	[URN schema validation]({{ site.gdeurl }}extension-dev-guide/build/XSD-XML-validation.html)
*	[Name your component]({{ site.gdeurl }}extension-dev-guide/build/create_component.html)
*	[Component load order]({{ site.gdeurl }}extension-dev-guide/build/module-load-order.html)
*	[Enable your component]({{ site.gdeurl }}extension-dev-guide/build/enable-module.html)

