---
layout: default
group: contributor
subgroup: Contributor Guide

version: 2.0
github_link: contributor-guide/contributing_docs_suggested_topics.md

---


<h2 id="suggested">Suggested topics for contribution</h2>

Below is a list of suggested topics; we would welcome contributions around these! (Or anywhere!) Most of the topics below are things we know we need in the DevDocs (but haven't had a chance to write), some are suggestions form our internal developers or suppport teams, and some are suggestions from you, our community.

We have a <a href="{{ site.gdeurl }}contributor-guide/basic_template.html" target="_blank">template</a> to make getting started easy. You can get a copy of the <a href="https://github.com/magento/devdocs/blob/2.0/guides/v2.0/contributor-guide/basic_template.md" target="_blank">.md file  on Github</a>. It's in Markdown, which is a simple markup language.

If you write and contribute a full topic, we'll put your name (or company's name) at the top of the page, right under the title, and link it to your blog or website! And you'll get your face and bio in the <a href="{{ site.gdeurl }}howdoi/howdoi_bios.html"  target="_blank">ring of honor</a> as one of our featured contributors.

We have a new section called <a href= "http://devdocs.magento.com/guides/v2.0/howdoi/bk-how-do-i.html" target="blank">How do I...?</a> which is a great place for contained, procedural topics that explain how to accomplish a very specific task. Or maybe you want to write a conceptual topic, perhaps about a design pattern or a specific use-case. Reference topics are also useful; for example, see <a href="https://github.com/magento/devdocs/issues/365" target="_blank">GitHub Issue #365</a>

*    Map out the dev to prod flow and identify the friction points with the existing CLI etc commands. Then fix a few!

*    Work out the best way to get CSS generated by Gulp/Grunt into production (not easy with current tooling flow).

*   Provide "real-life" scenarios for using Magento APIs. For example, a topic based on a scenario ("Mary has a store and wants to ...")

*   <a href="https://github.com/magento/devdocs/issues/366" target="_blank">GitHub Issue #366: Page and Block Caching</a>
 
*   <a href="https://github.com/magento/devdocs/issues/365" target="_blank">GitHub Issue #365: Source, Backend, and Frontend Models</a>
 
*    Add procedural information about using UI Components; document the workflow, coding with UI Components, retrieving data to populate the components, and using the JSON file.

*   Define one or more “business challenges” that your merchants have asked for (i.e. What things do merchants want that are do-able with product, but not immediately obvious how to do?). Even if you only define the challenge, that’s useful; maybe another community member can write up HOW to solve it.

*    Write some deeply technical conceptual topics, perhaps about design patterns or DI or best practices with the framework or migrating from M1 to M2, etc.

<!--*    Contribute to an online discussion about Best Practices for adding extensions to the Admin panel. -->


