---
layout: default
group: cloud
subgroup: 04_setup
title: First-time setup
menu_title: First-time setup
menu_order: 1
menu_node: parent
version: 2.0
github_link: cloud/access-acct/first-time-setup.md
---

![This guide applies to Enterprise Cloud Edition only]({{ site.baseurl }}common/images/ee-only_large.png) 

 
#### Contents
*	[Sign up for an account](#cloud-first-acct)
*	[Prerequisites](#cloud-first-prereq)
*	[Your welcome e-mail](#cloud-first-email)

## Sign up for an account
To sign up for a Magento Enterprise Cloud Edition account, contact [Magento Sales](https://magento.com/explore/contact-sales){:target="_blank"}. They will create your account and send you a [welcome e-mail](#cloud-first-email).

## Prerequisites {#cloud-first-prereq}
Before you get started, you must add at least one [public SSH key]({{ site.gdeurl }}cloud/before/before-workspace.html#cloud-ssh-cli-ssh) to your account and decide how to start your Magento Enterprise Cloud Edition project:

*	A Magento project you start using a reference template. You can customize this project to fit your needs. 

	Use this method if you don't already have Magento installed. For more information, see [Create a sample Magento project from a template]({{ site.gdeurl }}cloud/access-acct/first-time-setup_template.html).

*	A Magento project you import from an existing installation.

	Use this method if Magento is already installed and customized. It doesn't matter whether or not your Magento project is currently managed using a Git repo; you can create one if you don't have one. 

	For more information, see [Create a sample Magento project from a template]({{ site.gdeurl }}cloud/access-acct/first-time-setup_import.html). 

## Your welcome e-mail {#cloud-first-email}
After you register for an account, Magento sends you a welcome e-mail at the address at which you registered. The e-mail contains a link to your Magento Enterprise Cloud Edition project.

Click the link in your welcome e-mail and continue with any of the following topics:

*	[Create a sample Magento project from a template]({{ site.gdeurl }}cloud/access-acct/first-time-setup_template.html)
*	[Import an existing Magento project]({{ site.gdeurl }}cloud/access-acct/first-time-setup_import.html)
