---
layout: default
group: arch-guide
subgroup: Components
title: Magento Components 
menu_title: Components
menu_order: 
menu_node: parent


version: 2.0
github_link: architecture/archi_perspectives/components/AComponents.md
redirect_from: /guides/v1.0/architecture/components/AComponents.html
---


<h2>Magento components</h2>
Magento has several core components that are used to build custom web sites, applications, and integrated systems. When you change the appearance or behavior of your Magento store, you are inevitably changing one or more of these <b>core Magento components</b>, which include <b>modules</b>, <b>themes</b>, and <b>language packages</b>. Together, these core components determine much of server-side and storefront (frontend) appearance and behavior. 

<div class="bs-callout bs-callout-info" id="info">
  <p>Throughout the Magento documentation set, we also use the term <i>component</i> in its generic sense to mean element or part. However, the term <b>Magento component</b> explicitly refers to either a module, theme, or language package.</p>
</div>


For more information about individual Magento components, see:

<a href="{{ site.gdeurl }}architecture/archi_perspectives/components/modules/mod_intro.html">Modules</a>


<a href="{{ site.gdeurl }}architecture/archi_perspectives/components/arch_themes.html">Themes</a>

<a href="{{ site.gdeurl }}architecture/archi_perspectives/components/arch_translations.html">Language packages</a>



<h3>Related topics</h3>
<a href="{{ site.gdeurl }}architecture/archi_perspectives/LogicalView_intro.html">Logical view</a>





