---
layout: default
group: arch-guide
subgroup: Architectural Basics
title: Architectural diagrams
menu_title: Architectural diagrams
menu_order: 1
version: 2.0
github_link: architecture/archi_perspectives/arch_diagrams.md
redirect_from: /guides/v1.0/architecture/archi_perspectives/arch_diagrams.html
---

<h2 id="m2arch-whatis-overview">Architectural diagrams</h2>

Depending upon your role and purpose for learning more about Magento, there are several different ways to view the Magento architecture. For example, a developer who wants to create new modules or perhaps customize an existing module will want to understand the architecture of a module itself, and how it fits into the larger view, with the Magento framework and other components. However, a merchant who wants to quickly build an online store front wants to view the collection of components from a higher level, and understand the components that impact the look, feel, and user interaction components.

<h3 id="archi-layers">Architecture layers diagram</h3>

The following diagram illustrates the components of Magento, and shows the "layers" or tiers, for all components, as well as the Magento framework, 3rd party libraries, the supported database, and other technologies.

<p><img src="{{ site.baseurl }}common/images/archi_diagrams_layers_alt4.jpg" alt="Magento architecture layers"></p>

#### Related topics
* <a href="{{ site.gdeurl }}architecture/arch_asmodsys.html">Magento as a modular system</a>
* <a href="{{ site.gdeurl }}architecture/archi_perspectives/ALayers_intro.html">Architecture layers overview</a>

