<div markdown="1">

## Locate your session storage {#session-where}
This topic discusses how to locate where your session files are stored. The Magento application uses the following logic to store session files:

*	If you configured memcached, sessions are stored in RAM; for more information, see [Use memcached for session storage]({{ site.gdeurl }}config-guide/memcache/memcache.html).
*	If you're using the default file-based session storage, we store sessions in the following locations in the order shown:

	1.	Directory defined in [`env.php`](#session-where-env)
	2.	Directory defined in [`php.ini`](#session-where-phpini)
	3.	`<your Magento install dir>/var/session` directory

### `env.php` example {#session-where-env}
A sample snippet from `<your Magento install dir>/app/etc/env.php` follows:

	'session' =>
	   array (
	     'save' => 'files',
	     'save_path' => '/var/www/session',
	),

The preceding example stores session files in `/var/www/session`

### `php.ini` example {#session-where-phpini}
As a user with `root` privileges, open your `php.ini` file and search for the value of `session.save_path`. This identifies where sessions are stored.

