/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.ExpectedExceptions;
import org.testng.annotations.Factory;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.DataProviderAnnotation;
import org.testng.internal.annotations.ExpectedExceptionsAnnotation;
import org.testng.internal.annotations.FactoryAnnotation;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.ParametersAnnotation;
import org.testng.internal.annotations.TestAnnotation;

public class JDK15TagFactory {
    public IAnnotation createTag(Annotation a, Class annotationClass) {
        IAnnotation result = null;
        if (a != null) {
            if (annotationClass == IConfiguration.class) {
                result = this.createConfigurationTag(a);
            } else if (annotationClass == IDataProvider.class) {
                result = this.createDataProviderTag(a);
            } else if (annotationClass == IExpectedExceptions.class) {
                result = this.createExpectedExceptionsTag(a);
            } else if (annotationClass == IFactory.class) {
                result = this.createFactoryTag(a);
            } else if (annotationClass == IParameters.class) {
                result = this.createParametersTag(a);
            } else if (annotationClass == ITest.class) {
                result = this.createTestTag(a);
            }
        }
        return result;
    }

    private IAnnotation createConfigurationTag(Annotation a) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        Configuration c = (Configuration)a;
        result.setBeforeTestClass(c.beforeTestClass());
        result.setAfterTestClass(c.afterTestClass());
        result.setBeforeTestMethod(c.beforeTestMethod());
        result.setAfterTestMethod(c.afterTestMethod());
        result.setBeforeTest(c.beforeTest());
        result.setAfterTest(c.afterTest());
        result.setBeforeSuite(c.beforeSuite());
        result.setAfterSuite(c.afterSuite());
        result.setParameters(c.parameters());
        result.setEnabled(c.enabled());
        result.setGroups(c.groups());
        result.setDependsOnGroups(c.dependsOnGroups());
        result.setDependsOnMethods(c.dependsOnMethods());
        result.setAlwaysRun(c.alwaysRun());
        result.setInheritGroups(c.inheritGroups());
        result.setDescription(c.description());
        return result;
    }

    private IAnnotation createDataProviderTag(Annotation a) {
        DataProviderAnnotation result = new DataProviderAnnotation();
        DataProvider c = (DataProvider)a;
        result.setName(c.name());
        return result;
    }

    private IAnnotation createExpectedExceptionsTag(Annotation a) {
        ExpectedExceptionsAnnotation result = new ExpectedExceptionsAnnotation();
        ExpectedExceptions c = (ExpectedExceptions)a;
        result.setValue(c.value());
        return result;
    }

    private IAnnotation createFactoryTag(Annotation a) {
        FactoryAnnotation result = new FactoryAnnotation();
        Factory c = (Factory)a;
        result.setParameters(c.parameters());
        return result;
    }

    private IAnnotation createParametersTag(Annotation a) {
        ParametersAnnotation result = new ParametersAnnotation();
        Parameters c = (Parameters)a;
        result.setValue(c.value());
        return result;
    }

    private IAnnotation createTestTag(Annotation a) {
        TestAnnotation result = new TestAnnotation();
        Test c = (Test)a;
        result.setEnabled(c.enabled());
        result.setGroups(c.groups());
        result.setParameters(c.parameters());
        result.setDependsOnGroups(c.dependsOnGroups());
        result.setDependsOnMethods(c.dependsOnMethods());
        result.setTimeOut(c.timeOut());
        result.setInvocationCount(c.invocationCount());
        result.setThreadPoolSize(c.threadPoolSize());
        result.setSuccessPercentage(c.successPercentage());
        result.setDataProvider(c.dataProvider());
        result.setAlwaysRun(c.alwaysRun());
        result.setDescription(c.description());
        return result;
    }

    private void ppp(String string) {
        System.out.println("[JDK15TagFactory] " + string);
    }
}

