/*
 * Decompiled with CFR 0.152.
 */
package processing.build;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PAppletMethods
extends Task {
    private File baseDir;

    public void setDir(String dir) {
        this.baseDir = new File(dir);
    }

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("dir parameter must be set!");
        }
        File graphicsFile = new File(this.baseDir, "PGraphics.java");
        File appletFile = new File(this.baseDir, "PApplet.java");
        File imageFile = new File(this.baseDir, "PImage.java");
        if (!graphicsFile.exists() || !graphicsFile.canRead()) {
            throw new BuildException("PGraphics file not readable: " + graphicsFile.getAbsolutePath());
        }
        if (!(appletFile.exists() && appletFile.canRead() && appletFile.canWrite())) {
            throw new BuildException("PApplet file not read/writeable: " + appletFile.getAbsolutePath());
        }
        if (!imageFile.exists() || !imageFile.canRead()) {
            throw new BuildException("PImage file not readable: " + imageFile.getAbsolutePath());
        }
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBytes);
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader applet = PAppletMethods.createReader(appletFile);
            while ((line = applet.readLine()) != null) {
                out.println(line);
                content.append(String.valueOf(line) + "\n");
                if (line.indexOf("public functions for processing.core") >= 0) break;
            }
            while ((line = applet.readLine()) != null) {
                content.append(String.valueOf(line) + "\n");
            }
            applet.close();
            this.process(out, graphicsFile);
            this.process(out, imageFile);
            out.println("}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.flush();
        if (content.toString().equals(outBytes.toString())) {
            System.out.println("No changes to PApplet");
        } else {
            System.out.println("Updating PApplet");
            try {
                PrintStream temp = new PrintStream(appletFile);
                temp.print(outBytes.toString());
                temp.flush();
                temp.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void process(PrintStream out, File input) throws IOException {
        BufferedReader in = PAppletMethods.createReader(input);
        int comments = 0;
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] parts;
            String decl = "";
            if (line.matches(Pattern.quote("/*"))) {
                ++comments;
            }
            if (line.matches(Pattern.quote("*/"))) {
                --comments;
            }
            if (comments > 0) continue;
            boolean gotSomething = false;
            boolean gotStatic = false;
            Matcher result = Pattern.compile("^\\s*public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
            if (result.matches()) {
                gotSomething = true;
            } else {
                result = Pattern.compile("^\\s*abstract public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                if (result.matches()) {
                    gotSomething = true;
                } else {
                    result = Pattern.compile("^\\s*public final ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                    if (result.matches()) {
                        gotSomething = true;
                    } else {
                        result = Pattern.compile("^\\s*static public ([\\w\\[\\]]+) [a-zA-z_]+\\(.*$").matcher(line);
                        if (result.matches()) {
                            gotSomething = true;
                            gotStatic = true;
                        }
                    }
                }
            }
            if (gotSomething && line.indexOf("// ignore") >= 0) {
                gotSomething = false;
            }
            String returns = "";
            if (!gotSomething) continue;
            returns = result.group(1).equals("void") ? "" : "return ";
            line = line.replaceFirst(Pattern.quote("abstract"), " ");
            line = line.replaceAll(Pattern.quote(";"), " {\n");
            out.println("\n\n" + line);
            decl = String.valueOf(decl) + line;
            while (line.indexOf(41) == -1) {
                line = in.readLine();
                decl = String.valueOf(decl) + line;
                line = line.replaceAll("\\;\\s*$", " {\n");
                out.println(line);
            }
            result = Pattern.compile(".*?\\s(\\S+)\\(.*?").matcher(decl);
            result.matches();
            String declName = result.group(1);
            String gline = "";
            String rline = "";
            if (gotStatic) {
                gline = "    " + returns + "PGraphics." + declName + "(";
            } else {
                rline = "    if (recorder != null) recorder." + declName + "(";
                gline = "    " + returns + "g." + declName + "(";
            }
            decl = decl.replaceAll("\\s+", " ");
            decl = decl.replaceFirst("^.*\\(", "");
            decl = decl.replaceFirst("\\).*$", "");
            boolean prev = false;
            String[] stringArray = parts = decl.split("\\, ");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!part.trim().equals("")) {
                    String[] blargh = part.split(" ");
                    String theArg = blargh[1].replaceAll("[\\[\\]]", "");
                    if (prev) {
                        gline = String.valueOf(gline) + ", ";
                        rline = String.valueOf(rline) + ", ";
                    }
                    gline = String.valueOf(gline) + theArg;
                    rline = String.valueOf(rline) + theArg;
                    prev = true;
                }
                ++n2;
            }
            gline = String.valueOf(gline) + ");";
            rline = String.valueOf(rline) + ");";
            if (!gotStatic && returns.equals("")) {
                out.println(rline);
            }
            out.println(gline);
            out.println("  }");
        }
        in.close();
    }

    private static BufferedReader createReader(File f) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(f)));
    }
}

