/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import ch.randelshofer.quaqua.colorchooser.ColorWheel;
import ch.randelshofer.quaqua.colorchooser.HSBColorSliderModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class ColorWheelChooser
extends AbstractColorChooserPanel
implements UIResource {
    private ColorWheel colorWheel;
    private HSBColorSliderModel ccModel = new HSBColorSliderModel();
    private int updatingChooser;
    private JSlider brightnessSlider;

    public ColorWheelChooser() {
        this.initComponents();
        int textSliderGap = UIManager.getInt("ColorChooser.textSliderGap");
        if (textSliderGap != 0) {
            BorderLayout layout = (BorderLayout)this.getLayout();
            layout.setHgap(textSliderGap);
        }
        this.colorWheel = new ColorWheel();
        this.add(this.colorWheel);
        this.ccModel.configureColorSlider(2, this.brightnessSlider);
        this.colorWheel.setModel(this.ccModel);
        this.ccModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ColorWheelChooser.this.setColorToModel(ColorWheelChooser.this.ccModel.getColor());
            }
        });
    }

    private void initComponents() {
        this.brightnessSlider = new JSlider();
        this.setLayout(new BorderLayout());
        this.brightnessSlider.setMajorTickSpacing(50);
        this.brightnessSlider.setOrientation(1);
        this.brightnessSlider.setPaintTicks(true);
        this.add((Component)this.brightnessSlider, "East");
    }

    protected void buildChooser() {
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorWheel");
    }

    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorWheelIcon");
    }

    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    public void updateChooser() {
        ++this.updatingChooser;
        this.ccModel.setColor(this.getColorFromModel());
        --this.updatingChooser;
    }

    public void setColorToModel(Color color) {
        if (this.updatingChooser == 0) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

