/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.ButtonFocusIcon;
import ch.randelshofer.quaqua.ButtonStateIcon;
import ch.randelshofer.quaqua.FrameButtonStateIcon;
import ch.randelshofer.quaqua.OverlayIcon;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.SliderThumbIcon;
import ch.randelshofer.quaqua.VisuallyLayoutableIcon;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.Methods;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;

public class QuaquaIconFactory {
    private static BufferedImage applicationImage;
    static /* synthetic */ Class class$ch$randelshofer$quaqua$QuaquaIconFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    private QuaquaIconFactory() {
    }

    public static URL getResource(String location) {
        URL url = (class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    public static Image createImage(String location) {
        return QuaquaIconFactory.createImage(class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory, location);
    }

    public static Image createImage(Class baseClass, String location) {
        return Toolkit.getDefaultToolkit().createImage(baseClass.getResource(location));
    }

    public static Image createBufferedImage(String location) {
        return Images.toBufferedImage(QuaquaIconFactory.createImage(location));
    }

    public static Icon[] createIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    public static Icon createIcon(String location, int count, boolean horizontal, int index) {
        return QuaquaIconFactory.createIcons(location, count, horizontal)[index];
    }

    public static Icon createButtonStateIcon(String location, int states) {
        return new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createFrameButtonStateIcon(String location, int states) {
        return new FrameButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createOverlaidButtonStateIcon(String location1, int states1, String location2, int states2, Rectangle layoutRect) {
        return new IconUIResource(new VisuallyLayoutableIcon(new OverlayIcon(QuaquaIconFactory.createButtonStateIcon(location1, states1), QuaquaIconFactory.createButtonFocusIcon(location2, states2)), layoutRect));
    }

    public static Icon createButtonFocusIcon(String location, int states) {
        return new ButtonFocusIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createSliderThumbIcon(String location) {
        return new SliderThumbIcon(QuaquaIconFactory.createImage(location), 5, true);
    }

    public static Icon createIcon(Class baseClass, String location) {
        return new ImageIcon(QuaquaIconFactory.createImage(baseClass, location));
    }

    public static Icon createOptionPaneIcon(int messageType) {
        return new LazyOptionPaneIcon(messageType);
    }

    private static ImageIcon createApplicationIcon() {
        BufferedImage image = QuaquaIconFactory.getApplicationImage();
        return new ImageIcon(image.getScaledInstance(64, 64, 4));
    }

    private static ImageIcon createWarningIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon("images/OptionPane.warningIcon.png");
    }

    private static ImageIcon createErrorIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon("images/OptionPane.errorIcon.png");
    }

    private static ImageIcon composeOptionPaneIcon(String resource) {
        BufferedImage result = new BufferedImage(64, 64, 2);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        BufferedImage warningImage = Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource(resource)));
        g.drawImage(warningImage, 0, 0, 58, 58, null);
        BufferedImage appImage = QuaquaIconFactory.getApplicationImage();
        g.drawImage(appImage, 32, 32, 32, 32, null);
        g.dispose();
        return new ImageIcon(result);
    }

    public static BufferedImage getApplicationImage() {
        if (applicationImage == null) {
            applicationImage = QuaquaIconFactory.createApplicationImage();
        }
        return applicationImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage createApplicationImage() {
        if (QuaquaManager.getProperty("java.version").startsWith("1.3")) {
            return Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource("images/ApplicationIcon.png")));
        }
        Integer myPool = null;
        BufferedImage image = null;
        myPool = (Integer)Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "push");
        Object nsApplication = Methods.invokeStatic("com.apple.cocoa.application.NSApplication", "sharedApplication");
        Object applicationIconImage = Methods.invoke(nsApplication, "applicationIconImage");
        Object data = Methods.invoke(applicationIconImage, "TIFFRepresentation");
        int dataLength = Methods.invokeGetter(data, "length", -1);
        byte[] bytes = (byte[])Methods.invoke(data, "bytes", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(0), new Integer(dataLength)});
        Class<?> imageIOClazz = Class.forName("javax.imageio.ImageIO");
        Object imageInputStream = Methods.invokeStatic(imageIOClazz, "createImageInputStream", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, (Object)new ByteArrayInputStream(bytes));
        Object imageReader = ((Iterator)Methods.invokeStatic(imageIOClazz, "getImageReadersByFormatName", class$java$lang$String == null ? (class$java$lang$String = QuaquaIconFactory.class$("java.lang.String")) : class$java$lang$String, (Object)"tiff")).next();
        Methods.invoke(imageReader, "setInput", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, imageInputStream);
        image = (BufferedImage)Methods.invoke(imageReader, "read", 0);
        Object var11_12 = null;
        if (myPool == null) return image;
        try {
            Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "pop", Integer.TYPE, (Object)myPool);
            return image;
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        }
        return image;
        {
            catch (Exception e) {
                System.err.println("Warning " + (class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory) + " couldn't access Java for Cocoa. Please make sure that /System/Library/Java is in the class path.");
                BufferedImage bufferedImage = Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource("images/ApplicationIcon.png")));
                Object var11_13 = null;
                if (myPool == null) return bufferedImage;
                try {
                    Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "pop", Integer.TYPE, (Object)myPool);
                    return bufferedImage;
                }
                catch (NoSuchMethodException e2) {
                    e2.printStackTrace();
                }
                return bufferedImage;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (myPool == null) throw throwable;
            try {
                Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "pop", Integer.TYPE, (Object)myPool);
                throw throwable;
            }
            catch (NoSuchMethodException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    static /* synthetic */ ImageIcon access$100() {
        return QuaquaIconFactory.createWarningIcon();
    }

    static /* synthetic */ ImageIcon access$200() {
        return QuaquaIconFactory.createErrorIcon();
    }

    static /* synthetic */ ImageIcon access$300() {
        return QuaquaIconFactory.createApplicationIcon();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LazyOptionPaneIcon
    implements Icon {
        private ImageIcon realIcon;
        private int messageType;
        private Worker worker;

        public LazyOptionPaneIcon(int messageType) {
            this.messageType = messageType;
        }

        public int getIconHeight() {
            return 64;
        }

        public int getIconWidth() {
            return 64;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.realIcon == null && this.worker == null) {
                this.worker = new Worker(this, c){
                    private final /* synthetic */ Component val$c;
                    private final /* synthetic */ LazyOptionPaneIcon this$0;
                    {
                        this.this$0 = this$0;
                        this.val$c = val$c;
                    }

                    public Object construct() {
                        switch (LazyOptionPaneIcon.access$000(this.this$0)) {
                            case 2: {
                                return QuaquaIconFactory.access$100();
                            }
                            case 0: {
                                return QuaquaIconFactory.access$200();
                            }
                        }
                        return QuaquaIconFactory.access$300();
                    }

                    public void finished(Object value) {
                        LazyOptionPaneIcon.access$402(this.this$0, (ImageIcon)value);
                        LazyOptionPaneIcon.access$502(this.this$0, null);
                        this.val$c.repaint();
                    }
                };
                this.worker.start();
            } else if (this.realIcon != null) {
                this.realIcon.paintIcon(c, g, x, y);
            }
        }

        static /* synthetic */ int access$000(LazyOptionPaneIcon x0) {
            return x0.messageType;
        }

        static /* synthetic */ ImageIcon access$402(LazyOptionPaneIcon x0, ImageIcon x1) {
            x0.realIcon = x1;
            return x0.realIcon;
        }

        static /* synthetic */ Worker access$502(LazyOptionPaneIcon x0, Worker x1) {
            x0.worker = x1;
            return x0.worker;
        }
    }
}

