/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther;

import ch.randelshofer.quaqua.BackgroundBorder;
import ch.randelshofer.quaqua.Debug;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.TextureColor;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class Quaqua14PantherScrollTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabsComboBox tabsCombo;
    private ItemListener itemListener;
    private ContainerListener containerListener;
    private Vector htmlViews;
    private Insets outerTabInsets;
    private Insets smallTabInsets;
    private Insets smallOuterTabInsets;
    private Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    private static Insets tabVisualMargin = new Insets(3, 3, 3, 3);
    private int tabCount;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private String propertyPrefix = "TabbedPane.";
    private TabsComboBoxModel tabsComboModel = new TabsComboBoxModel();

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String newValue) {
        this.propertyPrefix = newValue;
    }

    public static ComponentUI createUI(JComponent x) {
        return new Quaqua14PantherScrollTabbedPaneUI();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new QuaquaTabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.tabPane, prefix + "background", prefix + "foreground", prefix + "font");
        this.highlight = UIManager.getColor(prefix + "light");
        this.lightHighlight = UIManager.getColor(prefix + "highlight");
        this.shadow = UIManager.getColor(prefix + "shadow");
        this.darkShadow = UIManager.getColor(prefix + "darkShadow");
        this.focus = UIManager.getColor(prefix + "focus");
        this.textIconGap = UIManager.getInt(prefix + "textIconGap");
        this.tabInsets = UIManager.getInsets(prefix + "tabInsets");
        this.smallTabInsets = UIManager.getInsets(prefix + "smallTabInsets");
        this.selectedTabPadInsets = UIManager.getInsets(prefix + "selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets(prefix + "tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets(prefix + "contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt(prefix + "tabRunOverlay");
        LookAndFeel.installBorder(this.tabPane, prefix + "border");
        this.tabPane.setOpaque(QuaquaManager.getBoolean(prefix + "opaque"));
        this.outerTabInsets = UIManager.getInsets(prefix + "outerTabInsets");
        this.smallOuterTabInsets = UIManager.getInsets(prefix + "smallOuterTabInsets");
        this.tabPane.setOpaque(QuaquaManager.getBoolean(prefix + "opaque"));
    }

    protected void installComponents() {
        if (this.tabsCombo == null) {
            this.tabsCombo = new TabsComboBox();
            this.tabsCombo.setModel(this.tabsComboModel);
            this.tabsCombo.setFont(this.tabPane.getFont());
        }
        this.tabPane.add(this.tabsCombo);
        this.tabsComboModel.setModel(this.tabPane);
    }

    protected void uninstallComponents() {
        this.tabPane.remove(this.tabsCombo);
        this.tabsComboModel.setModel(this.tabPane);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        if ((this.itemListener = this.createItemListener()) != null) {
            this.tabsCombo.addItemListener(this.itemListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.itemListener != null && this.tabsCombo != null) {
            this.tabsCombo.removeItemListener(this.itemListener);
        }
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new QuaquaMouseHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyHandler();
    }

    protected ChangeListener createChangeListener() {
        return new QuaquaTabSelectionHandler();
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
    }

    protected Insets getVisualMargin() {
        Insets visualMargin = (Insets)this.tabPane.getClientProperty("Quaqua.Component.visualMargin");
        if (visualMargin == null) {
            visualMargin = UIManager.getInsets("Component.visualMargin");
        }
        return visualMargin;
    }

    protected Insets getTabVisualMargin() {
        return tabVisualMargin;
    }

    protected Insets getInsets() {
        Insets insets = this.tabPane.getInsets();
        Insets visualMargin = this.getVisualMargin();
        insets.top += visualMargin.top;
        insets.left += visualMargin.left;
        insets.bottom += visualMargin.bottom;
        insets.right += visualMargin.right;
        return insets;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        boolean isSmall = this.tabPane.getFont().getSize() <= 11;
        int tabCount = this.tabPane.getTabCount();
        Insets insets = tabCount == 1 ? (Insets)(isSmall ? this.smallOuterTabInsets : this.outerTabInsets).clone() : (tabIndex == 0 ? (isSmall ? new Insets(this.smallOuterTabInsets.top, this.smallOuterTabInsets.left, this.smallTabInsets.bottom, this.smallTabInsets.right) : new Insets(this.outerTabInsets.top, this.outerTabInsets.left, this.tabInsets.bottom, this.tabInsets.right)) : (tabIndex == tabCount - 1 ? (isSmall ? new Insets(this.smallTabInsets.top, this.smallTabInsets.left, this.smallOuterTabInsets.bottom, this.smallOuterTabInsets.right) : new Insets(this.tabInsets.top, this.tabInsets.left, this.outerTabInsets.bottom, this.outerTabInsets.right)) : (Insets)(isSmall ? this.smallTabInsets : this.tabInsets).clone()));
        Insets visualMargin = this.getTabVisualMargin();
        InsetsUtil.addTo(visualMargin, insets);
        return insets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = null;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            insets = (Insets)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentInsets");
        }
        if (insets == null) {
            insets = this.contentBorderInsets;
        }
        this.currentContentBorderInsets.top = insets.top;
        this.currentContentBorderInsets.left = insets.left;
        this.currentContentBorderInsets.bottom = insets.bottom;
        this.currentContentBorderInsets.right = insets.right;
        switch (tabPlacement) {
            case 2: {
                this.currentContentBorderInsets.left -= 3;
                break;
            }
            case 4: {
                this.currentContentBorderInsets.right -= 3;
                break;
            }
            case 3: {
                this.currentContentBorderInsets.bottom -= 2;
                break;
            }
            default: {
                this.currentContentBorderInsets.top -= 3;
            }
        }
        return this.currentContentBorderInsets;
    }

    public void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
        if (!this.tabsCombo.isVisible()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        Debug.paint(g, c, this);
    }

    protected void paintContentBorder(Graphics gr, int tabPlacement, int selectedIndex) {
        Border b;
        Boolean isContentBorderPainted = (Boolean)this.tabPane.getClientProperty("Quaqua.TabbedPane.contentBorderPainted");
        if (isContentBorderPainted != null && !isContentBorderPainted.booleanValue()) {
            return;
        }
        Graphics2D g = (Graphics2D)gr;
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) / 2) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) / 2;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) / 2;
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) / 2) - insets.top;
            }
        }
        Color contentBackground = null;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            contentBackground = (Color)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentBackground");
        }
        if (contentBackground != null) {
            g.setPaint(TextureColor.getPaint(contentBackground, this.tabPane));
            g.fillRoundRect(x, y, w - 1, h - 1, 12, 12);
            b = UIManager.getBorder(this.getPropertyPrefix() + "emptyContentBorder");
        } else {
            b = UIManager.getBorder(this.getPropertyPrefix() + "contentBorder");
        }
        if (b instanceof BackgroundBorder) {
            b = ((BackgroundBorder)b).getBackgroundBorder();
        }
        if (b != null) {
            b.paintBorder(this.tabPane, g, x, y, w, h);
        }
    }

    protected String layoutTabLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        String croppedLabel = SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        if (textRect.width == 0) {
            textRect.x = tabRect.x;
        }
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
        return croppedLabel;
    }

    protected void paintTabArea(Graphics gr, int tabPlacement, int selectedIndex) {
        Graphics2D g;
        if (tabPlacement == 2 || tabPlacement == 4) {
            g = (Graphics2D)gr.create();
            AffineTransform t = new AffineTransform();
            if (tabPlacement == 2) {
                t.rotate(-1.5707963267948966, this.tabPane.getHeight() / 2, this.tabPane.getHeight() / 2);
            } else {
                t.rotate(1.5707963267948966, this.tabPane.getWidth() / 2, this.tabPane.getWidth() / 2);
            }
            g.transform(t);
        } else {
            g = (Graphics2D)gr;
        }
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = gr.getClipBounds();
        for (int j = 0; j < tabCount; ++j) {
            if (!this.rects[j].intersects(clipRect)) continue;
            this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
        }
        if (tabPlacement == 2 || tabPlacement == 4) {
            g.dispose();
        }
    }

    protected void paintTab(Graphics gr, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Graphics2D g = (Graphics2D)gr;
        Rectangle tabRect = rects[tabIndex];
        if (tabPlacement == 2) {
            tabRect = new Rectangle(this.tabPane.getHeight() - tabRect.y - tabRect.height, tabRect.x, tabRect.height, tabRect.width);
        } else if (tabPlacement == 4) {
            tabRect = new Rectangle(tabRect.y, this.tabPane.getWidth() - tabRect.x - tabRect.width, tabRect.height, tabRect.width);
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = gr.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        Rectangle innerTabRect = new Rectangle(tabRect.x + insets.left, tabRect.y, tabRect.width - insets.left - insets.right, tabRect.height);
        title = this.layoutTabLabel(tabPlacement, metrics, tabIndex, title, icon, innerTabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        String prefix = this.getPropertyPrefix();
        Border[] b = this.tabPane.getTabCount() == 1 ? (Border[])UIManager.get(prefix + "tabBorders") : (tabIndex == 0 ? (Border[])UIManager.get(prefix + "westTabBorders") : (tabIndex == this.tabPane.getTabCount() - 1 ? (Border[])UIManager.get(prefix + "eastTabBorders") : (Border[])UIManager.get(prefix + "centerTabBorders")));
        boolean isEnabled = this.tabPane.isEnabled();
        boolean isOnActive = QuaquaUtilities.isOnActiveWindow(this.tabPane);
        int i = isEnabled && isOnActive ? (isSelected ? 2 : 0) : (isEnabled ? (isSelected ? 7 : 6) : (isSelected ? 9 : 8));
        Insets visualMargin = this.getTabVisualMargin();
        y -= 3 - visualMargin.top;
        h += 6 - visualMargin.top - visualMargin.bottom;
        if (tabIndex == 0) {
            x -= 3 - visualMargin.left;
        }
        if (tabIndex == 0 || tabIndex == this.tabPane.getTabCount() - 1) {
            w += 6 - visualMargin.left - visualMargin.right;
        }
        if (b != null) {
            b[i].paintBorder(this.tabPane, g, x, y, w, h);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                String prefix = this.getPropertyPrefix();
                Color c = UIManager.getColor(prefix + "disabledForeground");
                g.setColor(c != null ? c : this.tabPane.getForeground());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        String prefix = this.getPropertyPrefix();
        if (this.tabPane.hasFocus() && isSelected) {
            Rectangle r = rects[tabIndex];
            if (tabPlacement == 2) {
                r = new Rectangle(this.tabPane.getHeight() - r.y - r.height, r.x, r.height, r.width);
            } else if (tabPlacement == 4) {
                r = new Rectangle(r.y, this.tabPane.getWidth() - r.x - r.width, r.height, r.width);
            }
            Border b = this.tabPane.getTabCount() == 1 ? (Border)UIManager.get(prefix + "tabFocusRing") : (tabIndex == 0 ? (Border)UIManager.get(prefix + "westTabFocusRing") : (tabIndex == this.tabPane.getTabCount() - 1 ? (Border)UIManager.get(prefix + "eastTabFocusRing") : (Border)UIManager.get(prefix + "centerTabFocusRing")));
            int x = r.x;
            int y = r.y;
            int w = r.width;
            int h = r.height;
            Insets visualMargin = this.getTabVisualMargin();
            y -= 3 - visualMargin.top;
            h += 6 - visualMargin.top - visualMargin.bottom;
            if (tabIndex == 0) {
                x -= 3 - visualMargin.left;
            }
            if (tabIndex == 0 || tabIndex == this.tabPane.getTabCount() - 1) {
                w += 6 - visualMargin.left - visualMargin.right;
            }
            b.paintBorder(this.tabPane, g, x, y, w, h);
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (this.tabsCombo.isVisible()) {
            return -1;
        }
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        dest.x = this.rects[tabIndex].x;
        dest.y = this.rects[tabIndex].y;
        return dest;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        View v = this.getTextViewForTab(tabIndex);
        height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        return height += tabInsets.top + tabInsets.bottom;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        int result = vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
        return result;
    }

    InputMap getInputMap(int condition) {
        String prefix = this.getPropertyPrefix();
        if (condition == 1) {
            return (InputMap)UIManager.get(prefix + "ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get(prefix + "focusInputMap");
        }
        return null;
    }

    protected void repaintTabArea() {
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        Rectangle clipRect = new Rectangle();
        Insets insets = this.getInsets();
        Dimension size = this.tabPane.getSize();
        switch (tabPlacement) {
            case 2: {
                clipRect.setBounds(insets.left, insets.top, this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) + 6, size.height - insets.bottom - insets.top);
                break;
            }
            case 3: {
                int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                clipRect.setBounds(insets.left, size.height - insets.bottom - totalTabHeight - 6, size.width - insets.left - insets.right, totalTabHeight + 6);
                break;
            }
            case 4: {
                int totalTabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                clipRect.setBounds(size.width - insets.right - totalTabWidth - 6, insets.top, totalTabWidth + 6, size.height - insets.top - insets.bottom);
                break;
            }
            default: {
                clipRect.setBounds(insets.left, insets.top, size.width - insets.right - insets.left, this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + 6);
            }
        }
        this.tabPane.repaint(clipRect);
    }

    ActionMap getActionMap() {
        String prefix = this.getPropertyPrefix();
        ActionMap map = (ActionMap)UIManager.get(prefix + "actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(prefix + "actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        return map;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return false;
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusTraversable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    private static class TabsComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ContainerListener,
    ChangeListener {
        private JTabbedPane model;

        private TabsComboBoxModel() {
        }

        public void setModel(JTabbedPane newValue) {
            if (this.model != null) {
                this.model.removeContainerListener(this);
                this.model.removeChangeListener(this);
                if (this.model.getTabCount() > 0) {
                    this.fireIntervalRemoved(this, 0, this.model.getTabCount() - 1);
                }
            }
            this.model = newValue;
            if (this.model != null) {
                this.model.addContainerListener(this);
                this.model.addChangeListener(this);
                if (this.model.getTabCount() > 0) {
                    this.fireIntervalAdded(this, 0, this.model.getTabCount() - 1);
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getElementAt(int index) {
            return this.model == null ? null : this.model.getTitleAt(index);
        }

        public Object getSelectedItem() {
            if (this.model == null) {
                return null;
            }
            int index = this.model.getSelectedIndex();
            return index != -1 ? this.getElementAt(index) : null;
        }

        public int getSize() {
            return this.model == null ? 0 : this.model.getTabCount();
        }

        public void setSelectedItem(Object anItem) {
            if (this.model == null) {
                return;
            }
            int n = this.model.getTabCount();
            for (int i = 0; i < n; ++i) {
                if (!this.model.getTitleAt(i).equals(anItem)) continue;
                this.model.setSelectedIndex(i);
                break;
            }
        }

        public void componentAdded(ContainerEvent evt) {
            Component child = evt.getChild();
            if (!(child instanceof UIResource)) {
                int index = this.model.indexOfComponent(child);
                this.fireIntervalAdded(this, index, index);
            }
        }

        public void componentRemoved(ContainerEvent evt) {
            Component child = evt.getChild();
            if (!(child instanceof UIResource)) {
                this.fireIntervalRemoved(this, 0, 0);
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public class QuaquaTabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
        }
    }

    public class QuaquaPropertyHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        public QuaquaPropertyHandler() {
            super(Quaqua14PantherScrollTabbedPaneUI.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("enabled".equals(name)) {
                Quaqua14PantherScrollTabbedPaneUI.this.tabsCombo.setEnabled(Quaqua14PantherScrollTabbedPaneUI.this.tabPane.isEnabled());
            } else if (name.equals("Frame.active")) {
                Quaqua14PantherScrollTabbedPaneUI.this.repaintTabArea();
            } else if (name.equals("font")) {
                Quaqua14PantherScrollTabbedPaneUI.this.tabsCombo.setFont((Font)evt.getNewValue());
            }
            if (!name.equals("tabLayoutPolicy")) {
                super.propertyChange(evt);
            }
        }
    }

    public class QuaquaMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public QuaquaMouseHandler() {
            super(Quaqua14PantherScrollTabbedPaneUI.this);
        }

        public void mousePressed(MouseEvent evt) {
            if (!Quaqua14PantherScrollTabbedPaneUI.this.tabsCombo.isVisible()) {
                super.mousePressed(evt);
            }
        }
    }

    public class QuaquaTabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = Quaqua14PantherScrollTabbedPaneUI.this.getInsets();
            Insets contentInsets = Quaqua14PantherScrollTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = Quaqua14PantherScrollTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = contentInsets.top + contentInsets.bottom;
            int width = contentInsets.left + contentInsets.right;
            int cWidth = 0;
            int cHeight = 0;
            for (int i = 0; i < Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Component component = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension size = zeroSize;
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size == null) continue;
                cHeight = Math.max(size.height, cHeight);
                cWidth = Math.max(size.width, cWidth);
            }
            width += cWidth;
            height += cHeight;
            int tabExtent = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement) + tabAreaInsets.top + tabAreaInsets.bottom);
                    tabExtent = this.preferredTabAreaWidth(tabPlacement, height);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement) + tabAreaInsets.left + tabAreaInsets.right);
                    tabExtent = this.preferredTabAreaHeight(tabPlacement, width);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics metrics = Quaqua14PantherScrollTabbedPaneUI.this.getFontMetrics();
            int tabCount = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    int tabWidth = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics metrics = Quaqua14PantherScrollTabbedPaneUI.this.getFontMetrics();
            int tabCount = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = metrics.getHeight();
                if (tabPlacement == 2 || tabPlacement == 4) {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                } else {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                }
                for (int i = 0; i < tabCount; ++i) {
                    int tabHeight = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth);
            }
            return total;
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets tabAreaInsets = Quaqua14PantherScrollTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = Quaqua14PantherScrollTabbedPaneUI.this.getInsets();
            int selectedIndex = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = Quaqua14PantherScrollTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    Quaqua14PantherScrollTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Insets contentInsets = Quaqua14PantherScrollTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Component selectedComponent = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    Quaqua14PantherScrollTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Rectangle bounds = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int ch;
                    int cw;
                    int cy;
                    int cx;
                    int ty;
                    int tx;
                    int th;
                    int tw;
                    switch (tabPlacement) {
                        case 2: {
                            tw = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, Quaqua14PantherScrollTabbedPaneUI.this.runCount, Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = insets.left;
                            ty = insets.top;
                            cx = insets.left + tw + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 4: {
                            tw = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, Quaqua14PantherScrollTabbedPaneUI.this.runCount, Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = bounds.width - insets.right - tw;
                            ty = insets.top;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 3: {
                            tw = bounds.width - insets.left - insets.right;
                            th = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, Quaqua14PantherScrollTabbedPaneUI.this.runCount, Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight);
                            tx = insets.left;
                            ty = bounds.height - insets.bottom - th;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        default: {
                            tw = bounds.width - insets.left - insets.right;
                            th = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, Quaqua14PantherScrollTabbedPaneUI.this.runCount, Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight);
                            tx = insets.left;
                            ty = insets.top;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + th + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        }
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getComponent(i);
                        if (child instanceof TabsComboBox) {
                            Dimension preferredSize = child.getPreferredSize();
                            preferredSize.width = Math.min(tw - tabAreaInsets.left - tabAreaInsets.right, preferredSize.width);
                            child.setBounds(tx + (tw - preferredSize.width) / 2, ty + (th - preferredSize.height) / 2, preferredSize.width, preferredSize.height);
                            continue;
                        }
                        child.setBounds(cx, cy, cw, ch);
                    }
                }
                if (shouldChangeFocus && !Quaqua14PantherScrollTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    Quaqua14PantherScrollTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabCount();
            Quaqua14PantherScrollTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int avgTabSize;
            int availableTabSize;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = Quaqua14PantherScrollTabbedPaneUI.this.getFontMetrics();
            Dimension size = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getSize();
            Insets insets = Quaqua14PantherScrollTabbedPaneUI.this.getInsets();
            Insets tabAreaInsets = Quaqua14PantherScrollTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = QuaquaUtilities.isLeftToRight(Quaqua14PantherScrollTabbedPaneUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight = Quaqua14PantherScrollTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = Quaqua14PantherScrollTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            Quaqua14PantherScrollTabbedPaneUI.this.runCount = 0;
            Quaqua14PantherScrollTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            if (!verticalTabRuns) {
                availableTabSize = returnAt - x;
                avgTabSize = availableTabSize / tabCount;
            } else {
                availableTabSize = returnAt - y;
                avgTabSize = availableTabSize / tabCount;
            }
            int redistributableSize = 0;
            int totalTabSize = 0;
            int minTabSize = Integer.MAX_VALUE;
            for (i = 0; i < tabCount; ++i) {
                rect = Quaqua14PantherScrollTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    rect.width = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = Math.max(Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth, rect.width);
                    totalTabSize += rect.width;
                    if (rect.width >= avgTabSize) continue;
                    redistributableSize += avgTabSize - rect.width;
                    continue;
                }
                rect.height = Quaqua14PantherScrollTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight = Math.max(Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight, rect.height);
                totalTabSize += rect.height;
                if (rect.height >= avgTabSize) continue;
                redistributableSize += avgTabSize - rect.height;
            }
            if (verticalTabRuns || totalTabSize <= availableTabSize || redistributableSize > 0 && Quaqua14PantherScrollTabbedPaneUI.this.tabPane.getClientProperty("Quaqua.TabbedPane.shortenTabs") != Boolean.FALSE) {
                Quaqua14PantherScrollTabbedPaneUI.this.tabsCombo.setVisible(false);
            } else {
                Quaqua14PantherScrollTabbedPaneUI.this.tabsCombo.setVisible(true);
            }
            for (i = 0; i < tabCount; ++i) {
                rect = Quaqua14PantherScrollTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].x + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[0] = 0;
                        Quaqua14PantherScrollTabbedPaneUI.this.runCount = 1;
                        Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    if (rect.width > avgTabSize) {
                        rect.width = Math.min(rect.width, redistributableSize + avgTabSize);
                        redistributableSize -= rect.width - avgTabSize;
                    }
                    rect.y = y;
                    rect.height = Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight;
                } else if (tabPlacement == 2) {
                    if (rect.height > avgTabSize) {
                        rect.height = Math.min(rect.height, redistributableSize + avgTabSize);
                        redistributableSize -= rect.height - avgTabSize;
                    }
                    rect.x = x;
                    rect.width = Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth;
                    if (i > 0) {
                        rect.y = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].y - rect.height;
                    } else {
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[0] = 0;
                        Quaqua14PantherScrollTabbedPaneUI.this.runCount = 1;
                        Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = returnAt - rect.height;
                    }
                } else {
                    if (i > 0) {
                        rect.y = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].y + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[0] = 0;
                        Quaqua14PantherScrollTabbedPaneUI.this.runCount = 1;
                        Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    if (rect.height > avgTabSize) {
                        rect.height = Math.min(rect.height, redistributableSize + avgTabSize);
                        redistributableSize -= rect.height - avgTabSize;
                    }
                    rect.x = x;
                    rect.width = Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                Quaqua14PantherScrollTabbedPaneUI.this.selectedRun = Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1;
            }
            for (i = Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[i];
                int next = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[i == Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = Quaqua14PantherScrollTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += Quaqua14PantherScrollTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (Quaqua14PantherScrollTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = Quaqua14PantherScrollTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += Quaqua14PantherScrollTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (Quaqua14PantherScrollTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].x = rightMargin - ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].x - ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].width;
                }
            }
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    int availableTabAreaHeight = size.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    int usedTabAreaHeight = 0;
                    int pad = 0;
                    for (int run = 0; run < Quaqua14PantherScrollTabbedPaneUI.this.runCount; ++run) {
                        int firstIndex = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[run];
                        int lastIndex = Quaqua14PantherScrollTabbedPaneUI.this.lastTabInRun(tabCount, run);
                        if (run == 0) {
                            usedTabAreaHeight = 0;
                            for (i = firstIndex; i <= lastIndex; ++i) {
                                usedTabAreaHeight += ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].height;
                            }
                            pad = (availableTabAreaHeight - usedTabAreaHeight) / 2;
                        }
                        if (tabPlacement == 2) {
                            pad = -pad;
                        }
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].y += pad;
                        }
                    }
                    break;
                }
                default: {
                    int availableTabAreaWidth = size.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    for (int run = 0; run < Quaqua14PantherScrollTabbedPaneUI.this.runCount; ++run) {
                        int firstIndex = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[run];
                        int lastIndex = Quaqua14PantherScrollTabbedPaneUI.this.lastTabInRun(tabCount, run);
                        int usedTabAreaWidth = 0;
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            usedTabAreaWidth += ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].width;
                        }
                        int pad = (availableTabAreaWidth - usedTabAreaWidth) / 2;
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].x += pad;
                        }
                    }
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[0];
                for (int j = 1; j < Quaqua14PantherScrollTabbedPaneUI.this.runCount; ++j) {
                    ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[j - 1] = Quaqua14PantherScrollTabbedPaneUI.this.tabRuns[j];
                }
                ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = Quaqua14PantherScrollTabbedPaneUI.this.lastTabInRun(tabCount, run);
                int prevLast = Quaqua14PantherScrollTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[last].x + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[last].width;
                    prevLastLen = (int)((double)Quaqua14PantherScrollTabbedPaneUI.this.maxTabWidth * weight);
                } else {
                    end = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[last].y + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[last].height;
                    prevLastLen = (int)((double)Quaqua14PantherScrollTabbedPaneUI.this.maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[prevLast].x = start;
                    } else {
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[prevLast].y = start;
                    }
                    for (int i = prevLast + 1; i <= last; ++i) {
                        if (!verticalTabRuns) {
                            ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].x = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].x + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].width;
                            continue;
                        }
                        ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i].y = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].y + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[i - 1].height;
                    }
                } else if (run == Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = Quaqua14PantherScrollTabbedPaneUI.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = Quaqua14PantherScrollTabbedPaneUI.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = Quaqua14PantherScrollTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.x = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[j - 1].x + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = Quaqua14PantherScrollTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.y = ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[j - 1].y + ((Quaqua14PantherScrollTabbedPaneUI)Quaqua14PantherScrollTabbedPaneUI.this).rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = Quaqua14PantherScrollTabbedPaneUI.this.rects[selectedIndex];
                Insets padInsets = Quaqua14PantherScrollTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
            }
        }
    }

    private class ItemHandler
    implements ItemListener {
        private ItemHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof BasicTabbedPaneUI) {
                Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Quaqua14PantherScrollTabbedPaneUI ui = (Quaqua14PantherScrollTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (Quaqua14PantherScrollTabbedPaneUI.this.htmlViews == null) {
                    Quaqua14PantherScrollTabbedPaneUI.this.htmlViews = Quaqua14PantherScrollTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    Quaqua14PantherScrollTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (Quaqua14PantherScrollTabbedPaneUI.this.htmlViews != null) {
                Quaqua14PantherScrollTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (Quaqua14PantherScrollTabbedPaneUI.this.htmlViews != null && Quaqua14PantherScrollTabbedPaneUI.this.htmlViews.size() >= index) {
                    Quaqua14PantherScrollTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
            }
        }
    }

    private static class TabsComboBox
    extends JComboBox
    implements UIResource {
        private TabsComboBox() {
        }

        public void setBorder(Border b) {
            if (b instanceof UIResource) {
                super.setBorder(b);
            }
        }
    }
}

