/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.Color;
import java.io.File;

public class Files {
    private static final Color[][] labelColors;
    private static final boolean isNativeCodeAvailable;
    static /* synthetic */ Class class$ch$randelshofer$quaqua$filechooser$Files;

    private Files() {
    }

    public static File getAbsoluteFile(File f) {
        if (!f.isAbsolute()) {
            f = new File(QuaquaManager.getProperty("user.home") + File.separatorChar + f.getPath());
        }
        if (File.separatorChar == '\\') {
            return f;
        }
        StringBuffer buf = new StringBuffer(f.getPath().length());
        int skip = 0;
        for (File i = f; i != null; i = i.getParentFile()) {
            String name = i.getName();
            if (name.equals(".")) {
                if (skip <= 0) continue;
                --skip;
                continue;
            }
            if (name.equals("..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                --skip;
                continue;
            }
            buf.insert(0, name);
            buf.insert(0, File.separatorChar);
        }
        return f.getPath().equals(buf.toString()) ? f : new File(buf.toString());
    }

    public static boolean canWorkWithAliases() {
        return isNativeCodeAvailable;
    }

    public static boolean isAlias(File f) {
        if (isNativeCodeAvailable) {
            return Files.isAlias(f.getPath());
        }
        return false;
    }

    public static File resolveAlias(File f) {
        if (isNativeCodeAvailable) {
            return new File(Files.resolveAlias(f.getPath()));
        }
        return f;
    }

    public static byte[] toSerializedAlias(File f) {
        if (isNativeCodeAvailable) {
            return Files.toSerializedAlias(f.getPath());
        }
        return null;
    }

    public static File toFile(byte[] serializedAlias) {
        if (isNativeCodeAvailable) {
            String path = Files.toPath(serializedAlias);
            return path == null ? null : new File(path);
        }
        return null;
    }

    public static boolean canWorkWithLabels() {
        return isNativeCodeAvailable;
    }

    public static int getFileLabel(File f) {
        if (isNativeCodeAvailable && f != null) {
            return Files.getFileLabel(f.getPath());
        }
        return -1;
    }

    public static Color getLabelColor(int label, int type) {
        return label == -1 ? null : labelColors[label][type];
    }

    private static native boolean isAlias(String var0);

    private static native String resolveAlias(String var0);

    private static native byte[] toSerializedAlias(String var0);

    private static native String toPath(byte[] var0);

    private static native int getFileLabel(String var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean success;
        labelColors = new Color[][]{{null, null, null, null}, {new Color(0xB5B5B5), new Color(0xD7D7D7), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12442714), new Color(14478762), new Color(15529422), new Color(16120550)}, {new Color(13344222), new Color(14928878), new Color(15786742), new Color(16249082)}, {new Color(6730239), new Color(11983615), new Color(13756671), new Color(15332607)}, {new Color(15916890), new Color(16512170), new Color(16578254), new Color(16710886)}, {new Color(16741740), new Color(16757420), new Color(16766675), new Color(16771302)}, {new Color(16430421), new Color(16570018), new Color(16705996), new Color(0xFFF3E3)}};
        String value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
        if (value != null && value.equals("true")) {
            success = true;
        } else {
            try {
                System.loadLibrary("quaqua");
                success = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Warning: " + (class$ch$randelshofer$quaqua$filechooser$Files == null ? (class$ch$randelshofer$quaqua$filechooser$Files = Files.class$("ch.randelshofer.quaqua.filechooser.Files")) : class$ch$randelshofer$quaqua$filechooser$Files) + " couldn't load library libquaqua.jnilib.");
                success = false;
            }
        }
        isNativeCodeAvailable = success;
    }
}

