/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.Files;
import ch.randelshofer.quaqua.filechooser.OSXCollator;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.util.ArrayUtil;
import ch.randelshofer.quaqua.util.ConcurrentDispatcher;
import ch.randelshofer.quaqua.util.IteratorEnumeration;
import ch.randelshofer.quaqua.util.SequentialDispatcher;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.IllegalComponentStateException;
import java.io.File;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AliasFileSystemTreeModel
implements TreeModel {
    private static final boolean DEBUG = false;
    public static final File COMPUTER = new File("/");
    public static final int INVALID = 0;
    public static final int VALIDATING = 1;
    public static final int VALID = 2;
    protected EventListenerList listenerList = new EventListenerList();
    private JFileChooser fileChooser;
    private RootNode root;
    private Comparator nodeComparator;
    private boolean isAutoValidate;
    private boolean isResolveAliasesToFiles = true;
    private boolean isResolveFileLabels = true;
    private Collator collator;
    private SequentialDispatcher fileInfoDispatcher;
    private ConcurrentDispatcher directoryDispatcher;
    private boolean doItFast;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public AliasFileSystemTreeModel(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.root = new RootNode();
        this.fileInfoDispatcher = new SequentialDispatcher();
        this.directoryDispatcher = new ConcurrentDispatcher();
        this.doItFast = QuaquaManager.getBoolean("FileChooser.speed");
    }

    public void clear() {
        int[] removedIndices = new int[this.root.getChildCount()];
        Object[] removedChildren = new Object[removedIndices.length];
        for (int i = 0; i < removedIndices.length; ++i) {
            removedIndices[i] = i;
            removedChildren[i] = this.root.getChildAt(0);
            this.root.remove(0);
        }
        this.fireTreeNodesRemoved(this, new Object[]{this.root}, removedIndices, removedChildren);
    }

    public Node getPrototypeValue() {
        return new Node(new File(QuaquaManager.getProperty("user.home")), "Prototype");
    }

    public Object getChild(Object parent, int index) {
        return ((Node)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((Node)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((Node)parent).getIndex((Node)child);
    }

    private int getIndexOfChildForFile(Node parent, File file) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (!((Node)parent.getChildAt(i)).getFile().equals(file)) continue;
            return i;
        }
        return -1;
    }

    private Comparator getNodeComparator() {
        if (this.nodeComparator == null) {
            this.nodeComparator = QuaquaManager.getBoolean("FileChooser.orderByType") ? new NodeTypeComparator() : new NodeNameComparator();
        }
        return this.nodeComparator;
    }

    private Collator getCollator() {
        if (this.collator == null) {
            Locale locale;
            try {
                locale = this.fileChooser.getLocale();
            }
            catch (IllegalComponentStateException e) {
                locale = Locale.getDefault();
            }
            this.collator = new OSXCollator(locale);
        }
        return this.collator;
    }

    private int getInsertionIndexForNode(Node parent, Node child) {
        int i;
        Comparator comparator = this.getNodeComparator();
        for (i = 0; i < parent.getChildCount(); ++i) {
            if (comparator.compare(parent.getChildAt(i), child) < 0) continue;
            return i;
        }
        return i;
    }

    private void insertNodeInto(Node newChild, Node parent, int index) {
        parent.insert(newChild, index);
        int[] newIndices = new int[]{index};
        this.fireTreeNodesInserted(this, parent.getPath(), newIndices, new Object[]{newChild});
    }

    public Object getRoot() {
        return this.root;
    }

    private QuaquaFileSystemView getFileSystemView() {
        FileSystemView fcFileSystemView = this.fileChooser.getFileSystemView();
        if (fcFileSystemView instanceof QuaquaFileSystemView) {
            return (QuaquaFileSystemView)fcFileSystemView;
        }
        return QuaquaFileSystemView.getQuaquaFileSystemView();
    }

    protected Node createNode(File f) {
        boolean isTraversable;
        File resolvedFile = null;
        boolean isDirectory = false;
        boolean isAlias = Files.isAlias(f);
        if (isAlias) {
            resolvedFile = Files.resolveAlias(f);
            isDirectory = resolvedFile.isDirectory();
            if (!this.isResolveAliasesToFiles() && !isDirectory) {
                isAlias = false;
                resolvedFile = f;
            }
        } else {
            resolvedFile = f;
            isDirectory = f.isDirectory();
        }
        if (QuaquaManager.getBoolean("FileChooser.speed")) {
            isTraversable = isDirectory;
        } else {
            boolean bl = isTraversable = isDirectory && this.fileChooser.isTraversable(resolvedFile);
        }
        Node node = isAlias ? (isDirectory && isTraversable ? new AliasDirectoryNode(f, resolvedFile) : new AliasNode(f, resolvedFile)) : (isDirectory && isTraversable ? new DirectoryNode(f) : new Node(f));
        return node;
    }

    public TreePath toPath(File file, TreePath templatePath) {
        Node node;
        int i;
        QuaquaFileSystemView fsv;
        if ((file = Files.getAbsoluteFile(file)).equals((fsv = this.getFileSystemView()).getComputer())) {
            return new TreePath(this.getRoot());
        }
        LinkedList<File> list = new LinkedList<File>();
        File dir = file;
        boolean exists = false;
        do {
            boolean bl = exists = exists || dir.exists();
            if (exists) {
                list.addFirst(dir);
            }
            if (!fsv.isRoot(dir)) continue;
            if (!fsv.getComputer().equals(dir)) break;
            list.set(0, fsv.getSystemVolume());
            break;
        } while ((dir = exists ? fsv.getParentDirectory(dir) : dir.getParentFile()) != null);
        LinkedList<Object> components = new LinkedList<Object>();
        components.add(this.getRoot());
        int mergeIndex = 0;
        block1: for (i = list.size() - 1; i >= 0; --i) {
            File f = (File)list.get(i);
            for (int j = templatePath.getPathCount() - 1; j >= 1; --j) {
                if (!((Node)templatePath.getPathComponent(j)).getFile().equals(f)) continue;
                for (int k = 1; k <= j; ++k) {
                    components.add(templatePath.getPathComponent(k));
                }
                mergeIndex = i + 1;
                break block1;
            }
        }
        for (i = mergeIndex; i < list.size() && !(node = (Node)components.getLast()).isLeaf() && !node.isAlias(); ++i) {
            File childFile = (File)list.get(i);
            int index = this.getIndexOfChildForFile(node, childFile);
            if (index == -1) {
                Node newChild = this.createNode(childFile);
                this.insertNodeInto(newChild, node, this.getInsertionIndexForNode(node, newChild));
                node = newChild;
            } else {
                node = (Node)node.getChildAt(index);
            }
            components.add(node);
        }
        return new TreePath(components.toArray());
    }

    public TreePath toPath0(File file) {
        file = Files.getAbsoluteFile(file);
        LinkedList<File> list = new LinkedList<File>();
        QuaquaFileSystemView fsv = this.getFileSystemView();
        File dir = file;
        boolean exists = false;
        do {
            boolean bl = exists = exists || dir.exists();
            if (!exists) continue;
            list.addFirst(dir);
        } while (!((FileSystemView)fsv).isRoot(dir) && (dir = exists ? ((FileSystemView)fsv).getParentDirectory(dir) : dir.getParentFile()) != null);
        LinkedList<Node> components = new LinkedList<Node>();
        Node node = (Node)this.getRoot();
        for (int i = 0; i < list.size() && !node.isLeaf() && !node.isAlias(); ++i) {
            components.add(node);
            File childFile = (File)list.get(i);
            int index = this.getIndexOfChildForFile(node, childFile);
            if (index == -1) {
                Node newChild = this.createNode(childFile);
                this.insertNodeInto(newChild, node, this.getInsertionIndexForNode(node, newChild));
                node = newChild;
                continue;
            }
            node = (Node)node.getChildAt(index);
        }
        components.add(node);
        return new TreePath(components.toArray());
    }

    public boolean isLeaf(Object node) {
        return ((Node)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void setAutoValidate(boolean b) {
        this.isAutoValidate = b;
    }

    public boolean isAutoValidate() {
        return this.isAutoValidate;
    }

    public void setResolveAliasesToFiles(boolean newValue) {
        if (this.isResolveAliasesToFiles != newValue) {
            this.isResolveAliasesToFiles = newValue;
            this.invalidateAll();
        }
    }

    public boolean isResolveAliasesToFiles() {
        return this.isResolveAliasesToFiles;
    }

    public void setResolveFileLabels(boolean newValue) {
        this.isResolveFileLabels = newValue;
    }

    public boolean isResolveFileLabels() {
        return this.isResolveFileLabels;
    }

    public void invalidateCache() {
        this.root.invalidateTree();
    }

    public void invalidatePath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            Node node = (Node)path.getPathComponent(i);
            node.invalidateChildren();
        }
    }

    public void invalidateAll() {
        this.root.invalidateTree();
    }

    public void stopValidation() {
        this.root.stopValidationSubtree();
    }

    public void lazyInvalidatePath(TreePath path) {
        if (this.isAutoValidate) {
            this.root.lazyInvalidateChildren();
            if (path.getPathComponent(0) != this.root) {
                ((Node)path.getPathComponent(0)).lazyInvalidateChildren();
            }
            if (path.getPathCount() > 1) {
                ((Node)path.getPathComponent(path.getPathCount() - 1)).lazyInvalidateChildren();
                if (path.getPathCount() > 2) {
                    ((Node)path.getPathComponent(path.getPathCount() - 2)).lazyInvalidateChildren();
                }
            }
        }
    }

    public void validatePath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            Node node = (Node)path.getPathComponent(i);
            node.validateChildren();
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    protected void fireTreeNodeChanged(Node node) {
        Node parent = (Node)node.getParent();
        if (parent != null) {
            this.fireTreeNodesChanged(this, parent.getPath(), new int[]{parent.getIndex(node)}, new Object[]{node});
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? AliasFileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private boolean accept(File f) {
        return this.fileChooser.accept(f) && (!this.fileChooser.isFileHidingEnabled() || !this.getFileSystemView().isHiddenFile(f));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NodeTypeComparator
    implements Comparator {
        private NodeTypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            if (n1.isLeaf() == n2.isLeaf()) {
                return n1.getCollationKey().compareTo(n2.getCollationKey());
            }
            return n1.isLeaf() ? 1 : -1;
        }
    }

    private static class NodeNameComparator
    implements Comparator {
        private NodeNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Node)o1).getCollationKey().compareTo(((Node)o2).getCollationKey());
        }
    }

    public class AliasDirectoryNode
    extends DirectoryNode {
        private File resolvedFile;

        public AliasDirectoryNode(File aliasFile, File resolvedFile) {
            super(aliasFile);
            this.resolvedFile = resolvedFile;
        }

        public String getFileKind() {
            return "alias";
        }

        public boolean isAlias() {
            return false;
        }

        public File getFile() {
            return this.resolvedFile;
        }
    }

    public class AliasNode
    extends Node {
        private File resolvedFile;

        public AliasNode(File aliasFile, File resolvedFile) {
            super(aliasFile);
            this.resolvedFile = resolvedFile;
        }

        public File getFile() {
            return this.resolvedFile;
        }

        public String getFileKind() {
            return "alias";
        }

        public boolean isAlias() {
            return false;
        }
    }

    private class RootNode
    extends DirectoryNode {
        public RootNode() {
            super(COMPUTER);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public void lazyInvalidateChildren() {
            super.lazyInvalidateChildren();
        }

        public String toString() {
            return "Root#" + this.hashCode();
        }

        protected long getDirectoryTTL() {
            return 1000L;
        }

        protected File[] getFiles() {
            LinkedList<File> list = new LinkedList<File>();
            File[] files = AliasFileSystemTreeModel.this.getFileSystemView().getRoots();
            for (int i = 0; i < files.length; ++i) {
                if (!AliasFileSystemTreeModel.this.accept(files[i])) continue;
                list.add(files[i]);
            }
            return list.toArray(new File[list.size()]);
        }

        public String getUserName() {
            return "Computer";
        }
    }

    public class DirectoryNode
    extends Node {
        private volatile long cacheInvalidationTime;
        int childrenState;
        private ArrayList children;
        private Runnable validator;
        private long bestBeforeTimeMillis = 0L;

        public DirectoryNode(File file) {
            super(file);
        }

        public long getFileLength() {
            return -1L;
        }

        public String getFileKind() {
            return "folder";
        }

        public void invalidateChildren() {
            this.childrenState = 0;
            this.validator = null;
        }

        public void lazyInvalidateChildren() {
            if (this.validator == null && this.bestBeforeTimeMillis < System.currentTimeMillis()) {
                this.childrenState = 0;
            }
        }

        public boolean isValidatingChildren() {
            return this.validator != null;
        }

        public void stopValidationSubtree() {
            this.validator = null;
            Enumeration i = super.children();
            while (i.hasMoreElements()) {
                ((Node)i.nextElement()).stopValidationSubtree();
            }
        }

        public void invalidateTree() {
            this.invalidateChildren();
            Enumeration i = super.children();
            while (i.hasMoreElements()) {
                ((Node)i.nextElement()).invalidateTree();
            }
        }

        public void validateChildren() {
            if (this.childrenState == 0) {
                this.childrenState = 1;
                this.validator = new DirectoryValidator();
                AliasFileSystemTreeModel.this.directoryDispatcher.dispatch(this.validator, this.bestBeforeTimeMillis == 0L);
                Node parent = (Node)this.getParent();
                if (parent != null) {
                    AliasFileSystemTreeModel.this.fireTreeNodesChanged(this, parent.getPath(), new int[]{parent.getIndex(this)}, new Object[]{this});
                }
                this.bestBeforeTimeMillis = System.currentTimeMillis() + this.getDirectoryTTL();
            }
        }

        public void autoValidateChildren() {
            if (AliasFileSystemTreeModel.this.isAutoValidate && this.childrenState == 0) {
                this.validateChildren();
            }
        }

        public Enumeration children() {
            this.autoValidateChildren();
            if (this.children == null) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return new IteratorEnumeration(this.children.iterator());
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int childIndex) {
            if (this.children == null) {
                throw new IndexOutOfBoundsException(childIndex + " >= 0");
            }
            this.autoValidateChildren();
            return (TreeNode)this.children.get(childIndex);
        }

        public int getChildCount() {
            this.autoValidateChildren();
            return this.children == null ? 0 : this.children.size();
        }

        public int getIndex(TreeNode node) {
            this.autoValidateChildren();
            return this.children == null ? -1 : this.children.indexOf(node);
        }

        public void insert(MutableTreeNode newChild, int childIndex) {
            this.invalidateChildren();
            if (newChild == null) {
                throw new IllegalArgumentException("new child is null");
            }
            if (this.isNodeAncestor(newChild)) {
                throw new IllegalArgumentException("new child is an ancestor");
            }
            MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
            if (oldParent != null) {
                oldParent.remove(newChild);
            }
            newChild.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(childIndex, newChild);
        }

        public boolean isLeaf() {
            return false;
        }

        public void remove(MutableTreeNode aChild) {
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            if (aChild.getParent() != this) {
                throw new IllegalArgumentException("argument is not a child");
            }
            this.remove(this.getIndex(aChild));
        }

        public void remove(int childIndex) {
            this.invalidateChildren();
            MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
            this.children.remove(childIndex);
            child.setParent(null);
        }

        protected File[] getFiles() {
            File[] files = AliasFileSystemTreeModel.this.getFileSystemView().getFiles(this.getFile(), AliasFileSystemTreeModel.this.fileChooser.isFileHidingEnabled());
            return files;
        }

        protected long getDirectoryTTL() {
            return 2000L;
        }

        static /* synthetic */ ArrayList access$1302(DirectoryNode x0, ArrayList x1) {
            x0.children = x1;
            return x0.children;
        }

        static /* synthetic */ Runnable access$902(DirectoryNode x0, Runnable x1) {
            x0.validator = x1;
            return x0.validator;
        }

        static /* synthetic */ long access$1502(DirectoryNode x0, long x1) {
            x0.bestBeforeTimeMillis = x1;
            return x0.bestBeforeTimeMillis;
        }

        private class DirectoryValidator
        implements Runnable {
            private DirectoryValidator() {
            }

            public void run() {
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                boolean exists = DirectoryNode.this.file != null && DirectoryNode.this.file.exists();
                File[] freshFiles = exists ? DirectoryNode.this.getFiles() : new File[]{};
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                boolean isDirectoriesOnly = AliasFileSystemTreeModel.this.fileChooser.getFileSelectionMode() == 1;
                ArrayList<Node> freshNodeList = new ArrayList<Node>(freshFiles.length);
                for (int i = 0; i < freshFiles.length; ++i) {
                    boolean freshIsTraversable;
                    boolean freshIsAlias;
                    boolean freshIsDirectory = freshFiles[i].isDirectory();
                    File resolvedFreshFile = null;
                    boolean bl = freshIsAlias = !AliasFileSystemTreeModel.this.doItFast && !freshIsDirectory && Files.isAlias(freshFiles[i]);
                    if (freshIsAlias) {
                        resolvedFreshFile = Files.resolveAlias(freshFiles[i]);
                        freshIsTraversable = freshIsDirectory = AliasFileSystemTreeModel.this.fileChooser.isTraversable(resolvedFreshFile);
                        if (!AliasFileSystemTreeModel.this.isResolveAliasesToFiles() && !freshIsDirectory) {
                            freshIsAlias = false;
                            resolvedFreshFile = freshFiles[i];
                        }
                    } else {
                        freshIsTraversable = freshIsDirectory = AliasFileSystemTreeModel.this.fileChooser.isTraversable(freshFiles[i]);
                        resolvedFreshFile = freshFiles[i];
                    }
                    if (isDirectoriesOnly && (!freshIsDirectory || !freshIsTraversable) || !AliasFileSystemTreeModel.this.accept(resolvedFreshFile)) continue;
                    if (freshIsAlias) {
                        if (freshIsDirectory && freshIsTraversable) {
                            freshNodeList.add(new AliasDirectoryNode(freshFiles[i], resolvedFreshFile));
                            continue;
                        }
                        freshNodeList.add(new AliasNode(freshFiles[i], resolvedFreshFile));
                        continue;
                    }
                    if (freshIsDirectory && freshIsTraversable) {
                        freshNodeList.add(new DirectoryNode(freshFiles[i]));
                        continue;
                    }
                    freshNodeList.add(new Node(freshFiles[i]));
                }
                Node[] freshNodes = freshNodeList.toArray(new Node[freshNodeList.size()]);
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                Arrays.sort(freshNodes, AliasFileSystemTreeModel.this.getNodeComparator());
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                ArrayList<Node> mergedChildren = new ArrayList<Node>(freshFiles.length);
                LinkedList<Node> newChildren = new LinkedList<Node>();
                int[] newChildIndices = new int[freshFiles.length];
                LinkedList<Node> deletedChildren = new LinkedList<Node>();
                int[] deletedChildIndices = new int[DirectoryNode.this.getChildCount()];
                Node[] oldNodes = DirectoryNode.this.children == null ? new Node[]{} : DirectoryNode.this.children.toArray(new Node[DirectoryNode.this.children.size()]);
                int count = freshNodes.length + oldNodes.length;
                int freshIndex = 0;
                int oldIndex = 0;
                int mergeIndex = 0;
                int lastFreshIndex = -1;
                Object resolvedFreshFile = null;
                Comparator comparator = AliasFileSystemTreeModel.this.getNodeComparator();
                for (int i = 0; i < count; ++i) {
                    int comparison;
                    if (freshIndex >= freshNodes.length) {
                        comparison = oldIndex >= oldNodes.length ? 0 : 1;
                    } else if (oldIndex >= oldNodes.length) {
                        comparison = -1;
                    } else {
                        comparison = comparator.compare(freshNodes[freshIndex], oldNodes[oldIndex]);
                        if (comparison == 0 && freshNodes[freshIndex].isLeaf() != oldNodes[oldIndex].isLeaf()) {
                            comparison = -1;
                        }
                    }
                    if (comparison < 0) {
                        newChildIndices[newChildren.size()] = mergeIndex++;
                        Node newNode = freshNodes[freshIndex];
                        newNode.parent = DirectoryNode.this;
                        newChildren.add(newNode);
                        mergedChildren.add(newNode);
                        ++freshIndex;
                        continue;
                    }
                    if (comparison == 0) {
                        if (oldIndex < oldNodes.length) {
                            Node oldNode = oldNodes[oldIndex];
                            if (!AliasFileSystemTreeModel.this.doItFast) {
                                oldNode.invalidateInfo();
                            }
                            mergedChildren.add(oldNode);
                        }
                        ++oldIndex;
                        ++freshIndex;
                        ++mergeIndex;
                        continue;
                    }
                    deletedChildIndices[deletedChildren.size()] = mergeIndex + deletedChildren.size() - newChildren.size();
                    deletedChildren.add(oldNodes[oldIndex]);
                    ++oldIndex;
                }
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(this, exists, newChildren, deletedChildren, mergedChildren, newChildIndices, deletedChildIndices, startTime){
                    private final /* synthetic */ boolean val$exists;
                    private final /* synthetic */ LinkedList val$newChildren;
                    private final /* synthetic */ LinkedList val$deletedChildren;
                    private final /* synthetic */ ArrayList val$mergedChildren;
                    private final /* synthetic */ int[] val$newChildIndices;
                    private final /* synthetic */ int[] val$deletedChildIndices;
                    private final /* synthetic */ long val$startTime;
                    private final /* synthetic */ DirectoryValidator this$2;
                    {
                        this.this$2 = this$2;
                        this.val$exists = val$exists;
                        this.val$newChildren = val$newChildren;
                        this.val$deletedChildren = val$deletedChildren;
                        this.val$mergedChildren = val$mergedChildren;
                        this.val$newChildIndices = val$newChildIndices;
                        this.val$deletedChildIndices = val$deletedChildIndices;
                        this.val$startTime = val$startTime;
                    }

                    public void run() {
                        Node parent;
                        if (this.this$2 != DirectoryNode.access$900(DirectoryValidator.access$1400(this.this$2)) || DirectoryValidator.access$1400(this.this$2).getRoot() != DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).getRoot()) {
                            return;
                        }
                        if (!this.val$exists) {
                            parent = DirectoryValidator.access$1400(this.this$2);
                            while ((parent = (Node)parent.getParent()) != null) {
                                parent.lazyInvalidateChildren();
                                parent.validateChildren();
                            }
                        }
                        if (this.val$newChildren.size() > 0 || this.val$deletedChildren.size() > 0) {
                            Iterator<E> i = this.val$deletedChildren.iterator();
                            while (i.hasNext()) {
                                Node n = (Node)i.next();
                                n.parent = null;
                                n.invalidateChildren();
                            }
                            if (this.val$newChildren.size() > 0 && this.val$deletedChildren.size() == 0) {
                                DirectoryNode.access$1302(DirectoryValidator.access$1400(this.this$2), this.val$mergedChildren);
                                DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).fireTreeNodesInserted(DirectoryValidator.access$1400(this.this$2), DirectoryValidator.access$1400(this.this$2).getPath(), ArrayUtil.truncate(this.val$newChildIndices, 0, this.val$newChildren.size()), this.val$newChildren.toArray());
                            } else if (this.val$newChildren.size() == 0 && this.val$deletedChildren.size() > 0) {
                                DirectoryNode.access$1302(DirectoryValidator.access$1400(this.this$2), this.val$mergedChildren);
                                DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).fireTreeNodesRemoved(DirectoryValidator.access$1400(this.this$2), DirectoryValidator.access$1400(this.this$2).getPath(), ArrayUtil.truncate(this.val$deletedChildIndices, 0, this.val$deletedChildren.size()), this.val$deletedChildren.toArray());
                            } else if (this.val$newChildren.size() > 0 && this.val$deletedChildren.size() > 0) {
                                DirectoryNode.access$1300(DirectoryValidator.access$1400(this.this$2)).removeAll(this.val$deletedChildren);
                                DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).fireTreeNodesRemoved(DirectoryValidator.access$1400(this.this$2), DirectoryValidator.access$1400(this.this$2).getPath(), ArrayUtil.truncate(this.val$deletedChildIndices, 0, this.val$deletedChildren.size()), this.val$deletedChildren.toArray());
                                DirectoryNode.access$1302(DirectoryValidator.access$1400(this.this$2), this.val$mergedChildren);
                                DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).fireTreeNodesInserted(DirectoryValidator.access$1400(this.this$2), DirectoryValidator.access$1400(this.this$2).getPath(), ArrayUtil.truncate(this.val$newChildIndices, 0, this.val$newChildren.size()), this.val$newChildren.toArray());
                            }
                        }
                        DirectoryNode.access$902(DirectoryValidator.access$1400(this.this$2), null);
                        parent = (Node)DirectoryValidator.access$1400(this.this$2).getParent();
                        if (parent != null) {
                            DirectoryNode.access$1000(DirectoryValidator.access$1400(this.this$2)).fireTreeNodesChanged(DirectoryValidator.access$1400(this.this$2), parent.getPath(), new int[]{parent.getIndex(DirectoryValidator.access$1400(this.this$2))}, new Object[]{DirectoryValidator.access$1400(this.this$2)});
                        }
                        long endTime = System.currentTimeMillis();
                        DirectoryNode.access$1502(DirectoryValidator.access$1400(this.this$2), endTime + DirectoryValidator.access$1400(this.this$2).getDirectoryTTL() + (endTime - this.val$startTime) * 3L);
                        DirectoryValidator.access$1400((DirectoryValidator)this.this$2).childrenState = 2;
                    }
                });
            }

            static /* synthetic */ DirectoryNode access$1400(DirectoryValidator x0) {
                return x0.DirectoryNode.this;
            }
        }
    }

    public class Node
    implements MutableTreeNode,
    FileInfo {
        protected TreeNode parent;
        protected File file;
        protected String userName;
        protected CollationKey collationKey;
        protected int fileLabel = -1;
        protected Icon icon;
        private int infoState = 0;

        public Node(File f) {
            this(f, this$0.fileChooser.getName(f));
        }

        public Node(File f, String userName) {
            this.file = f;
            this.userName = userName;
            this.collationKey = AliasFileSystemTreeModel.this.getCollator().getCollationKey(userName);
        }

        public File getFile() {
            return this.file;
        }

        public File getUnresolvedFile() {
            return this.file;
        }

        public long getFileLength() {
            return this.file.isDirectory() ? -1L : this.file.length();
        }

        public String getUserName() {
            return this.userName;
        }

        public int getFileLabel() {
            this.validateInfo();
            return this.fileLabel;
        }

        public Icon getIcon() {
            this.validateInfo();
            if (this.icon == null) {
                return this.isLeaf() ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon");
            }
            return this.icon;
        }

        public CollationKey getCollationKey() {
            return this.collationKey;
        }

        public boolean isAlias() {
            return false;
        }

        public String getFileKind() {
            if (this.file.isDirectory()) {
                String path = this.file.getPath();
                if (path.endsWith(".app")) {
                    return "application";
                }
                if (path.endsWith(".wdgt")) {
                    return "widget";
                }
                return "folder";
            }
            return "document";
        }

        public void invalidateInfo() {
            this.infoState = 0;
        }

        public void validateInfo() {
            if (this.infoState == 0) {
                this.infoState = 1;
                AliasFileSystemTreeModel.this.fileInfoDispatcher.dispatch(new Worker(){

                    public Object construct() {
                        if (!AliasFileSystemTreeModel.this.doItFast) {
                            icon = AliasFileSystemTreeModel.this.fileChooser.getIcon(file);
                            if (AliasFileSystemTreeModel.this.isResolveFileLabels) {
                                fileLabel = Files.getFileLabel(file);
                            }
                        }
                        return null;
                    }

                    public void finished(Object value) {
                        AliasFileSystemTreeModel.this.fireTreeNodeChanged(this);
                        infoState = 2;
                    }
                });
            }
        }

        public void invalidateChildren() {
        }

        public void lazyInvalidateChildren() {
        }

        public void stopValidationSubtree() {
        }

        public void invalidateTree() {
        }

        public void validateChildren() {
        }

        public boolean isValidating() {
            return this.isValidatingChildren();
        }

        public boolean isValidatingChildren() {
            return false;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(MutableTreeNode newParent) {
            this.parent = newParent;
        }

        public void removeFromParent() {
            MutableTreeNode parent = (MutableTreeNode)this.getParent();
            if (parent != null) {
                parent.remove(this);
            }
        }

        public void setUserObject(Object object) {
            this.file = (File)object;
        }

        public TreeNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
            TreeNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new TreeNode[depth];
            } else {
                retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }

        public TreeNode getRoot() {
            Node previous;
            TreeNode ancestor = this;
            do {
                previous = ancestor;
            } while ((ancestor = ancestor.getParent()) != null);
            return previous;
        }

        public boolean isNodeAncestor(TreeNode anotherNode) {
            if (anotherNode == null) {
                return false;
            }
            TreeNode ancestor = this;
            do {
                if (ancestor != anotherNode) continue;
                return true;
            } while ((ancestor = ancestor.getParent()) != null);
            return false;
        }

        public String toString() {
            return this.userName;
        }

        public Enumeration children() {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public TreeNode getChildAt(int childIndex) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public void insert(MutableTreeNode child, int index) {
            throw new IllegalStateException("node does not allow children");
        }

        public boolean isLeaf() {
            return true;
        }

        public void remove(MutableTreeNode node) {
            throw new IllegalArgumentException("argument is not a child");
        }

        public void remove(int index) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        public boolean isTraversable() {
            return !this.isLeaf();
        }
    }
}

