/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.HexNumberFormat;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;

public class RegDWordValue
extends RegistryValue {
    int data;
    int dataLen;

    public RegDWordValue(RegistryKey key, String name) {
        super(key, name, 4);
        this.data = 0;
        this.dataLen = 0;
    }

    public RegDWordValue(RegistryKey key, String name, int type) {
        super(key, name, type);
        this.data = 0;
        this.dataLen = 0;
    }

    public RegDWordValue(RegistryKey key, String name, int type, int data) {
        super(key, name, 4);
        this.setData(data);
    }

    public int getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLen;
    }

    public void setData(int data) {
        this.data = data;
        this.dataLen = 1;
    }

    public byte[] getByteData() {
        byte[] result = new byte[]{(byte)(this.data >> 24 & 0xFF), (byte)(this.data >> 16 & 0xFF), (byte)(this.data >> 8 & 0xFF), (byte)(this.data & 0xFF)};
        return result;
    }

    public int getByteLength() {
        return 4;
    }

    public void setByteData(byte[] data) {
        int newValue = data[0] << 24 & 0xFF000000 | data[1] << 16 & 0xFF0000 | data[2] << 8 & 0xFF00 | data[3] & 0xFF;
        this.setData(newValue);
    }

    public void export(PrintWriter out) {
        out.print("\"" + this.getName() + "\"=");
        HexNumberFormat nFmt = new HexNumberFormat("xxxxxxxx");
        out.println("dword:" + nFmt.format(this.getData()));
    }
}

